/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.java.ExplodedDirectoryModuleExtension;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsAnnotationRootType;
import org.jetbrains.jps.model.java.JpsJavaDependencyExtension;
import org.jetbrains.jps.model.java.JpsJavaDependencyScope;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.java.JpsNativeLibraryRootType;
import org.jetbrains.jps.model.java.JpsProductionModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.JpsProductionModuleSourcePackagingElement;
import org.jetbrains.jps.model.java.JpsTestModuleOutputPackagingElement;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsRepositoryLibraryType;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsCompilerValidationExcludeSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsEclipseCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerNotNullableSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsJavaCompilerWorkspaceConfigurationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.JpsValidationSerializer;
import org.jetbrains.jps.model.serialization.java.compiler.RmicCompilerOptionsSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryPropertiesSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryRootTypeSerializer;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

public class JpsJavaModelSerializerExtension
extends JpsModelSerializerExtension {
    public static final String EXPORTED_ATTRIBUTE = "exported";
    public static final String SCOPE_ATTRIBUTE = "scope";
    public static final String OUTPUT_TAG = "output";
    public static final String URL_ATTRIBUTE = "url";
    public static final String LANGUAGE_LEVEL_ATTRIBUTE = "languageLevel";
    public static final String EXPLODED_TAG = "exploded";
    public static final String EXCLUDE_EXPLODED_TAG = "exclude-exploded";
    public static final String TEST_OUTPUT_TAG = "output-test";
    public static final String INHERIT_COMPILER_OUTPUT_ATTRIBUTE = "inherit-compiler-output";
    public static final String EXCLUDE_OUTPUT_TAG = "exclude-output";
    public static final String ANNOTATION_PATHS_TAG = "annotation-paths";
    public static final String JAVADOC_PATHS_TAG = "javadoc-paths";
    public static final String MODULE_LANGUAGE_LEVEL_ATTRIBUTE = "LANGUAGE_LEVEL";
    public static final String ROOT_TAG = "root";
    public static final String RELATIVE_OUTPUT_PATH_ATTRIBUTE = "relativeOutputPath";
    public static final String IS_GENERATED_ATTRIBUTE = "generated";
    public static final JavaSourceRootPropertiesSerializer JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER = new JavaSourceRootPropertiesSerializer(JavaSourceRootType.SOURCE, "java-source");
    public static final String JAVA_RESOURCE_ROOT_ID = "java-resource";
    public static final String JAVA_TEST_RESOURCE_ROOT_ID = "java-test-resource";

    @Override
    public void loadRootModel(@NotNull JpsModule module2, @NotNull Element rootModel) {
        if (module2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(1);
        }
        JpsJavaModelSerializerExtension.loadExplodedDirectoryExtension(module2, rootModel);
        JpsJavaModelSerializerExtension.loadJavaModuleExtension(module2, rootModel);
    }

    @Override
    public void saveRootModel(@NotNull JpsModule module2, @NotNull Element rootModel) {
        if (module2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(2);
        }
        if (rootModel == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(3);
        }
        JpsJavaModelSerializerExtension.saveExplodedDirectoryExtension(module2, rootModel);
        JpsJavaModelSerializerExtension.saveJavaModuleExtension(module2, rootModel);
    }

    @Override
    public void loadModuleOptions(@NotNull JpsModule module2, @NotNull Element rootElement) {
        String productionModuleName;
        Element testModuleProperties;
        if (module2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(4);
        }
        if (rootElement == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(5);
        }
        if ((testModuleProperties = JDomSerializationUtil.findComponent(rootElement, "TestModuleProperties")) != null && (productionModuleName = testModuleProperties.getAttributeValue("production-module")) != null) {
            JpsJavaModelSerializerExtension.getService().setTestModuleProperties(module2, JpsElementFactory.getInstance().createModuleReference(productionModuleName));
        }
    }

    @Override
    @NotNull
    public List<? extends JpsProjectExtensionSerializer> getProjectExtensionSerializers() {
        List<JpsProjectExtensionSerializer> list2 = Arrays.asList(new JavaProjectExtensionSerializer(), new JpsJavaCompilerConfigurationSerializer(), new JpsValidationSerializer(), new JpsJavaCompilerNotNullableSerializer(), new JpsCompilerValidationExcludeSerializer(), new JpsJavaCompilerWorkspaceConfigurationSerializer(), new JpsJavaCompilerOptionsSerializer("JavacSettings", "Javac"), new JpsEclipseCompilerOptionsSerializer("EclipseCompilerSettings", "Eclipse"), new RmicCompilerOptionsSerializer("RmicSettings", "Rmic"));
        if (list2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends JpsModuleSourceRootPropertiesSerializer<?>> getModuleSourceRootPropertiesSerializers() {
        List<JpsModuleSourceRootPropertiesSerializer> list2 = Arrays.asList(JAVA_SOURCE_ROOT_PROPERTIES_SERIALIZER, new JavaSourceRootPropertiesSerializer(JavaSourceRootType.TEST_SOURCE, "java-test"), new JavaResourceRootPropertiesSerializer(JavaResourceRootType.RESOURCE, JAVA_RESOURCE_ROOT_ID), new JavaResourceRootPropertiesSerializer(JavaResourceRootType.TEST_RESOURCE, JAVA_TEST_RESOURCE_ROOT_ID));
        if (list2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    public void loadModuleDependencyProperties(JpsDependencyElement dependency, Element entry) {
        JpsJavaDependencyScope scope2;
        boolean exported2 = entry.getAttributeValue(EXPORTED_ATTRIBUTE) != null;
        String scopeName = entry.getAttributeValue(SCOPE_ATTRIBUTE);
        try {
            scope2 = scopeName != null ? JpsJavaDependencyScope.valueOf(scopeName) : JpsJavaDependencyScope.COMPILE;
        }
        catch (IllegalArgumentException e) {
            scope2 = JpsJavaDependencyScope.COMPILE;
        }
        JpsJavaDependencyExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateDependencyExtension(dependency);
        extension.setExported(exported2);
        extension.setScope(scope2);
    }

    @Override
    public void saveModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        JpsJavaDependencyExtension extension = JpsJavaModelSerializerExtension.getService().getDependencyExtension(dependency);
        if (extension != null) {
            JpsJavaDependencyScope scope2;
            if (extension.isExported()) {
                orderEntry.setAttribute(EXPORTED_ATTRIBUTE, "");
            }
            if ((scope2 = extension.getScope()) != JpsJavaDependencyScope.COMPILE) {
                orderEntry.setAttribute(SCOPE_ATTRIBUTE, scope2.name());
            }
        }
    }

    @Override
    public List<JpsLibraryRootTypeSerializer> getLibraryRootTypeSerializers() {
        return Arrays.asList(new JpsLibraryRootTypeSerializer("JAVADOC", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("ANNOTATIONS", JpsAnnotationRootType.INSTANCE, false), new JpsLibraryRootTypeSerializer("NATIVE", JpsNativeLibraryRootType.INSTANCE, false));
    }

    @Override
    @NotNull
    public List<JpsLibraryRootTypeSerializer> getSdkRootTypeSerializers() {
        List<JpsLibraryRootTypeSerializer> list2 = Arrays.asList(new JpsLibraryRootTypeSerializer("javadocPath", JpsOrderRootType.DOCUMENTATION, true), new JpsLibraryRootTypeSerializer("annotationsPath", JpsAnnotationRootType.INSTANCE, true));
        if (list2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List<JpsPackagingElementSerializer> list2 = Arrays.asList(new JpsModuleOutputPackagingElementSerializer(), new JpsTestModuleOutputPackagingElementSerializer(), new JpsModuleSourcePackagingElementSerializer());
        if (list2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends JpsLibraryPropertiesSerializer<?>> getLibraryPropertiesSerializers() {
        List<JpsRepositoryLibraryPropertiesSerializer> list2 = Collections.singletonList(new JpsRepositoryLibraryPropertiesSerializer());
        if (list2 == null) {
            JpsJavaModelSerializerExtension.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static void loadExplodedDirectoryExtension(JpsModule module2, Element rootModelComponent) {
        Element exploded = rootModelComponent.getChild(EXPLODED_TAG);
        if (exploded != null) {
            ExplodedDirectoryModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateExplodedDirectoryExtension(module2);
            extension.setExcludeExploded(rootModelComponent.getChild(EXCLUDE_EXPLODED_TAG) != null);
            extension.setExplodedUrl(exploded.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static void saveExplodedDirectoryExtension(JpsModule module2, Element rootModelElement) {
        ExplodedDirectoryModuleExtension extension = JpsJavaModelSerializerExtension.getService().getExplodedDirectoryExtension(module2);
        if (extension != null) {
            if (extension.isExcludeExploded()) {
                rootModelElement.addContent(0, (Content)new Element(EXCLUDE_EXPLODED_TAG));
            }
            rootModelElement.addContent(0, (Content)new Element(EXPLODED_TAG).setAttribute(URL_ATTRIBUTE, extension.getExplodedUrl()));
        }
    }

    private static void loadJavaModuleExtension(JpsModule module2, Element rootModelComponent) {
        JpsJavaModuleExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateModuleExtension(module2);
        Element outputTag = rootModelComponent.getChild(OUTPUT_TAG);
        String outputUrl = outputTag != null ? outputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setOutputUrl(outputUrl);
        Element testOutputTag = rootModelComponent.getChild(TEST_OUTPUT_TAG);
        String testOutputUrl = testOutputTag != null ? testOutputTag.getAttributeValue(URL_ATTRIBUTE) : null;
        extension.setTestOutputUrl(StringUtil.isEmpty((String)testOutputUrl) ? outputUrl : testOutputUrl);
        extension.setInheritOutput(Boolean.parseBoolean(rootModelComponent.getAttributeValue(INHERIT_COMPILER_OUTPUT_ATTRIBUTE)));
        extension.setExcludeOutput(rootModelComponent.getChild(EXCLUDE_OUTPUT_TAG) != null);
        String languageLevel = rootModelComponent.getAttributeValue(MODULE_LANGUAGE_LEVEL_ATTRIBUTE);
        if (languageLevel != null) {
            extension.setLanguageLevel(JpsJavaModelSerializerExtension.readLanguageLevel(languageLevel, null));
        }
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, ANNOTATION_PATHS_TAG, extension.getAnnotationRoots());
        JpsJavaModelSerializerExtension.loadAdditionalRoots(rootModelComponent, JAVADOC_PATHS_TAG, extension.getJavadocRoots());
    }

    private static void saveJavaModuleExtension(JpsModule module2, Element rootModelComponent) {
        LanguageLevel languageLevel;
        String outputUrl;
        String testOutputUrl;
        JpsJavaModuleExtension extension = JpsJavaModelSerializerExtension.getService().getModuleExtension(module2);
        if (extension == null) {
            return;
        }
        if (extension.isExcludeOutput()) {
            rootModelComponent.addContent(0, (Content)new Element(EXCLUDE_OUTPUT_TAG));
        }
        if ((testOutputUrl = extension.getTestOutputUrl()) != null) {
            rootModelComponent.addContent(0, (Content)new Element(TEST_OUTPUT_TAG).setAttribute(URL_ATTRIBUTE, testOutputUrl));
        }
        if ((outputUrl = extension.getOutputUrl()) != null) {
            rootModelComponent.addContent(0, (Content)new Element(OUTPUT_TAG).setAttribute(URL_ATTRIBUTE, outputUrl));
        }
        if ((languageLevel = extension.getLanguageLevel()) != null) {
            rootModelComponent.setAttribute(MODULE_LANGUAGE_LEVEL_ATTRIBUTE, languageLevel.name());
        }
        if (extension.isInheritOutput()) {
            rootModelComponent.setAttribute(INHERIT_COMPILER_OUTPUT_ATTRIBUTE, "true");
        }
        JpsJavaModelSerializerExtension.saveAdditionalRoots(rootModelComponent, ANNOTATION_PATHS_TAG, extension.getAnnotationRoots());
        JpsJavaModelSerializerExtension.saveAdditionalRoots(rootModelComponent, JAVADOC_PATHS_TAG, extension.getJavadocRoots());
    }

    private static void loadAdditionalRoots(Element rootModelComponent, String rootsTagName, JpsUrlList result2) {
        Element roots2 = rootModelComponent.getChild(rootsTagName);
        for (Element root2 : JDOMUtil.getChildren((Element)roots2, (String)ROOT_TAG)) {
            result2.addUrl(root2.getAttributeValue(URL_ATTRIBUTE));
        }
    }

    private static void saveAdditionalRoots(Element rootModelComponent, String rootsTagName, JpsUrlList list2) {
        List<String> urls = list2.getUrls();
        if (!urls.isEmpty()) {
            Element roots2 = new Element(rootsTagName);
            for (String url : urls) {
                roots2.addContent(new Element(ROOT_TAG).setAttribute(URL_ATTRIBUTE, url));
            }
            rootModelComponent.addContent(roots2);
        }
    }

    private static JpsJavaExtensionService getService() {
        return JpsJavaExtensionService.getInstance();
    }

    private static LanguageLevel readLanguageLevel(String level, LanguageLevel defaultLevel) {
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            if (!level.equals(languageLevel.name())) continue;
            return languageLevel;
        }
        return defaultLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectExtensionSerializers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSourceRootPropertiesSerializers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootTypeSerializers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagingElementSerializers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryPropertiesSerializers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadRootModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveRootModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadModuleOptions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JpsRepositoryLibraryPropertiesSerializer
    extends JpsLibraryPropertiesSerializer<JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor>> {
        private static final String MAVEN_ID_ATTRIBUTE = "maven-id";
        private static final String INCLUDE_TRANSITIVE_DEPS_ATTRIBUTE = "include-transitive-deps";
        private static final String EXCLUDE_TAG = "exclude";
        private static final String DEPENDENCY_TAG = "dependency";

        JpsRepositoryLibraryPropertiesSerializer() {
            super(JpsRepositoryLibraryType.INSTANCE, JpsRepositoryLibraryType.INSTANCE.getTypeId());
        }

        @Override
        public JpsSimpleElement<JpsMavenRepositoryLibraryDescriptor> loadProperties(@Nullable Element elem) {
            return JpsElementFactory.getInstance().createSimpleElement(JpsRepositoryLibraryPropertiesSerializer.loadDescriptor(elem));
        }

        @NotNull
        private static JpsMavenRepositoryLibraryDescriptor loadDescriptor(@Nullable Element elem) {
            if (elem == null) {
                return new JpsMavenRepositoryLibraryDescriptor(null);
            }
            boolean includeTransitiveDependencies = Boolean.parseBoolean(elem.getAttributeValue(INCLUDE_TRANSITIVE_DEPS_ATTRIBUTE, "true"));
            Element excludeTag = elem.getChild(EXCLUDE_TAG);
            List dependencyTags = excludeTag != null ? excludeTag.getChildren(DEPENDENCY_TAG) : Collections.emptyList();
            List excludedDependencies = ContainerUtil.map((Collection)dependencyTags, it -> it.getAttributeValue(MAVEN_ID_ATTRIBUTE));
            return new JpsMavenRepositoryLibraryDescriptor(elem.getAttributeValue(MAVEN_ID_ATTRIBUTE, (String)null), includeTransitiveDependencies, excludedDependencies);
        }
    }

    private static final class JavaResourceRootPropertiesSerializer
    extends JpsModuleSourceRootPropertiesSerializer<JavaResourceRootProperties> {
        private JavaResourceRootPropertiesSerializer(JpsModuleSourceRootType<JavaResourceRootProperties> type2, String typeId) {
            super(type2, typeId);
        }

        @Override
        public JavaResourceRootProperties loadProperties(@NotNull Element sourceRootTag) {
            if (sourceRootTag == null) {
                JavaResourceRootPropertiesSerializer.$$$reportNull$$$0(0);
            }
            String relativeOutputPath = StringUtil.notNullize((String)sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.RELATIVE_OUTPUT_PATH_ATTRIBUTE));
            boolean isGenerated = Boolean.parseBoolean(sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE));
            return JpsJavaModelSerializerExtension.getService().createResourceRootProperties(relativeOutputPath, isGenerated);
        }

        @Override
        public void saveProperties(@NotNull JavaResourceRootProperties properties2, @NotNull Element sourceRootTag) {
            String relativeOutputPath;
            if (properties2 == null) {
                JavaResourceRootPropertiesSerializer.$$$reportNull$$$0(1);
            }
            if (sourceRootTag == null) {
                JavaResourceRootPropertiesSerializer.$$$reportNull$$$0(2);
            }
            if (!(relativeOutputPath = properties2.getRelativeOutputPath()).isEmpty()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.RELATIVE_OUTPUT_PATH_ATTRIBUTE, relativeOutputPath);
            }
            if (properties2.isForGeneratedSources()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE, Boolean.TRUE.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRootTag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaResourceRootPropertiesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadProperties";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveProperties";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JavaSourceRootPropertiesSerializer
    extends JpsModuleSourceRootPropertiesSerializer<JavaSourceRootProperties> {
        private JavaSourceRootPropertiesSerializer(JpsModuleSourceRootType<JavaSourceRootProperties> type2, String typeId) {
            super(type2, typeId);
        }

        @Override
        public JavaSourceRootProperties loadProperties(@NotNull Element sourceRootTag) {
            if (sourceRootTag == null) {
                JavaSourceRootPropertiesSerializer.$$$reportNull$$$0(0);
            }
            String packagePrefix = StringUtil.notNullize((String)sourceRootTag.getAttributeValue("packagePrefix"));
            boolean isGenerated = Boolean.parseBoolean(sourceRootTag.getAttributeValue(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE));
            return JpsJavaModelSerializerExtension.getService().createSourceRootProperties(packagePrefix, isGenerated);
        }

        @Override
        public void saveProperties(@NotNull JavaSourceRootProperties properties2, @NotNull Element sourceRootTag) {
            if (properties2 == null) {
                JavaSourceRootPropertiesSerializer.$$$reportNull$$$0(1);
            }
            if (sourceRootTag == null) {
                JavaSourceRootPropertiesSerializer.$$$reportNull$$$0(2);
            }
            String isTestSource = Boolean.toString(((JpsModuleSourceRootType)this.getType()).equals(JavaSourceRootType.TEST_SOURCE));
            sourceRootTag.setAttribute("isTestSource", isTestSource);
            String packagePrefix = properties2.getPackagePrefix();
            if (!packagePrefix.isEmpty()) {
                sourceRootTag.setAttribute("packagePrefix", packagePrefix);
            }
            if (properties2.isForGeneratedSources()) {
                sourceRootTag.setAttribute(JpsJavaModelSerializerExtension.IS_GENERATED_ATTRIBUTE, Boolean.TRUE.toString());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRootTag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaSourceRootPropertiesSerializer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadProperties";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "saveProperties";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JavaProjectExtensionSerializer
    extends JpsProjectExtensionSerializer {
        JavaProjectExtensionSerializer() {
            super(null, "ProjectRootManager");
        }

        @Override
        public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
            String languageLevel;
            String url;
            if (project == null) {
                JavaProjectExtensionSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                JavaProjectExtensionSerializer.$$$reportNull$$$0(1);
            }
            JpsJavaProjectExtension extension = JpsJavaModelSerializerExtension.getService().getOrCreateProjectExtension(project);
            Element output = componentTag.getChild(JpsJavaModelSerializerExtension.OUTPUT_TAG);
            if (output != null && (url = output.getAttributeValue(JpsJavaModelSerializerExtension.URL_ATTRIBUTE)) != null) {
                extension.setOutputUrl(url);
            }
            if ((languageLevel = componentTag.getAttributeValue(JpsJavaModelSerializerExtension.LANGUAGE_LEVEL_ATTRIBUTE)) != null) {
                extension.setLanguageLevel(JpsJavaModelSerializerExtension.readLanguageLevel(languageLevel, LanguageLevel.HIGHEST));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/model/serialization/java/JpsJavaModelSerializerExtension$JavaProjectExtensionSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JpsTestModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsTestModuleOutputPackagingElement> {
        private JpsTestModuleOutputPackagingElementSerializer() {
            super("module-test-output", JpsTestModuleOutputPackagingElement.class);
        }

        @Override
        public JpsTestModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createTestModuleOutput(reference);
        }
    }

    private static final class JpsModuleSourcePackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsProductionModuleSourcePackagingElement> {
        private JpsModuleSourcePackagingElementSerializer() {
            super("module-source", JpsProductionModuleSourcePackagingElement.class);
        }

        @Override
        public JpsProductionModuleSourcePackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createProductionModuleSource(reference);
        }
    }

    private static final class JpsModuleOutputPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsProductionModuleOutputPackagingElement> {
        private JpsModuleOutputPackagingElementSerializer() {
            super("module-output", JpsProductionModuleOutputPackagingElement.class);
        }

        @Override
        public JpsProductionModuleOutputPackagingElement load(Element element) {
            JpsModuleReference reference = JpsElementFactory.getInstance().createModuleReference(element.getAttributeValue("name"));
            return JpsJavaModelSerializerExtension.getService().createProductionModuleOutput(reference);
        }
    }
}

