/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory0;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirFunctionNameChecker
extends FirDeclarationChecker<FirFunction<?>> {
    @NotNull
    public static final FirFunctionNameChecker INSTANCE = new FirFunctionNameChecker();

    private FirFunctionNameChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirFunction<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        boolean isNonLocal;
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirSourceElement source = declaration2.getSource();
        if (source == null || source.getKind() instanceof FirFakeSourceElementKind) {
            return;
        }
        FirDeclaration containingDeclaration = (FirDeclaration)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        boolean bl = isNonLocal = containingDeclaration instanceof FirFile || containingDeclaration instanceof FirClass;
        if (declaration2 instanceof FirSimpleFunction && Intrinsics.areEqual((Object)((FirSimpleFunction)declaration2).getName(), (Object)SpecialNames.NO_NAME_PROVIDED) && isNonLocal) {
            void $this$report$iv;
            FirSourceElement firSourceElement;
            DiagnosticReporter diagnosticReporter = reporter2;
            FirDiagnosticFactory0<FirSourceElement, KtFunction> factory$iv = FirErrors.INSTANCE.getFUNCTION_DECLARATION_WITH_NO_NAME();
            boolean $i$f$report = false;
            FirSourceElement firSourceElement2 = firSourceElement = source;
            boolean bl2 = false;
            boolean bl3 = false;
            FirSourceElement it$iv = firSourceElement2;
            boolean bl4 = false;
            $this$report$iv.report((FirDiagnostic)factory$iv.on(it$iv));
        }
    }
}

