/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.impl;

import java.io.File;
import java.io.Serializable;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u001e\u0010\r\u001a\u0004\u0018\u00010\u00012\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u001a\u0018\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\u001a\u000e\u0010\u0019\u001a\u0004\u0018\u00010\n*\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"FILE_PROTOCOL", "", "JAR_PROTOCOL", "JAR_SEPARATOR", "SCHEME_SEPARATOR", "extractRoot", "resourceURL", "Ljava/net/URL;", "resourcePath", "getResourcePathForClass", "Ljava/io/File;", "aClass", "Ljava/lang/Class;", "getResourceRoot", "context", "path", "splitJarUrl", "Lkotlin/Pair;", "url", "tryGetResourcePathForClass", "tryGetResourcePathForClassByName", "name", "classLoader", "Ljava/lang/ClassLoader;", "toContainingJarOrNull", "toFileOrNull", "kotlin-scripting-jvm"})
public final class PathUtilKt {
    @NotNull
    private static final String JAR_PROTOCOL = "jar";
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String JAR_SEPARATOR = "!/";
    @NotNull
    private static final String SCHEME_SEPARATOR = "://";

    @Nullable
    public static final String getResourceRoot(@NotNull Class<?> context2, @NotNull String path2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        URL url = context2.getResource(path2);
        if (url == null) {
            String string2 = path2;
            int n = 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            url = ClassLoader.getSystemResource(string3);
        }
        return url != null ? PathUtilKt.extractRoot(url, path2) : null;
    }

    private static final String extractRoot(URL resourceURL, String resourcePath) {
        String string2;
        String string3;
        Pair<String, String> pair;
        if (!StringsKt.startsWith$default((CharSequence)resourcePath, (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)resourcePath, (char)'\\', (boolean)false, (int)2, null)) {
            return null;
        }
        String resultPath = null;
        String protocol = resourceURL.getProtocol();
        if (Intrinsics.areEqual((Object)protocol, (Object)FILE_PROTOCOL)) {
            pair = PathUtilKt.toFileOrNull(resourceURL);
            Intrinsics.checkNotNull((Object)pair);
            String path2 = pair.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
            String testPath = StringsKt.replace$default((String)path2, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            String testResourcePath = StringsKt.replace$default((String)resourcePath, (char)'\\', (char)'/', (boolean)false, (int)4, null);
            if (StringsKt.endsWith((String)testPath, (String)testResourcePath, (boolean)true)) {
                String string4 = path2;
                int n = 0;
                int n2 = path2.length() - resourcePath.length();
                boolean bl = false;
                String string5 = string4.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                resultPath = string5;
            }
        } else if (Intrinsics.areEqual((Object)protocol, (Object)JAR_PROTOCOL)) {
            Pair<String, String> paths;
            pair = resourceURL.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"resourceURL.file");
            pair = paths = PathUtilKt.splitJarUrl((String)pair);
            if ((pair == null ? null : (String)pair.getFirst()) != null) {
                resultPath = new File((String)paths.getFirst()).getCanonicalPath();
            }
        }
        if ((string3 = resultPath) == null) {
            string2 = null;
        } else {
            pair = (Pair<String, String>)new char[1];
            pair[0] = (Pair<String, String>)File.separatorChar;
            string2 = StringsKt.trimEnd(string3, pair);
        }
        return string2;
    }

    private static final Pair<String, String> splitJarUrl(String url) {
        String jarPath;
        String resourcePath;
        block12: {
            Integer n;
            Object object = StringsKt.indexOf$default((CharSequence)url, (String)JAR_SEPARATOR, (int)0, (boolean)false, (int)6, null);
            int n2 = 0;
            int n3 = 0;
            int it = ((Number)object).intValue();
            boolean bl = false;
            Integer n4 = n = it >= 0 ? object : null;
            if (n == null) {
                return null;
            }
            int pivot = n;
            object = url;
            n2 = pivot + 2;
            n3 = 0;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object2).substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            resourcePath = string2;
            String string3 = url;
            n3 = 0;
            int n5 = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n3, pivot);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jarPath = string5;
            if (StringsKt.startsWith$default((String)jarPath, (String)"jar:", (boolean)false, (int)2, null)) {
                string3 = jarPath;
                n3 = JAR_PROTOCOL.length() + 1;
                n5 = 0;
                String string6 = string3;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                jarPath = string7;
            }
            if (StringsKt.startsWith$default((String)jarPath, (String)FILE_PROTOCOL, (boolean)false, (int)2, null)) {
                try {
                    File file2 = PathUtilKt.toFileOrNull(new URL(jarPath));
                    Intrinsics.checkNotNull((Object)file2);
                    string3 = file2.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"URL(jarPath).toFileOrNull()!!.path");
                    jarPath = StringsKt.replace$default((String)string3, (char)'\\', (char)'/', (boolean)false, (int)4, null);
                }
                catch (Exception e) {
                    String string8 = jarPath;
                    n5 = FILE_PROTOCOL.length();
                    boolean bl2 = false;
                    String string9 = string8;
                    if (string9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string10 = string9.substring(n5);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string10;
                    if (StringsKt.startsWith$default((String)jarPath, (String)SCHEME_SEPARATOR, (boolean)false, (int)2, null)) {
                        string8 = jarPath;
                        n5 = SCHEME_SEPARATOR.length();
                        bl2 = false;
                        String string11 = string8;
                        if (string11 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string12 = string11.substring(n5);
                        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
                        jarPath = string12;
                    }
                    if (!StringsKt.startsWith$default((CharSequence)jarPath, (char)':', (boolean)false, (int)2, null)) break block12;
                    string8 = jarPath;
                    n5 = 1;
                    bl2 = false;
                    String string13 = string8;
                    if (string13 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string14 = string13.substring(n5);
                    Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"(this as java.lang.String).substring(startIndex)");
                    jarPath = string14;
                }
            }
        }
        return new Pair((Object)jarPath, (Object)resourcePath);
    }

    @Nullable
    public static final File tryGetResourcePathForClass(@NotNull Class<?> aClass) {
        File file2;
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        StringBuilder stringBuilder2 = new StringBuilder().append('/');
        String string2 = aClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"aClass.name");
        String path2 = stringBuilder2.append(StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
        string2 = PathUtilKt.getResourceRoot(aClass, path2);
        if (string2 == null) {
            file2 = null;
        } else {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            file2 = new File(it).getAbsoluteFile();
        }
        return file2;
    }

    @NotNull
    public static final File getResourcePathForClass(@NotNull Class<?> aClass) {
        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
        File file2 = PathUtilKt.tryGetResourcePathForClass(aClass);
        if (file2 == null) {
            throw new IllegalStateException("Resource for class: " + aClass.getName() + " not found");
        }
        return file2;
    }

    @Nullable
    public static final File tryGetResourcePathForClassByName(@NotNull String name2, @NotNull ClassLoader classLoader2) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classLoader2, (String)"classLoader");
        try {
            File file2;
            serializable = classLoader2.loadClass(name2);
            if (serializable == null) {
                file2 = null;
            } else {
                Serializable serializable2 = serializable;
                boolean bl = false;
                boolean bl2 = false;
                Serializable p0 = serializable2;
                boolean bl3 = false;
                file2 = PathUtilKt.tryGetResourcePathForClass(p0);
            }
            serializable = file2;
        }
        catch (ClassNotFoundException _) {
            serializable = null;
        }
        catch (NoClassDefFoundError _) {
            serializable = null;
        }
        return serializable;
    }

    @Nullable
    public static final File toFileOrNull(@NotNull URL $this$toFileOrNull) {
        File file2;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)$this$toFileOrNull, (String)"<this>");
        try {
            serializable = new File($this$toFileOrNull.toURI());
        }
        catch (IllegalArgumentException e) {
            serializable = null;
        }
        catch (URISyntaxException e) {
            serializable = null;
        }
        File file3 = serializable;
        if (file3 == null) {
            serializable = $this$toFileOrNull;
            boolean bl = false;
            boolean bl2 = false;
            Serializable $this$toFileOrNull_u24lambda_u2d2 = serializable;
            boolean bl3 = false;
            file2 = !Intrinsics.areEqual((Object)((URL)$this$toFileOrNull_u24lambda_u2d2).getProtocol(), (Object)FILE_PROTOCOL) ? null : new File(((URL)$this$toFileOrNull_u24lambda_u2d2).getFile());
        } else {
            file2 = file3;
        }
        return file2;
    }

    @Nullable
    public static final File toContainingJarOrNull(@NotNull URL $this$toContainingJarOrNull) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)$this$toContainingJarOrNull, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$toContainingJarOrNull.getProtocol(), (Object)JAR_PROTOCOL)) {
            JarURLConnection jarURLConnection;
            Object object = $this$toContainingJarOrNull.openConnection();
            JarURLConnection jarURLConnection2 = jarURLConnection = object instanceof JarURLConnection ? (JarURLConnection)object : null;
            file2 = jarURLConnection == null ? null : ((object = jarURLConnection.getJarFileURL()) == null ? null : PathUtilKt.toFileOrNull((URL)object));
        } else {
            file2 = null;
        }
        return file2;
    }
}

