/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import kotlin.io.FilesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.common.modules.ModuleXmlParser;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.PathUtil;

public class CompileEnvironmentUtil {
    public static long DOS_EPOCH = new GregorianCalendar(1980, 0, 1, 0, 0, 0).getTimeInMillis();

    @NotNull
    public static ModuleChunk loadModuleChunk(File buildFile, MessageCollector messageCollector2) {
        if (!buildFile.exists()) {
            messageCollector2.report(CompilerMessageSeverity.ERROR, "Module definition file does not exist: " + buildFile, null);
            ModuleChunk moduleChunk2 = ModuleChunk.EMPTY;
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(0);
            }
            if (moduleChunk2 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$1(0);
            }
            return moduleChunk2;
        }
        if ("xml".equalsIgnoreCase(FilesKt.getExtension((File)buildFile))) {
            ModuleChunk moduleChunk3 = ModuleXmlParser.parseModuleScript(buildFile.getPath(), messageCollector2);
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$0(1);
            }
            if (moduleChunk3 == null) {
                CompileEnvironmentUtil.$$$reportNull$$$1(1);
            }
            return moduleChunk3;
        }
        messageCollector2.report(CompilerMessageSeverity.ERROR, "Unknown module definition type: " + buildFile, null);
        ModuleChunk moduleChunk4 = ModuleChunk.EMPTY;
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$0(2);
        }
        if (moduleChunk4 == null) {
            CompileEnvironmentUtil.$$$reportNull$$$1(2);
        }
        return moduleChunk4;
    }

    private static void doWriteToJar(OutputFileCollection outputFiles, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime, boolean noReflect, boolean resetJarTimestamps) {
        try {
            Manifest manifest2 = new Manifest();
            Attributes mainAttributes = manifest2.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.asString());
            }
            JarOutputStream stream = new JarOutputStream(fos);
            JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
            if (resetJarTimestamps) {
                manifestEntry.setTime(DOS_EPOCH);
            }
            stream.putNextEntry(manifestEntry);
            manifest2.write(new BufferedOutputStream(stream));
            for (OutputFile outputFile : outputFiles.asList()) {
                JarEntry entry = new JarEntry(outputFile.getRelativePath());
                if (resetJarTimestamps) {
                    entry.setTime(DOS_EPOCH);
                }
                stream.putNextEntry(entry);
                stream.write(outputFile.asByteArray());
            }
            if (includeRuntime) {
                CompileEnvironmentUtil.writeRuntimeToJar(stream, resetJarTimestamps);
                if (!noReflect) {
                    CompileEnvironmentUtil.writeReflectToJar(stream, resetJarTimestamps);
                }
            }
            stream.finish();
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToJar(File jarPath, boolean jarRuntime, boolean noReflect, boolean resetJarTimestamps, FqName mainClass, OutputFileCollection outputFiles) {
        FileOutputStream outputStream2 = null;
        try {
            outputStream2 = new FileOutputStream(jarPath);
            CompileEnvironmentUtil.doWriteToJar(outputFiles, outputStream2, mainClass, jarRuntime, noReflect, resetJarTimestamps);
            outputStream2.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompileEnvironmentException("Invalid jar path " + jarPath, e);
                catch (IOException e2) {
                    throw ExceptionUtilsKt.rethrow(e2);
                }
            }
            catch (Throwable throwable) {
                ExceptionUtilsKt.closeQuietly(outputStream2);
                throw throwable;
            }
        }
        ExceptionUtilsKt.closeQuietly(outputStream2);
    }

    private static void writeRuntimeToJar(JarOutputStream stream, boolean resetJarTimestamps) throws IOException {
        File stdlibPath = PathUtil.getKotlinPathsForCompiler().getStdlibPath();
        if (!stdlibPath.exists()) {
            throw new CompileEnvironmentException("Couldn't find kotlin-stdlib at " + stdlibPath);
        }
        CompileEnvironmentUtil.copyJarImpl(stream, stdlibPath, resetJarTimestamps);
    }

    private static void writeReflectToJar(JarOutputStream stream, boolean resetJarTimestamps) throws IOException {
        File reflectPath = PathUtil.getKotlinPathsForCompiler().getReflectPath();
        if (!reflectPath.exists()) {
            throw new CompileEnvironmentException("Couldn't find kotlin-reflect at " + reflectPath);
        }
        CompileEnvironmentUtil.copyJarImpl(stream, reflectPath, resetJarTimestamps);
    }

    private static void copyJarImpl(JarOutputStream stream, File jarPath, boolean resetJarTimestamps) throws IOException {
        try (JarInputStream jis = new JarInputStream(new FileInputStream(jarPath));){
            JarEntry e;
            while ((e = jis.getNextJarEntry()) != null) {
                String name2 = e.getName();
                if (!FileUtilRt.extensionEquals((String)name2, (String)"class") && !FileUtilRt.extensionEquals((String)name2, (String)"kotlin_builtins") && !name2.startsWith("META-INF/services/") || StringsKt.substringAfterLast((String)name2, (String)"/", (String)name2).equals("module-info.class")) continue;
                if (resetJarTimestamps) {
                    e.setTime(DOS_EPOCH);
                }
                stream.putNextEntry(e);
                FileUtil.copy((InputStream)jis, (OutputStream)stream);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/jvm/compiler/CompileEnvironmentUtil", "loadModuleChunk"));
    }
}

