/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.interpreter.ExecutionResult;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.FrameContainer;
import org.jetbrains.kotlin.ir.interpreter.stack.InterpreterFrame;
import org.jetbrains.kotlin.ir.interpreter.stack.Stack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tH\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u0007H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/StackImpl;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Stack;", "()V", "frameList", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/FrameContainer;", "addAll", "", "variables", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "addVar", "variable", "clean", "contains", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getAll", "getCurrentFrame", "getStackTrace", "", "getVariable", "hasReturnValue", "newFrame", "Lorg/jetbrains/kotlin/ir/interpreter/ExecutionResult;", "asSubFrame", "initPool", "block", "Lkotlin/Function0;", "peekReturnValue", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "popReturnValue", "pushReturnValue", "state", "removeLastFrame", "setCurrentFrameName", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.interpreter"})
public final class StackImpl
implements Stack {
    @NotNull
    private final List<FrameContainer> frameList;

    public StackImpl() {
        Object[] objectArray = new FrameContainer[]{new FrameContainer(null, 1, null)};
        this.frameList = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    private final FrameContainer getCurrentFrame() {
        return (FrameContainer)CollectionsKt.last(this.frameList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExecutionResult newFrame(boolean asSubFrame, @NotNull List<Variable> initPool, @NotNull Function0<? extends ExecutionResult> block) {
        ExecutionResult executionResult2;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter(initPool, (String)"initPool");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Iterable $this$filter$iv = initPool;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Variable it = (Variable)element$iv$iv;
            boolean bl = false;
            if (!(it.getSymbol() instanceof IrTypeParameterSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List typeArgumentsPool = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = initPool;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Variable it = (Variable)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getSymbol() instanceof IrTypeParameterSymbol))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List valueArguments = (List)destination$iv$iv2;
        InterpreterFrame newFrame2 = new InterpreterFrame(CollectionsKt.toMutableList((Collection)valueArguments), typeArgumentsPool);
        if (asSubFrame) {
            this.getCurrentFrame().addSubFrame(newFrame2);
        } else {
            this.frameList.add(new FrameContainer(newFrame2));
        }
        try {
            executionResult2 = (ExecutionResult)block.invoke();
        }
        finally {
            if (asSubFrame) {
                this.getCurrentFrame().removeSubFrame();
            } else {
                this.removeLastFrame();
            }
        }
        return executionResult2;
    }

    private final void removeLastFrame() {
        if (this.frameList.size() > 1 && this.getCurrentFrame().hasReturnValue()) {
            this.frameList.get(CollectionsKt.getLastIndex(this.frameList) - 1).pushReturnValue(this.getCurrentFrame());
        }
        this.frameList.remove(CollectionsKt.getLastIndex(this.frameList));
    }

    @Override
    public void setCurrentFrameName(@NotNull IrFunction irFunction2) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        String fileName = IrFileKt.getName(IrUtilsKt.getFile(irFunction2));
        String fileNameCapitalized = UtilsKt.getCapitalizedFileName(irFunction2);
        int lineNum = AdditionalIrUtilsKt.getFileEntry(irFunction2).getLineNumber(irFunction2.getStartOffset()) + 1;
        if (this.getCurrentFrame().getFrameEntryPoint() == null) {
            this.getCurrentFrame().setFrameEntryPoint("at " + fileNameCapitalized + '.' + IrUtilsKt.getFqNameWhenAvailable(irFunction2) + '(' + fileName + ':' + lineNum + ')');
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getStackTrace() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.frameList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FrameContainer it = (FrameContainer)element$iv$iv;
            boolean bl2 = false;
            if (it.getFrameEntryPoint() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void clean() {
        this.frameList.clear();
        this.frameList.add(new FrameContainer(null, 1, null));
    }

    @Override
    public void addVar(@NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        this.getCurrentFrame().addVar(variable2);
    }

    @Override
    public void addAll(@NotNull List<Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.getCurrentFrame().addAll(variables);
    }

    @Override
    @NotNull
    public Variable getVariable(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.getCurrentFrame().getVariable(symbol2);
    }

    @Override
    @NotNull
    public List<Variable> getAll() {
        return this.getCurrentFrame().getAll();
    }

    @Override
    public boolean contains(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.getCurrentFrame().contains(symbol2);
    }

    @Override
    public boolean hasReturnValue() {
        return this.getCurrentFrame().hasReturnValue();
    }

    @Override
    public void pushReturnValue(@NotNull State state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.getCurrentFrame().pushReturnValue(state2);
    }

    @Override
    @NotNull
    public State popReturnValue() {
        return this.getCurrentFrame().popReturnValue();
    }

    @Override
    @NotNull
    public State peekReturnValue() {
        return this.getCurrentFrame().peekReturnValue();
    }
}

