/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.extensions;

import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.openapi.Disposable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.extensions.ReplFactoryExtension;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.ReplCompiler;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.GenericReplCompiler;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KotlinScriptDefinitionFromAnnotatedTemplate;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/extensions/JvmStandardReplFactoryExtension;", "Lorg/jetbrains/kotlin/cli/common/extensions/ReplFactoryExtension;", "()V", "makeReplCompiler", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompiler;", "templateClassName", "", "templateClasspath", "", "Ljava/io/File;", "baseClassLoader", "Ljava/lang/ClassLoader;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "projectEnvironment", "Lcom/intellij/core/JavaCoreProjectEnvironment;", "makeScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/KotlinScriptDefinition;", "kotlin-scripting-compiler"})
public final class JvmStandardReplFactoryExtension
implements ReplFactoryExtension {
    @Override
    @NotNull
    public ReplCompiler makeReplCompiler(@NotNull String templateClassName, @NotNull List<? extends File> templateClasspath, @Nullable ClassLoader baseClassLoader2, @NotNull CompilerConfiguration configuration2, @NotNull JavaCoreProjectEnvironment projectEnvironment) {
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)projectEnvironment, (String)"projectEnvironment");
        Object object = projectEnvironment.getParentDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectEnvironment.parentDisposable");
        Disposable disposable = object;
        KotlinScriptDefinition kotlinScriptDefinition = this.makeScriptDefinition(templateClasspath, templateClassName, baseClassLoader2);
        object = configuration2.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configuration.getNotNull\u2026ys.MESSAGE_COLLECTOR_KEY)");
        return new GenericReplCompiler(disposable, kotlinScriptDefinition, configuration2, (MessageCollector)object);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinScriptDefinition makeScriptDefinition(List<? extends File> templateClasspath, String templateClassName, ClassLoader baseClassLoader2) {
        KotlinScriptDefinition kotlinScriptDefinition;
        try {
            void $this$toTypedArray$iv;
            Collection<URL> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = templateClasspath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                URL uRL = it.toURI().toURL();
                collection.add(uRL);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ClassLoader classLoader2 = baseClassLoader2;
            URL[] uRLArray2 = uRLArray;
            URLClassLoader classloader = new URLClassLoader(uRLArray2, classLoader2);
            Class<?> cls = classloader.loadClass(templateClassName);
            Intrinsics.checkNotNullExpressionValue(cls, (String)"cls");
            kotlinScriptDefinition = new KotlinScriptDefinitionFromAnnotatedTemplate(JvmClassMappingKt.getKotlinClass(cls), MapsKt.emptyMap(), null, 4, null);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot find script definition template class ", (Object)templateClassName), ex);
        }
        catch (Exception ex) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Error loading script definition template ", (Object)templateClassName), ex);
        }
        return kotlinScriptDefinition;
    }
}

