/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyGetter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertySetter;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u0002H\u0002J\f\u0010\u000e\u001a\u00020\r*\u00020\u0002H\u0002J\f\u0010\u000f\u001a\u00020\r*\u00020\u0002H\u0002J&\u0010\u0010\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInapplicableLateinitChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "hasGetter", "", "hasSetter", "isNullable", "reportError", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "target", "", "checkers"})
public final class FirInapplicableLateinitChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirInapplicableLateinitChecker INSTANCE = new FirInapplicableLateinitChecker();

    private FirInapplicableLateinitChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirMemberDeclaration $this$isLateInit$iv = declaration2;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getStatus().isLateInit()) {
            return;
        }
        if (declaration2.isVal()) {
            this.reportError(reporter2, declaration2.getSource(), "is allowed only on mutable properties", context2);
        } else if (declaration2.getInitializer() != null) {
            if (declaration2.isLocal()) {
                this.reportError(reporter2, declaration2.getSource(), "is not allowed on local variables with initializer", context2);
            } else {
                this.reportError(reporter2, declaration2.getSource(), "is not allowed on properties with initializer", context2);
            }
        } else if (declaration2.getDelegate() != null) {
            this.reportError(reporter2, declaration2.getSource(), "is not allowed on delegated properties", context2);
        } else if (this.isNullable(declaration2)) {
            this.reportError(reporter2, declaration2.getSource(), "is not allowed on properties of a type with nullable upper bound", context2);
        } else if (ConeTypeUtilsKt.isPrimitiveOrNullablePrimitive(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()))) {
            if (declaration2.isLocal()) {
                this.reportError(reporter2, declaration2.getSource(), "is not allowed on local variables of primitive types", context2);
            } else {
                this.reportError(reporter2, declaration2.getSource(), "is not allowed on properties of primitive types", context2);
            }
        } else if (this.hasGetter(declaration2) || this.hasSetter(declaration2)) {
            this.reportError(reporter2, declaration2.getSource(), "is not allowed on properties with a custom getter or setter", context2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNullable(FirProperty $this$isNullable) {
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType($this$isNullable.getReturnTypeRef());
        if (type2 instanceof ConeTypeParameterType) {
            FirTypeRef it;
            if (ConeTypeUtilsKt.isNullable(type2)) return true;
            Iterable $this$any$iv = ((FirTypeParameter)((ConeTypeParameterType)type2).getLookupTag().getTypeParameterSymbol().getFir()).getBounds();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (FirTypeRef)element$iv;
                boolean bl = false;
            } while (!ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType(it)));
            return true;
        }
        boolean bl = ConeTypeUtilsKt.isNullable(type2);
        return bl;
    }

    private final boolean hasGetter(FirProperty $this$hasGetter) {
        return $this$hasGetter.getGetter() != null && !($this$hasGetter.getGetter() instanceof FirDefaultPropertyGetter);
    }

    private final boolean hasSetter(FirProperty $this$hasSetter) {
        return $this$hasSetter.getSetter() != null && !($this$hasSetter.getSetter() instanceof FirDefaultPropertySetter);
    }

    private final void reportError(DiagnosticReporter $this$reportError, FirSourceElement source, String target, CheckerContext context2) {
        DiagnosticReporterKt.reportOn$default($this$reportError, source, FirErrors.INSTANCE.getINAPPLICABLE_LATEINIT_MODIFIER(), target, context2, null, 16, null);
    }
}

