/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTopLevelFunctionsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "checkers"})
public final class FirTopLevelFunctionsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirTopLevelFunctionsChecker INSTANCE = new FirTopLevelFunctionsChecker();

    private FirTopLevelFunctionsChecker() {
    }

    @Override
    public void check(@NotNull FirFile declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        for (FirDeclaration topLevelDeclaration : declaration2.getDeclarations()) {
            if (!(topLevelDeclaration instanceof FirSimpleFunction)) continue;
            this.checkFunction((FirSimpleFunction)topLevelDeclaration, reporter2, context2);
        }
    }

    private final void checkFunction(FirSimpleFunction function2, DiagnosticReporter reporter2, CheckerContext context2) {
        Object object = function2.getSource();
        if (object == null) {
            return;
        }
        FirSourceElement source = object;
        if (source.getKind() instanceof FirFakeSourceElementKind) {
            return;
        }
        FirElement firElement = function2;
        object = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ABSTRACT_KEYWORD");
        if (FirKeywordUtilsKt.hasModifier(firElement, (KtModifierKeywordToken)((Object)object))) {
            return;
        }
        FirMemberDeclaration $this$isExternal$iv = function2;
        boolean $i$f$isExternal = false;
        if ($this$isExternal$iv.getStatus().isExternal()) {
            return;
        }
        FirFunction $this$hasBody$iv = function2;
        boolean $i$f$getHasBody = false;
        if (!($this$hasBody$iv.getBody() != null)) {
            FirMemberDeclaration $this$isExpect$iv = function2;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                DiagnosticReporterKt.reportOn$default(reporter2, source, FirErrors.INSTANCE.getNON_MEMBER_FUNCTION_NO_BODY(), function2, context2, null, 16, null);
            }
        }
        FirDeclarationCheckerUtilsKt.checkExpectDeclarationVisibilityAndBody(function2, source, reporter2, context2);
    }
}

