/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.SamType;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DescriptorAsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FakeDescriptorsForReferencesKt;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.InlineClassesCodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.SamWrapperCodegen;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.WriteAnnotationUtilKt;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializerExtension;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class ClosureCodegen
extends MemberCodegen<KtElement> {
    protected final FunctionDescriptor funDescriptor;
    private final ClassDescriptor classDescriptor;
    private final SamType samType;
    private final KotlinType superClassType;
    private final List<KotlinType> superInterfaceTypes;
    private final ResolvedCall<FunctionDescriptor> functionReferenceCall;
    private final FunctionDescriptor functionReferenceTarget;
    private final FunctionGenerationStrategy strategy;
    protected final CalculatedClosure closure;
    protected final Type asmType;
    protected final int visibilityFlag;
    private final boolean shouldHaveBoundReferenceReceiver;
    private final boolean isLegacyFunctionReference;
    private final boolean isOptimizedFunctionReference;
    private final boolean isAdaptedFunctionReference;
    private Method constructor;
    protected Type superClassAsmType;

    public ClosureCodegen(@NotNull GenerationState state2, @NotNull KtElement element, @Nullable SamType samType, @NotNull ClosureContext context2, @Nullable ResolvedCall<FunctionDescriptor> functionReferenceCall, @NotNull FunctionGenerationStrategy strategy, @NotNull MemberCodegen<?> parentCodegen, @NotNull ClassBuilder classBuilder2) {
        if (state2 == null) {
            ClosureCodegen.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ClosureCodegen.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            ClosureCodegen.$$$reportNull$$$0(2);
        }
        if (strategy == null) {
            ClosureCodegen.$$$reportNull$$$0(3);
        }
        if (parentCodegen == null) {
            ClosureCodegen.$$$reportNull$$$0(4);
        }
        if (classBuilder2 == null) {
            ClosureCodegen.$$$reportNull$$$0(5);
        }
        super(state2, parentCodegen, context2, element, classBuilder2);
        this.funDescriptor = context2.getFunctionDescriptor();
        this.classDescriptor = (ClassDescriptor)context2.getContextDescriptor();
        this.samType = samType;
        this.functionReferenceCall = functionReferenceCall;
        this.functionReferenceTarget = functionReferenceCall != null ? functionReferenceCall.getResultingDescriptor() : null;
        this.strategy = strategy;
        if (samType == null) {
            this.superInterfaceTypes = new ArrayList<KotlinType>();
            KotlinType superClassType = null;
            for (KotlinType supertype2 : this.classDescriptor.getTypeConstructor().getSupertypes()) {
                ClassifierDescriptor classifier2 = supertype2.getConstructor().getDeclarationDescriptor();
                if (DescriptorUtils.isInterface(classifier2)) {
                    this.superInterfaceTypes.add(supertype2);
                    continue;
                }
                assert (superClassType == null) : "Closure class can't have more than one superclass: " + this.funDescriptor;
                superClassType = supertype2;
            }
            assert (superClassType != null) : "Closure class should have a superclass: " + this.funDescriptor;
            this.superClassType = superClassType;
        } else {
            this.superInterfaceTypes = Collections.singletonList(samType.getType());
            this.superClassType = DescriptorUtilsKt.getBuiltIns(this.funDescriptor).getAnyType();
        }
        this.closure = this.bindingContext.get(CodegenBinding.CLOSURE, this.classDescriptor);
        assert (this.closure != null) : "Closure must be calculated for class: " + this.classDescriptor;
        this.shouldHaveBoundReferenceReceiver = CallableReferenceUtilKt.isForBoundCallableReference(this.closure);
        ClassifierDescriptor superClassDescriptor = this.superClassType.getConstructor().getDeclarationDescriptor();
        this.isLegacyFunctionReference = this.functionReferenceTarget != null && superClassDescriptor == state2.getJvmRuntimeTypes().getFunctionReference();
        this.isOptimizedFunctionReference = this.functionReferenceTarget != null && superClassDescriptor == state2.getJvmRuntimeTypes().getFunctionReferenceImpl();
        this.isAdaptedFunctionReference = this.functionReferenceTarget != null && superClassDescriptor == state2.getJvmRuntimeTypes().getAdaptedFunctionReference();
        this.asmType = this.typeMapper.mapClass(this.classDescriptor);
        this.visibilityFlag = DescriptorAsmUtil.getVisibilityAccessFlagForClass(this.classDescriptor);
    }

    @Override
    protected void generateDeclaration() {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.CLASS);
        if (this.samType != null) {
            this.typeMapper.writeFormalTypeParameters(this.samType.getType().getConstructor().getParameters(), sw);
        }
        ((JvmSignatureWriter)sw).writeSuperclass();
        this.superClassAsmType = this.typeMapper.mapSupertype(this.superClassType, sw);
        ((JvmSignatureWriter)sw).writeSuperclassEnd();
        String[] superInterfaceAsmTypes = new String[this.superInterfaceTypes.size()];
        for (int i = 0; i < this.superInterfaceTypes.size(); ++i) {
            Type superInterfaceAsmType;
            KotlinType superInterfaceType = this.superInterfaceTypes.get(i);
            ((JvmSignatureWriter)sw).writeInterface();
            if (this.samType != null && superInterfaceType.getConstructor() == this.samType.getType().getConstructor()) {
                superInterfaceAsmType = this.typeMapper.mapSupertype(superInterfaceType, null);
                ((JvmSignatureWriter)sw).writeAsmType(superInterfaceAsmType);
            } else {
                superInterfaceAsmType = this.typeMapper.mapSupertype(superInterfaceType, sw);
            }
            superInterfaceAsmTypes[i] = superInterfaceAsmType.getInternalName();
            ((JvmSignatureWriter)sw).writeInterfaceEnd();
        }
        this.v.defineClass((PsiElement)this.element, this.state.getClassFileVersion(), 0x30 | this.visibilityFlag | DescriptorAsmUtil.getSyntheticAccessFlagForLambdaClass(this.classDescriptor), this.asmType.getInternalName(), ((JvmSignatureWriter)sw).makeJavaGenericSignature(), this.superClassAsmType.getInternalName(), superInterfaceAsmTypes);
        this.initDefaultSourceMappingIfNeeded();
        this.v.visitSource(((KtElement)this.element).getContainingFile().getName(), null);
    }

    @Override
    @Nullable
    protected ClassDescriptor classForInnerClassRecord() {
        return JvmCodegenUtil.isArgumentWhichWillBeInlined(this.bindingContext, this.funDescriptor) ? null : this.classDescriptor;
    }

    @Override
    protected void generateBody() {
        this.generateBridges();
        this.generateClosureBody();
        if (this.samType != null) {
            SamWrapperCodegen.generateDelegatesToDefaultImpl(this.asmType, this.classDescriptor, this.samType.getClassDescriptor(), this.functionCodegen, this.state);
        }
        this.constructor = this.generateConstructor();
        if (JvmCodegenUtil.isConst(this.closure)) {
            this.generateConstInstance(this.asmType, this.asmType);
        }
        DescriptorAsmUtil.genClosureFields(this.closure, this.v, this.typeMapper, this.state.getLanguageVersionSettings());
    }

    protected void generateClosureBody() {
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), this.funDescriptor, this.strategy);
        if (this.isLegacyFunctionReference) {
            this.generateFunctionReferenceMethods(this.functionReferenceTarget);
        }
        this.functionCodegen.generateDefaultIfNeeded(this.context.intoFunction(this.funDescriptor), this.funDescriptor, this.context.getContextKind(), DefaultParameterValueLoader.DEFAULT, null);
    }

    protected void generateBridges() {
        FunctionDescriptor erasedInterfaceFunction = this.samType == null ? ClosureCodegen.getErasedInvokeFunction(this.funDescriptor) : this.samType.getOriginalAbstractMethod();
        List bridgeParameterKotlinTypes = CollectionsKt.map(erasedInterfaceFunction.getValueParameters(), ValueDescriptor::getType);
        this.generateBridge(this.typeMapper.mapAsmMethod(erasedInterfaceFunction), bridgeParameterKotlinTypes, erasedInterfaceFunction.getReturnType(), this.typeMapper.mapAsmMethod(this.funDescriptor), this.funDescriptor.getReturnType(), JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(erasedInterfaceFunction));
        if (this.samType != null) {
            ClosureCodegen.generateBridgesForSAM(erasedInterfaceFunction, this.funDescriptor, this.functionCodegen);
        }
    }

    static void generateBridgesForSAM(FunctionDescriptor erasedInterfaceFunction, FunctionDescriptor descriptor2, FunctionCodegen codegen2) {
        SimpleFunctionDescriptorImpl descriptorForBridges = SimpleFunctionDescriptorImpl.create(descriptor2.getContainingDeclaration(), descriptor2.getAnnotations(), erasedInterfaceFunction.getName(), CallableMemberDescriptor.Kind.DECLARATION, descriptor2.getSource());
        descriptorForBridges.initialize(erasedInterfaceFunction.getExtensionReceiverParameter(), erasedInterfaceFunction.getDispatchReceiverParameter(), erasedInterfaceFunction.getTypeParameters(), (List)erasedInterfaceFunction.getValueParameters(), erasedInterfaceFunction.getReturnType(), Modality.OPEN, erasedInterfaceFunction.getVisibility());
        descriptorForBridges.setSuspend(descriptor2.isSuspend());
        DescriptorUtilsKt.setSingleOverridden(descriptorForBridges, erasedInterfaceFunction);
        codegen2.generateBridges(descriptorForBridges);
    }

    @Override
    protected void generateKotlinMetadataAnnotation() {
        FunctionDescriptor frontendFunDescriptor = CodegenUtilKt.unwrapFrontendVersion(this.funDescriptor);
        Method method = this.v.getSerializationBindings().get(JvmSerializationBindings.METHOD_FOR_FUNCTION, frontendFunDescriptor);
        assert (method != null) : "No method for " + frontendFunDescriptor;
        FunctionDescriptor freeLambdaDescriptor = FakeDescriptorsForReferencesKt.createFreeFakeLambdaDescriptor(frontendFunDescriptor, this.state.getTypeApproximator());
        this.v.getSerializationBindings().put(JvmSerializationBindings.METHOD_FOR_FUNCTION, freeLambdaDescriptor, method);
        DescriptorSerializer serializer2 = DescriptorSerializer.createForLambda(new JvmSerializerExtension(this.v.getSerializationBindings(), this.state));
        ProtoBuf.Function.Builder builder2 = serializer2.functionProto(freeLambdaDescriptor);
        if (builder2 == null) {
            return;
        }
        ProtoBuf.Function functionProto = builder2.build();
        WriteAnnotationUtilKt.writeKotlinMetadata(this.v, this.state, KotlinClassHeader.Kind.SYNTHETIC_CLASS, 0, (Function1<? super AnnotationVisitor, Unit>)((Function1)av -> {
            DescriptorAsmUtil.writeAnnotationData(av, serializer2, functionProto);
            return Unit.INSTANCE;
        }));
    }

    @Override
    protected void done() {
        this.writeOuterClassAndEnclosingMethod();
        super.done();
    }

    @NotNull
    public StackValue putInstanceOnStack(@NotNull ExpressionCodegen codegen2, @Nullable StackValue functionReferenceReceiver) {
        if (codegen2 == null) {
            ClosureCodegen.$$$reportNull$$$0(6);
        }
        StackValue stackValue = StackValue.operation(this.functionReferenceTarget != null ? AsmTypes.K_FUNCTION : this.asmType, (Function1<InstructionAdapter, Unit>)((Function1)v -> {
            if (JvmCodegenUtil.isConst(this.closure)) {
                v.getstatic(this.asmType.getInternalName(), "INSTANCE", this.asmType.getDescriptor());
            } else {
                v.anew(this.asmType);
                v.dup();
                codegen2.pushClosureOnStack(this.classDescriptor, true, codegen2.defaultCallGenerator, functionReferenceReceiver);
                v.invokespecial(this.asmType.getInternalName(), "<init>", this.constructor.getDescriptor(), false);
            }
            return Unit.INSTANCE;
        }));
        if (stackValue == null) {
            ClosureCodegen.$$$reportNull$$$0(7);
        }
        return stackValue;
    }

    private void generateBridge(@NotNull Method bridge, @NotNull List<KotlinType> bridgeParameterKotlinTypes, @Nullable KotlinType bridgeReturnType, @NotNull Method delegate2, @Nullable KotlinType delegateReturnType, boolean isVarargInvoke) {
        if (bridge == null) {
            ClosureCodegen.$$$reportNull$$$0(8);
        }
        if (bridgeParameterKotlinTypes == null) {
            ClosureCodegen.$$$reportNull$$$0(9);
        }
        if (delegate2 == null) {
            ClosureCodegen.$$$reportNull$$$0(10);
        }
        if (bridge.equals((Object)delegate2)) {
            return;
        }
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), 4161, bridge.getName(), bridge.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (!this.state.getClassBuilderMode().generateBodies) {
            return;
        }
        mv.visitCode();
        InstructionAdapter iv = new InstructionAdapter(mv);
        MemberCodegen.markLineNumberForDescriptor(DescriptorUtils.getParentOfType(this.funDescriptor, ClassDescriptor.class), iv);
        Type[] bridgeParameterTypes = bridge.getArgumentTypes();
        if (isVarargInvoke) {
            assert (bridgeParameterTypes.length == 1 && bridgeParameterTypes[0].equals((Object)AsmUtil.getArrayType(AsmTypes.OBJECT_TYPE))) : "Vararg invoke must have one parameter of type [Ljava/lang/Object;: " + bridge;
            DescriptorAsmUtil.generateVarargInvokeArityAssert(iv, delegate2.getArgumentTypes().length);
        } else assert (bridgeParameterTypes.length == bridgeParameterKotlinTypes.size()) : "Asm parameter types should be the same length as Kotlin parameter types";
        iv.load(0, this.asmType);
        List calleeParameters = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)this.funDescriptor.getExtensionReceiverParameter()), this.funDescriptor.getValueParameters());
        int slot = 1;
        for (int i = 0; i < calleeParameters.size(); ++i) {
            StackValue value2;
            ParameterDescriptor calleeParameter = (ParameterDescriptor)calleeParameters.get(i);
            KotlinType parameterType = calleeParameter.getType();
            if (isVarargInvoke) {
                value2 = StackValue.arrayElement(AsmTypes.OBJECT_TYPE, null, StackValue.local(1, bridgeParameterTypes[0], bridgeParameterKotlinTypes.get(0)), StackValue.constant(i));
            } else {
                Type type2 = bridgeParameterTypes[i];
                value2 = StackValue.local(slot, type2, bridgeParameterKotlinTypes.get(i));
                slot += type2.getSize();
            }
            if (InlineClassesCodegenUtilKt.isInlineClassWithUnderlyingTypeAnyOrAnyN(parameterType) && this.functionReferenceCall == null) {
                InlineClassRepresentation<SimpleType> representation;
                ClassDescriptor descriptor2 = TypeUtils.getClassDescriptor(parameterType);
                InlineClassRepresentation<SimpleType> inlineClassRepresentation2 = representation = descriptor2 != null ? descriptor2.getInlineClassRepresentation() : null;
                assert (representation != null) : "Not an inline class type: " + parameterType;
                parameterType = representation.getUnderlyingType();
            }
            value2.put(this.typeMapper.mapType(calleeParameter), parameterType, iv);
        }
        iv.invokevirtual(this.asmType.getInternalName(), delegate2.getName(), delegate2.getDescriptor(), false);
        StackValue.onStack(delegate2.getReturnType(), delegateReturnType).put(bridge.getReturnType(), bridgeReturnType, iv);
        iv.areturn(bridge.getReturnType());
        FunctionCodegen.endVisit(mv, "bridge", (KtElement)this.element);
    }

    private void generateFunctionReferenceMethods(@NotNull FunctionDescriptor descriptor2) {
        InstructionAdapter iv;
        if (descriptor2 == null) {
            ClosureCodegen.$$$reportNull$$$0(11);
        }
        int flags = 17;
        boolean generateBody2 = this.state.getClassBuilderMode().generateBodies;
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getOwner", Type.getMethodDescriptor((Type)AsmTypes.K_DECLARATION_CONTAINER_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            CallableReferenceUtilKt.generateCallableReferenceDeclarationContainer(iv, descriptor2, this.state);
            iv.areturn(AsmTypes.K_DECLARATION_CONTAINER_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getOwner", (KtElement)this.element);
        }
        mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getName", Type.getMethodDescriptor((Type)AsmTypes.JAVA_STRING_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            iv.aconst((Object)descriptor2.getName().asString());
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getName", (KtElement)this.element);
        }
        mv = this.v.newMethod(JvmDeclarationOrigin.NO_ORIGIN, flags, "getSignature", Type.getMethodDescriptor((Type)AsmTypes.JAVA_STRING_TYPE, (Type[])new Type[0]), null, null);
        if (generateBody2) {
            mv.visitCode();
            iv = new InstructionAdapter(mv);
            CallableReferenceUtilKt.generateFunctionReferenceSignature(iv, descriptor2, this.state);
            iv.areturn(AsmTypes.JAVA_STRING_TYPE);
            FunctionCodegen.endVisit((MethodVisitor)iv, "function reference getSignature", (KtElement)this.element);
        }
    }

    @NotNull
    protected Method generateConstructor() {
        List<FieldInfo> args = ClosureCodegen.calculateConstructorParameters(this.typeMapper, this.state.getLanguageVersionSettings(), this.closure, this.asmType);
        Type[] argTypes = ClosureCodegen.fieldListToTypeArray(args);
        Method constructor2 = new Method("<init>", Type.VOID_TYPE, argTypes);
        MethodVisitor mv = this.v.newMethod(JvmDeclarationOriginKt.OtherOrigin((PsiElement)this.element, this.funDescriptor), this.visibilityFlag, "<init>", constructor2.getDescriptor(), null, ArrayUtil.EMPTY_STRING_ARRAY);
        if (this.state.getClassBuilderMode().generateBodies) {
            KotlinType boundReceiverKotlinType;
            Type boundReceiverType;
            int boundReceiverParameterIndex;
            mv.visitCode();
            InstructionAdapter iv = new InstructionAdapter(mv);
            Pair<Integer, FieldInfo> receiverIndexAndFieldInfo = CallableReferenceUtilKt.generateClosureFieldsInitializationFromParameters(iv, this.closure, args);
            if (this.shouldHaveBoundReferenceReceiver && receiverIndexAndFieldInfo == null) {
                throw new AssertionError((Object)("No bound reference receiver in constructor parameters: " + args));
            }
            if (this.shouldHaveBoundReferenceReceiver) {
                boundReceiverParameterIndex = (Integer)receiverIndexAndFieldInfo.getFirst();
                boundReceiverType = ((FieldInfo)receiverIndexAndFieldInfo.getSecond()).getFieldType();
                boundReceiverKotlinType = ((FieldInfo)receiverIndexAndFieldInfo.getSecond()).getFieldKotlinType();
            } else {
                boundReceiverParameterIndex = -1;
                boundReceiverType = null;
                boundReceiverKotlinType = null;
            }
            iv.load(0, this.superClassAsmType);
            ArrayList<Type> superCtorArgTypes = new ArrayList<Type>();
            if (this.superClassAsmType.equals((Object)AsmTypes.LAMBDA) || this.functionReferenceTarget != null || CoroutineCodegenUtilKt.isCoroutineSuperClass(this.state.getLanguageVersionSettings(), this.superClassAsmType.getInternalName())) {
                iv.iconst(CodegenUtilKt.getArity(this.funDescriptor));
                superCtorArgTypes.add(Type.INT_TYPE);
                if (this.shouldHaveBoundReferenceReceiver) {
                    CallableReferenceUtilKt.loadBoundReferenceReceiverParameter(iv, boundReceiverParameterIndex, boundReceiverType, boundReceiverKotlinType);
                    superCtorArgTypes.add(AsmTypes.OBJECT_TYPE);
                }
                if (this.isOptimizedFunctionReference || this.isAdaptedFunctionReference) {
                    assert (this.functionReferenceTarget != null) : "No function reference target: " + this.funDescriptor;
                    CallableReferenceUtilKt.generateCallableReferenceDeclarationContainerClass(iv, this.functionReferenceTarget, this.state);
                    iv.aconst((Object)this.functionReferenceTarget.getName().asString());
                    CallableReferenceUtilKt.generateFunctionReferenceSignature(iv, this.functionReferenceTarget, this.state);
                    int flags = CallableReferenceUtilKt.getCallableReferenceTopLevelFlag(this.functionReferenceTarget) + (ClosureCodegen.calculateFunctionReferenceFlags(this.functionReferenceCall, this.funDescriptor) << 1);
                    iv.aconst((Object)flags);
                    superCtorArgTypes.add(AsmTypes.JAVA_CLASS_TYPE);
                    superCtorArgTypes.add(AsmTypes.JAVA_STRING_TYPE);
                    superCtorArgTypes.add(AsmTypes.JAVA_STRING_TYPE);
                    superCtorArgTypes.add(Type.INT_TYPE);
                }
            } else assert (!this.shouldHaveBoundReferenceReceiver) : "Unexpected bound reference with supertype " + this.superClassAsmType;
            iv.invokespecial(this.superClassAsmType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])superCtorArgTypes.toArray(new Type[0])), false);
            iv.visitInsn(177);
            FunctionCodegen.endVisit((MethodVisitor)iv, "constructor", (KtElement)this.element);
        }
        Method method = constructor2;
        if (method == null) {
            ClosureCodegen.$$$reportNull$$$0(12);
        }
        return method;
    }

    private static int calculateFunctionReferenceFlags(@NotNull ResolvedCall<?> call2, @NotNull FunctionDescriptor anonymousAdapterFunction) {
        int shift;
        if (call2 == null) {
            ClosureCodegen.$$$reportNull$$$0(13);
        }
        if (anonymousAdapterFunction == null) {
            ClosureCodegen.$$$reportNull$$$0(14);
        }
        boolean hasVarargMappedToElement = false;
        FunctionDescriptor target = (FunctionDescriptor)call2.getResultingDescriptor();
        for (int i = shift = (call2.getDispatchReceiver() instanceof TransientReceiver ? 1 : 0) + (call2.getExtensionReceiver() instanceof TransientReceiver ? 1 : 0); i < anonymousAdapterFunction.getValueParameters().size() && i - shift < target.getValueParameters().size(); ++i) {
            ValueParameterDescriptor targetParameter = target.getValueParameters().get(i - shift);
            ValueParameterDescriptor adaptedParameter = anonymousAdapterFunction.getValueParameters().get(i);
            if (targetParameter.getVarargElementType() == null || targetParameter.getType().equals(adaptedParameter.getType())) continue;
            hasVarargMappedToElement = true;
            break;
        }
        boolean hasCoercionToUnit = KotlinBuiltIns.isUnit(anonymousAdapterFunction.getReturnType()) && !KotlinBuiltIns.isUnit(target.getReturnType());
        boolean hasSuspendConversion = !target.isSuspend() && anonymousAdapterFunction.isSuspend();
        return (hasVarargMappedToElement ? 1 : 0) + (hasSuspendConversion ? 2 : 0) + ((hasCoercionToUnit ? 1 : 0) << 2);
    }

    @NotNull
    public static List<FieldInfo> calculateConstructorParameters(@NotNull KotlinTypeMapper typeMapper2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull CalculatedClosure closure, @NotNull Type ownerType) {
        KotlinType captureReceiverType;
        if (typeMapper2 == null) {
            ClosureCodegen.$$$reportNull$$$0(15);
        }
        if (languageVersionSettings == null) {
            ClosureCodegen.$$$reportNull$$$0(16);
        }
        if (closure == null) {
            ClosureCodegen.$$$reportNull$$$0(17);
        }
        if (ownerType == null) {
            ClosureCodegen.$$$reportNull$$$0(18);
        }
        ArrayList args = Lists.newArrayList();
        ClassDescriptor captureThis = closure.getCapturedOuterClassDescriptor();
        if (captureThis != null) {
            SimpleType thisType = captureThis.getDefaultType();
            Type type2 = typeMapper2.mapType(thisType);
            args.add(FieldInfo.createForHiddenField(ownerType, type2, thisType, "this$0"));
        }
        if ((captureReceiverType = closure.getCapturedReceiverFromOuterContext()) != null) {
            String fieldName = closure.getCapturedReceiverFieldName(typeMapper2.getBindingContext(), languageVersionSettings);
            args.add(FieldInfo.createForHiddenField(ownerType, typeMapper2.mapType(captureReceiverType), captureReceiverType, fieldName));
        }
        for (EnclosedValueDescriptor enclosedValueDescriptor : closure.getCaptureVariables().values()) {
            DeclarationDescriptor descriptor2 = enclosedValueDescriptor.getDescriptor();
            if (descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof PropertyDescriptor) || ExpressionTypingUtils.isLocalFunction(descriptor2)) {
                args.add(FieldInfo.createForHiddenField(ownerType, enclosedValueDescriptor.getType(), enclosedValueDescriptor.getKotlinType(), enclosedValueDescriptor.getFieldName()));
                continue;
            }
            if (descriptor2 instanceof FunctionDescriptor) assert (captureReceiverType != null);
        }
        ArrayList arrayList = args;
        if (arrayList == null) {
            ClosureCodegen.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static Type[] fieldListToTypeArray(List<FieldInfo> args) {
        Type[] argTypes = new Type[args.size()];
        for (int i = 0; i != argTypes.length; ++i) {
            argTypes[i] = args.get(i).getFieldType();
        }
        return argTypes;
    }

    @NotNull
    public static FunctionDescriptor getErasedInvokeFunction(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            ClosureCodegen.$$$reportNull$$$0(20);
        }
        ClassDescriptor functionClass2 = DescriptorUtilsKt.getBuiltIns(function2).getFunction(function2.getValueParameters().size() + (function2.getExtensionReceiverParameter() != null ? 1 : 0));
        MemberScope scope2 = functionClass2.getDefaultType().getMemberScope();
        FunctionDescriptor functionDescriptor = scope2.getContributedFunctions(OperatorNameConventions.INVOKE, NoLookupLocation.FROM_BACKEND).iterator().next();
        if (functionDescriptor == null) {
            ClosureCodegen.$$$reportNull$$$0(21);
        }
        return functionDescriptor;
    }

    public boolean isCallableReference() {
        return this.functionReferenceTarget != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCodegen";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/ClosureCodegen";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridgeParameterKotlinTypes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousAdapterFunction";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/ClosureCodegen";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "putInstanceOnStack";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConstructor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateConstructorParameters";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getErasedInvokeFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putInstanceOnStack";
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 21: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateBridge";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateFunctionReferenceMethods";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateFunctionReferenceFlags";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calculateConstructorParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getErasedInvokeFunction";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

