/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.DeepCopyIrTreeWithDeclarationsKt;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.MethodsFromAnyGeneratorForLowerings;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J6\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001b2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 J2\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020(H\u0016J\u0010\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u000bJ\u0014\u0010-\u001a\u00020\u0013*\u00020.2\u0006\u0010/\u001a\u00020\u0013H\u0016J\f\u00100\u001a\u00020\u0017*\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "implementations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getImplementations$ir_backend_common", "()Ljava/util/Map;", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "createAnnotationImplementation", "annotationClass", "generatedEquals", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "arg1", "arg2", "implementAnnotationProperties", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "implClass", "generatedConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implementEqualsAndHashCode", "", "originalProps", "childProps", "implementPlatformSpecificParts", "moveValueArgumentsUsingNames", "source", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "destination", "visitConstructorCall", "expression", "getAnnotationProperties", "kClassExprToJClassIfNeeded", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "irExpression", "kClassToJClassIfNeeded", "ir.backend.common"})
public class AnnotationImplementationTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final BackendContext context;
    @Nullable
    private final IrFile irFile;
    @NotNull
    private final Map<IrClass, IrClass> implementations;

    public AnnotationImplementationTransformer(@NotNull BackendContext context2, @Nullable IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.irFile = irFile;
        this.implementations = new LinkedHashMap();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @Nullable
    public final IrFile getIrFile() {
        return this.irFile;
    }

    @NotNull
    public final Map<IrClass, IrClass> getImplementations$ir_backend_common() {
        return this.implementations;
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        IrClass irClass2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        if (irClassSymbol == null) {
            return super.visitConstructorCall(expression2);
        }
        IrClass constructedClass = (IrClass)irClassSymbol.getOwner();
        if (!IrUtilsKt.isAnnotationClass(constructedClass)) {
            return super.visitConstructorCall(expression2);
        }
        if (!((Collection)constructedClass.getTypeParameters()).isEmpty()) {
            return super.visitConstructorCall(expression2);
        }
        Map<IrClass, IrClass> $this$getOrPut$iv = this.implementations;
        boolean $i$f$getOrPut = false;
        IrClass value$iv = $this$getOrPut$iv.get(constructedClass);
        if (value$iv == null) {
            boolean bl = false;
            IrClass answer$iv = this.createAnnotationImplementation(constructedClass);
            $this$getOrPut$iv.put(constructedClass, answer$iv);
            irClass2 = answer$iv;
        } else {
            irClass2 = value$iv;
        }
        IrClass implClass = irClass2;
        IrConstructor ctor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(implClass));
        IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), IrUtilsKt.getDefaultType(implClass), ctor.getSymbol(), null, 16, null);
        this.moveValueArgumentsUsingNames(expression2, newCall);
        this.transformChildrenVoid(newCall);
        return newCall;
    }

    /*
     * WARNING - void declaration
     */
    private final void moveValueArgumentsUsingNames(IrConstructorCall source, IrConstructorCall destination) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = IrUtilsKt.getArgumentsWithIr(source);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void $dstr$_u24__u24$value;
            IrExpression value2;
            Pair $dstr$param$_u24__u24;
            Pair pair = (Pair)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            IrValueParameter param = (IrValueParameter)$dstr$param$_u24__u24.component1();
            Name name2 = param.getName();
            $dstr$param$_u24__u24 = (Pair)element$iv$iv;
            boolean bl2 = false;
            IrExpression irExpression = value2 = (IrExpression)$dstr$_u24__u24$value.component2();
            map.put(name2, irExpression);
        }
        Map argumentsByName = destination$iv$iv;
        Iterable $this$forEachIndexed$iv = ((IrConstructor)destination.getSymbol().getOwner()).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void parameter;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int index2 = n;
            boolean bl = false;
            IrExpression valueArg = (IrExpression)argumentsByName.get(parameter.getName());
            if (parameter.getDefaultValue() == null && valueArg == null) {
                Name name3;
                StringBuilder stringBuilder2 = new StringBuilder().append("Usage of default value argument for this annotation is not yet possible.\nPlease specify value for '");
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(source.getType());
                if (irClassSymbol == null) {
                    name3 = null;
                } else {
                    IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
                    name3 = irClass2.getName();
                }
                throw new IllegalStateException(stringBuilder2.append(name3).append('.').append(parameter.getName()).append("' explicitly").toString().toString());
            }
            destination.putValueArgument(index2, valueArg);
        }
    }

    private final IrClass createAnnotationImplementation(IrClass annotationClass) {
        Object subclass;
        Object object;
        IrDeclarationParent irDeclarationParent;
        Object object2 = this.getCurrentClass();
        if (object2 == null) {
            irDeclarationParent = null;
        } else {
            object = ((ScopeWithIr)object2).getScope();
            irDeclarationParent = ((Scope)object).getLocalDeclarationParent();
        }
        IrDeclarationParent irDeclarationParent2 = irDeclarationParent;
        IrClass localDeclarationParent = irDeclarationParent2 instanceof IrClass ? (IrClass)irDeclarationParent2 : null;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName2);
        object2 = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"annotationClass.fqNameWhenAvailable!!.asString()");
        String parentFqName = StringsKt.replace$default((String)object2, (char)'.', (char)'_', (boolean)false, (int)4, null);
        object = Name.identifier("annotationImpl$" + parentFqName + "$0");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"identifier(\"annotationImpl\\$$parentFqName$0\")");
        Object wrapperName = object;
        Object $this$buildClass$iv = this.context.getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder irClassBuilder = new IrClassBuilder();
        Object $this$buildClass_u24lambda_u2d1$iv = irClassBuilder;
        boolean bl = false;
        IrDeclarationBuilder $this$createAnnotationImplementation_u24lambda_u2d4 = $this$buildClass_u24lambda_u2d1$iv;
        boolean bl2 = false;
        $this$createAnnotationImplementation_u24lambda_u2d4.setName((Name)wrapperName);
        $this$createAnnotationImplementation_u24lambda_u2d4.setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"INTERNAL");
        $this$createAnnotationImplementation_u24lambda_u2d4.setVisibility(descriptorVisibility);
        Object $this$createAnnotationImplementation_u24lambda_u2d5 = $this$buildClass$iv = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u2d1$iv);
        boolean bl3 = false;
        $this$buildClass_u24lambda_u2d1$iv = localDeclarationParent;
        Object object3 = bl = $this$buildClass_u24lambda_u2d1$iv == null ? this.getIrFile() : $this$buildClass_u24lambda_u2d1$iv;
        if (bl == null) {
            throw new IllegalStateException("irFile in transformer should be specified when creating synthetic implementation".toString());
        }
        $this$createAnnotationImplementation_u24lambda_u2d5.setParent((IrDeclarationParent)bl);
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$createAnnotationImplementation_u24lambda_u2d5);
        ((IrClass)$this$createAnnotationImplementation_u24lambda_u2d5).setSuperTypes(CollectionsKt.listOf((Object)IrUtilsKt.getDefaultType(annotationClass)));
        Object $this$addConstructor$iv = subclass = $this$buildClass$iv;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrDeclarationBuilder $this$buildConstructor_u24lambda_u2d20$iv$iv = $this$createAnnotationImplementation_u24lambda_u2d4 = new IrFunctionBuilder();
        boolean bl4 = false;
        IrDeclarationBuilder $this$addConstructor_u24lambda_u2d21$iv = $this$buildConstructor_u24lambda_u2d20$iv$iv;
        boolean bl5 = false;
        IrDeclarationBuilder $this$createAnnotationImplementation_u24lambda_u2d6 = $this$addConstructor_u24lambda_u2d21$iv;
        boolean bl6 = false;
        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        $this$createAnnotationImplementation_u24lambda_u2d6.setVisibility(descriptorVisibility2);
        ((IrFunctionBuilder)$this$addConstructor_u24lambda_u2d21$iv).setReturnType(IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2d20$iv$iv);
        boolean bl7 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        Object ctor = $this$buildConstructor$iv$iv;
        Pair<List<IrProperty>, List<IrProperty>> pair = this.implementAnnotationProperties((IrClass)subclass, annotationClass, (IrConstructor)ctor);
        List originalProps = (List)pair.component1();
        List implementationProps = (List)pair.component2();
        this.implementEqualsAndHashCode(annotationClass, (IrClass)subclass, originalProps, implementationProps);
        this.implementPlatformSpecificParts(annotationClass, (IrClass)subclass);
        return subclass;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<List<IrProperty>, List<IrProperty>> implementAnnotationProperties(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Collection<Object> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)generatedConstructor, (String)"generatedConstructor");
        IrBlockBody ctorBody = this.context.getIrFactory().createBlockBody(-1, -1, CollectionsKt.listOf((Object)new IrDelegatingConstructorCallImpl(-1, -1, this.context.getIrBuiltIns().getUnitType(), (IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(this.context.getIrBuiltIns().getAnyClass())), 0, 0)));
        generatedConstructor.setBody(ctorBody);
        List<IrProperty> properties2 = this.getAnnotationProperties(annotationClass);
        Iterable iterable = properties2;
        List<IrProperty> list2 = properties2;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13;
            void this_$iv$iv;
            Object object;
            Object prop2;
            IrValueDeclaration irValueDeclaration;
            void property2;
            IrProperty irProperty2 = (IrProperty)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = property2.getGetter();
            Intrinsics.checkNotNull((Object)irSimpleFunction);
            IrType propType = irSimpleFunction.getReturnType();
            Name propName = property2.getName();
            Object $this$buildField$iv = this.getContext().getIrFactory();
            boolean $i$f$buildField = false;
            IrFieldBuilder irFieldBuilder = new IrFieldBuilder();
            Object $this$buildField_u24lambda_u2d4$iv = irFieldBuilder;
            boolean $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 = false;
            Object $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7 = $this$buildField_u24lambda_u2d4$iv;
            boolean bl2 = false;
            ((IrDeclarationBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7).setName(propName);
            ((IrFieldBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7).setType(propType);
            ((IrDeclarationBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7).setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            ((IrFieldBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7).setFinal(true);
            Object object2 = DescriptorVisibilities.PRIVATE;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"PRIVATE");
            ((IrDeclarationBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7).setVisibility((DescriptorVisibility)object2);
            Object it = $this$buildField$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u2d4$iv);
            boolean $i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 = false;
            it.setParent(implClass);
            Object field2 = $this$buildField$iv;
            IrFunction irFunction2 = generatedConstructor;
            it = propName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"propName.asString()");
            IrValueParameter parameter = DeclarationBuildersKt.addValueParameter$default(irFunction2, (String)it, propType, null, 4, null);
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7 = property2.getBackingField();
            Object $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 = $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7 == null ? null : ((bl2 = ((IrField)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d7).getInitializer()) == null ? null : bl2.getExpression());
            Object object3 = $this$buildField_u24lambda_u2d4$iv = $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 instanceof IrGetValue ? (IrGetValue)$i$a$-run-DeclarationBuildersKt$buildField$2$iv22 : null;
            if ($this$buildField_u24lambda_u2d4$iv == null) {
                irValueDeclaration = null;
            } else {
                $i$a$-run-DeclarationBuildersKt$buildField$2$iv22 = ((IrValueAccessExpression)$this$buildField_u24lambda_u2d4$iv).getSymbol();
                irValueDeclaration = $i$a$-run-DeclarationBuildersKt$buildField$2$iv22.getOwner();
            }
            IrElement $i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 = irValueDeclaration;
            IrValueParameter originalParameter = $i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 instanceof IrValueParameter ? (IrValueParameter)$i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 : null;
            $i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 = originalParameter;
            if (($i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 == null ? null : ((IrValueParameter)$i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32).getDefaultValue()) != null) {
                void it2;
                IrExpressionBody irExpressionBody = originalParameter.getDefaultValue();
                Intrinsics.checkNotNull((Object)irExpressionBody);
                $i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 = DeepCopyIrTreeWithDeclarationsKt.deepCopyWithVariables((IrElement)irExpressionBody);
                $this$buildField_u24lambda_u2d4$iv = (IrExpressionBody)$i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32;
                IrValueParameter irValueParameter = parameter;
                boolean bl3 = false;
                this.transformChildrenVoid((IrElement)it2);
                Unit unit2 = Unit.INSTANCE;
                irValueParameter.setDefaultValue((IrExpressionBody)$i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32);
            }
            $i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32 = ctorBody;
            Collection collection2 = $i$a$-also-AnnotationImplementationTransformer$implementAnnotationProperties$1$field$32.getStatements();
            IrFieldSymbol irFieldSymbol = ((IrField)field2).getSymbol();
            IrValueParameter irValueParameter = implClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            collection2.add(new IrSetFieldImpl(-1, -1, irFieldSymbol, new IrGetValueImpl(-1, -1, irValueParameter.getSymbol(), null, 8, null), new IrGetValueImpl(-1, -1, parameter.getSymbol(), null, 8, null), this.getContext().getIrBuiltIns().getUnitType(), null, null, 192, null));
            Object $this$addProperty$iv = implClass;
            boolean $i$f$addProperty = false;
            Object $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            boolean $i$f$buildProperty = false;
            Object $this$buildProperty_u24lambda_u2d8$iv$iv = object2 = new IrPropertyBuilder();
            boolean bl4 = false;
            Object $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d10 = $this$buildProperty_u24lambda_u2d8$iv$iv;
            boolean $i$a$-addProperty-AnnotationImplementationTransformer$implementAnnotationProperties$1$prop$22 = false;
            ((IrDeclarationBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d10).setName(propName);
            ((IrPropertyBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d10).setVar(false);
            ((IrDeclarationBuilder)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d10).setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            Object property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, (IrPropertyBuilder)$this$buildProperty_u24lambda_u2d8$iv$iv);
            boolean bl5 = false;
            $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
            property$iv.setParent((IrDeclarationParent)$this$addProperty$iv);
            Object $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d11 = $this$addProperty$iv = $this$buildProperty$iv$iv;
            boolean bl6 = false;
            ((IrField)field2).setCorrespondingPropertySymbol(((IrProperty)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d11).getSymbol());
            ((IrProperty)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d11).setBackingField((IrField)field2);
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d11.setParent(implClass);
            Object $this$addGetter$iv = prop2 = $this$addProperty$iv;
            boolean $i$f$addGetter = false;
            IrFunctionBuilder $this$addGetter_u24lambda_u2d11$iv = bl6 = new IrFunctionBuilder();
            boolean bl7 = false;
            $this$buildProperty_u24lambda_u2d8$iv$iv = Name.special("<get-" + $this$addGetter$iv.getName() + '>');
            Intrinsics.checkNotNullExpressionValue((Object)$this$buildProperty_u24lambda_u2d8$iv$iv, (String)"special(\"<get-${this@addGetter.name}>\")");
            $this$addGetter_u24lambda_u2d11$iv.setName((Name)$this$buildProperty_u24lambda_u2d8$iv$iv);
            IrFunctionBuilder $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d12 = $this$addGetter_u24lambda_u2d11$iv;
            boolean $i$a$-addGetter-AnnotationImplementationTransformer$implementAnnotationProperties$1$32 = false;
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d12.setName(propName);
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d12.setReturnType(this.kClassToJClassIfNeeded(propType));
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d12.setOrigin(AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
            DescriptorVisibility $i$a$-addProperty-AnnotationImplementationTransformer$implementAnnotationProperties$1$prop$22 = DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)$i$a$-addProperty-AnnotationImplementationTransformer$implementAnnotationProperties$1$prop$22, (String)"PUBLIC");
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d12.setVisibility($i$a$-addProperty-AnnotationImplementationTransformer$implementAnnotationProperties$1$prop$22);
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d12.setModality(Modality.FINAL);
            Object getter$iv = $this$buildProperty_u24lambda_u2d8$iv$iv = DeclarationBuildersKt.buildFunction($this$addGetter$iv.getFactory(), $this$addGetter_u24lambda_u2d11$iv);
            boolean bl8 = false;
            ((IrProperty)$this$addGetter$iv).setGetter((IrSimpleFunction)getter$iv);
            ((IrSimpleFunction)getter$iv).setCorrespondingPropertySymbol(((IrProperty)$this$addGetter$iv).getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            Object $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14 = object = $this$buildProperty_u24lambda_u2d8$iv$iv;
            boolean bl9 = false;
            ((IrSimpleFunction)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14).setCorrespondingPropertySymbol(((IrProperty)prop2).getSymbol());
            IrValueParameter irValueParameter2 = implClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter2);
            ((IrFunction)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14).setDispatchReceiverParameter(org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(irValueParameter2, (IrFunction)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14, null, 0, 0, 0, null, null, null, null, null, false, false, false, 8190, null));
            IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrSimpleFunction)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14).getSymbol(), 0, 0, 6, null);
            int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder $i$a$-addGetter-AnnotationImplementationTransformer$implementAnnotationProperties$1$32 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            getter$iv = this_$iv$iv;
            Object object4 = $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14;
            boolean bl10 = false;
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13;
            IrValueParameter irValueParameter3 = ((IrFunction)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14).getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter3);
            IrExpression value2 = ExpressionHelpersKt.irGetField(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter3), (IrField)field2);
            if (IrTypePredicatesKt.isKClass(propType)) {
                value2 = this.kClassExprToJClassIfNeeded((IrBuilderWithScope)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13, value2);
            }
            $this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$implementAnnotationProperties_u24lambda_u2d15_u24lambda_u2d14_u24lambda_u2d13, value2));
            Unit unit3 = Unit.INSTANCE;
            ((IrFunction)object4).setBody(this_$iv$iv.doBuild());
            Object object5 = prop2;
            collection.add(object5);
        }
        collection = (List)destination$iv$iv;
        return TuplesKt.to(list2, (Object)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrProperty> getAnnotationProperties(@NotNull IrClass $this$getAnnotationProperties) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotationProperties, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$getAnnotationProperties.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List props = (List)destination$iv$iv;
        if (!((Collection)props).isEmpty()) {
            return props;
        }
        $this$filterIsInstance$iv = $this$getAnnotationProperties.getDeclarations();
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)IrDeclarationOrigin.DEFAULT_PROPERTY_ACCESSOR.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrProperty irProperty2;
            IrProperty irProperty3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl2 = false;
            IrPropertySymbol irPropertySymbol = it.getCorrespondingPropertySymbol();
            IrProperty irProperty4 = irProperty3 = irPropertySymbol == null ? null : (IrProperty)irPropertySymbol.getOwner();
            if (irProperty3 == null) continue;
            IrProperty it$iv$iv = irProperty2 = irProperty3;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public IrType kClassToJClassIfNeeded(@NotNull IrType $this$kClassToJClassIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$kClassToJClassIfNeeded, (String)"<this>");
        return $this$kClassToJClassIfNeeded;
    }

    @NotNull
    public IrExpression kClassExprToJClassIfNeeded(@NotNull IrBuilderWithScope $this$kClassExprToJClassIfNeeded, @NotNull IrExpression irExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$kClassExprToJClassIfNeeded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)irExpression, (String)"irExpression");
        return irExpression;
    }

    @NotNull
    public IrExpression generatedEquals(@NotNull IrBlockBodyBuilder irBuilder, @NotNull IrType type2, @NotNull IrExpression arg1, @NotNull IrExpression arg2) {
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
        Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
        return ExpressionHelpersKt.irEquals$default(irBuilder, arg1, arg2, null, 4, null);
    }

    public final void implementEqualsAndHashCode(@NotNull IrClass annotationClass, @NotNull IrClass implClass, @NotNull List<? extends IrProperty> originalProps, @NotNull List<? extends IrProperty> childProps) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter(originalProps, (String)"originalProps");
        Intrinsics.checkNotNullParameter(childProps, (String)"childProps");
        MethodsFromAnyGeneratorForLowerings creator = new MethodsFromAnyGeneratorForLowerings(this.context, implClass, AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(annotationClass);
        Intrinsics.checkNotNull((Object)fqName2);
        AnnotationImplementationMemberGenerator generator2 = new AnnotationImplementationMemberGenerator(this.context, implClass, Intrinsics.stringPlus((String)"@", (Object)fqName2.asString()), (Function4<? super IrBlockBodyBuilder, ? super IrType, ? super IrExpression, ? super IrExpression, ? extends IrExpression>)((Function4)new Function4<IrBlockBodyBuilder, IrType, IrExpression, IrExpression, IrExpression>(this){
            final /* synthetic */ AnnotationImplementationTransformer this$0;
            {
                this.this$0 = $receiver;
                super(4);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrBlockBodyBuilder $this$$receiver, @NotNull IrType type2, @NotNull IrExpression a, @NotNull IrExpression b) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                return this.this$0.generatedEquals($this$$receiver, type2, a, b);
            }
        }));
        IrSimpleFunction eqFun = creator.createEqualsMethodDeclaration();
        generator2.generateEqualsUsingGetters(eqFun, IrUtilsKt.getDefaultType(annotationClass), originalProps);
        IrSimpleFunction hcFun = creator.createHashCodeMethodDeclaration();
        generator2.generateHashCodeMethod(hcFun, childProps);
        IrSimpleFunction toStringFun = creator.createToStringMethodDeclaration();
        generator2.generateToStringMethod(toStringFun, childProps);
    }

    public void implementPlatformSpecificParts(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
    }
}

