/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/extensions/ProjectExtensionDescriptor;", "T", "", "name", "", "extensionClass", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)V", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstances", "", "project", "Lcom/intellij/openapi/project/Project;", "registerExtension", "", "extension", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "registerExtensionPoint", "util"})
public class ProjectExtensionDescriptor<T> {
    @NotNull
    private final Class<T> extensionClass;
    @NotNull
    private final ExtensionPointName<T> extensionPointName;

    public ProjectExtensionDescriptor(@NotNull String name2, @NotNull Class<T> extensionClass) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(extensionClass, (String)"extensionClass");
        this.extensionClass = extensionClass;
        ExtensionPointName extensionPointName = ExtensionPointName.create((String)name2);
        Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"create(name)");
        this.extensionPointName = extensionPointName;
    }

    @NotNull
    public final ExtensionPointName<T> getExtensionPointName() {
        return this.extensionPointName;
    }

    public final void registerExtensionPoint(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getExtensionArea().registerExtensionPoint(this.extensionPointName.getName(), this.extensionClass.getName(), ExtensionPoint.Kind.INTERFACE);
    }

    public final void registerExtension(@NotNull Project project, @NotNull T extension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(extension, (String)"extension");
        project.getExtensionArea().getExtensionPoint(this.extensionPointName).registerExtension(extension, (Disposable)project);
    }

    @NotNull
    public final List<T> getInstances(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = project.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.extensionArea");
        Object[] projectArea = objectArray;
        if (!projectArea.hasExtensionPoint(this.extensionPointName.getName())) {
            return CollectionsKt.emptyList();
        }
        objectArray = projectArea.getExtensionPoint(this.extensionPointName).getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"projectArea.getExtension\u2026sionPointName).extensions");
        return ArraysKt.toList((Object[])objectArray);
    }
}

