/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirCallableReferenceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkReferenceIsToAllowedMember", "callableReferenceAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirCallableReferenceAccess;", "checkers"})
public final class FirCallableReferenceChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirCallableReferenceChecker INSTANCE = new FirCallableReferenceChecker();

    private FirCallableReferenceChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (!(expression2 instanceof FirCallableReferenceAccess)) {
            return;
        }
        this.checkReferenceIsToAllowedMember((FirCallableReferenceAccess)expression2, context2, reporter2);
    }

    private final void checkReferenceIsToAllowedMember(FirCallableReferenceAccess callableReferenceAccess, CheckerContext context2, DiagnosticReporter reporter2) {
        FirBasedSymbol firBasedSymbol;
        FirResolvedNamedReference firResolvedNamedReference;
        Object object = callableReferenceAccess.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        object = reference.getSource();
        if (object == null) {
            return;
        }
        Object source = object;
        if (((FirSourceElement)source).getKind() instanceof FirFakeSourceElementKind) {
            return;
        }
        FirBasedSymbol<?> referredSymbol = reference.getResolvedSymbol();
        if (referredSymbol instanceof FirConstructorSymbol && ((firBasedSymbol = FirHelpersKt.getContainingClassSymbol(referredSymbol, context2.getSession())) == null ? null : FirHelpersKt.getClassKind(firBasedSymbol)) == ClassKind.ANNOTATION_CLASS) {
            DiagnosticReporterKt.reportOn$default(reporter2, (FirSourceElement)source, FirErrors.INSTANCE.getCALLABLE_REFERENCE_TO_ANNOTATION_CONSTRUCTOR(), context2, null, 8, null);
        }
        FirBasedSymbol firBasedSymbol2 = firBasedSymbol = referredSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)referredSymbol : null;
        if ((firBasedSymbol == null ? false : FirDeclarationCheckerUtilsKt.isExtensionMember(firBasedSymbol)) && !FirDeclarationCheckerUtilsKt.isLocalMember(referredSymbol)) {
            DiagnosticReporterKt.reportOn$default(reporter2, (FirSourceElement)source, FirErrors.INSTANCE.getEXTENSION_IN_CLASS_REFERENCE_NOT_ALLOWED(), referredSymbol, context2, null, 16, null);
        }
        if (referredSymbol instanceof FirValueParameterSymbol || referredSymbol instanceof FirPropertySymbol && ((FirPropertySymbol)referredSymbol).isLocal() || reference.getResolvedSymbol() instanceof FirBackingFieldSymbol) {
            DiagnosticReporterKt.reportOn$default(reporter2, (FirSourceElement)source, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"References to variables aren't supported yet", context2, null, 16, null);
        }
    }
}

