/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.context;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.diagnostics.AbstractFirDiagnosticFactory;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\rH&J\u0010\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\u0011H&J\u0010\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0014H&J\u001e\u00104\u001a\u00020\u00002\b\u00105\u001a\u0004\u0018\u0001062\n\u00107\u001a\u0006\u0012\u0002\b\u000308H&J\u0010\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\u001bH&J.\u0010;\u001a\u00020\u00002\f\u0010<\u001a\b\u0012\u0004\u0012\u00020+0=2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H&J\b\u0010>\u001a\u00020?H&J\b\u0010@\u001a\u00020?H&J\b\u0010A\u001a\u00020?H&J\b\u0010B\u001a\u00020?H&J\u000e\u0010C\u001a\u00020\u00042\u0006\u0010D\u001a\u00020EJ-\u0010F\u001a\u0002HG\"\u0004\b\u0000\u0010G2\u0006\u00101\u001a\u00020\u00112\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002HG0I\u00a2\u0006\u0002\u0010JR\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u0012\u0010\u001d\u001a\u00020\u001eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0012\u0010%\u001a\u00020&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "", "()V", "allErrorsSuppressed", "", "getAllErrorsSuppressed", "()Z", "allInfosSuppressed", "getAllInfosSuppressed", "allWarningsSuppressed", "getAllWarningsSuppressed", "annotationContainers", "", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "getAnnotationContainers", "()Ljava/util/List;", "containingDeclarations", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingDeclarations", "getClassCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "getGetClassCalls", "implicitReceiverStack", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "getImplicitReceiverStack", "()Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "qualifiedAccessOrAnnotationCalls", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getQualifiedAccessOrAnnotationCalls", "returnTypeCalculator", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "getReturnTypeCalculator", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "getSessionHolder", "()Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "suppressedDiagnostics", "", "", "getSuppressedDiagnostics", "()Ljava/util/Set;", "addAnnotationContainer", "annotationContainer", "addDeclaration", "declaration", "addGetClassCall", "getClassCall", "addImplicitReceiver", "name", "Lorg/jetbrains/kotlin/name/Name;", "value", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "addQualifiedAccessOrAnnotationCall", "qualifiedAccessOrAnnotationCall", "addSuppressedDiagnostics", "diagnosticNames", "", "dropAnnotationContainer", "", "dropDeclaration", "dropGetClassCall", "dropQualifiedAccessOrAnnotationCall", "isDiagnosticSuppressed", "diagnostic", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "withDeclaration", "T", "f", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkers"})
public abstract class CheckerContext {
    @NotNull
    public abstract SessionHolder getSessionHolder();

    @NotNull
    public abstract ReturnTypeCalculator getReturnTypeCalculator();

    @NotNull
    public abstract ImplicitReceiverStack getImplicitReceiverStack();

    @NotNull
    public abstract List<FirDeclaration> getContainingDeclarations();

    @NotNull
    public abstract List<FirStatement> getQualifiedAccessOrAnnotationCalls();

    @NotNull
    public abstract List<FirGetClassCall> getGetClassCalls();

    @NotNull
    public abstract List<FirAnnotationContainer> getAnnotationContainers();

    @NotNull
    public abstract Set<String> getSuppressedDiagnostics();

    public abstract boolean getAllInfosSuppressed();

    public abstract boolean getAllWarningsSuppressed();

    public abstract boolean getAllErrorsSuppressed();

    @NotNull
    public final FirSession getSession() {
        return this.getSessionHolder().getSession();
    }

    @NotNull
    public abstract CheckerContext addSuppressedDiagnostics(@NotNull Collection<String> var1, boolean var2, boolean var3, boolean var4);

    @NotNull
    public abstract CheckerContext addImplicitReceiver(@Nullable Name var1, @NotNull ImplicitReceiverValue<?> var2);

    @NotNull
    public abstract CheckerContext addDeclaration(@NotNull FirDeclaration var1);

    public abstract void dropDeclaration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withDeclaration(@NotNull FirDeclaration declaration, @NotNull Function1<? super CheckerContext, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        CheckerContext newContext = this.addDeclaration(declaration);
        try {
            Object object = f.invoke((Object)newContext);
            return (T)object;
        }
        finally {
            newContext.dropDeclaration();
        }
    }

    @NotNull
    public abstract CheckerContext addQualifiedAccessOrAnnotationCall(@NotNull FirStatement var1);

    public abstract void dropQualifiedAccessOrAnnotationCall();

    @NotNull
    public abstract CheckerContext addGetClassCall(@NotNull FirGetClassCall var1);

    public abstract void dropGetClassCall();

    @NotNull
    public abstract CheckerContext addAnnotationContainer(@NotNull FirAnnotationContainer var1);

    public abstract void dropAnnotationContainer();

    public final boolean isDiagnosticSuppressed(@NotNull FirDiagnostic diagnostic) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        AbstractFirDiagnosticFactory factory2 = diagnostic.getFactory();
        String name2 = factory2.getName();
        Severity severity = factory2.getSeverity();
        int n = WhenMappings.$EnumSwitchMapping$0[severity.ordinal()];
        switch (n) {
            case 1: {
                bl = this.getAllInfosSuppressed();
                break;
            }
            case 2: {
                bl = this.getAllWarningsSuppressed();
                break;
            }
            case 3: {
                bl = this.getAllErrorsSuppressed();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean suppressedByAll = bl;
        return suppressedByAll || this.getSuppressedDiagnostics().contains(name2);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Severity.values().length];
            nArray[Severity.INFO.ordinal()] = 1;
            nArray[Severity.WARNING.ordinal()] = 2;
            nArray[Severity.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

