/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOptInUsageAccessChecker
extends FirExpressionChecker<FirQualifiedAccess> {
    @NotNull
    public static final FirOptInUsageAccessChecker INSTANCE = new FirOptInUsageAccessChecker();

    private FirOptInUsageAccessChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccess expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        FirResolvedNamedReference firResolvedNamedReference;
        FirSourceElementKind sourceKind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirSourceElement firSourceElement = expression2.getSource();
        FirSourceElementKind firSourceElementKind = sourceKind = firSourceElement == null ? null : firSourceElement.getKind();
        if (sourceKind instanceof FirFakeSourceElementKind.DataClassGeneratedMembers || sourceKind instanceof FirFakeSourceElementKind.PropertyFromParameter) {
            return;
        }
        Object object = expression2.getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference = firResolvedNamedReference;
        FirBasedSymbol<?> resolvedSymbol = reference.getResolvedSymbol();
        Object $this$check_u24lambda_u2d0 = object = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (expression2 instanceof FirVariableAssignment && resolvedSymbol instanceof FirPropertySymbol) {
            Set experimentalities = SetsKt.plus(((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).loadExperimentalities(resolvedSymbol, context2, true), (Iterable)((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).loadExperimentalitiesFromTypeArguments(context2, expression2.getTypeArguments()));
            ((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).reportNotAcceptedExperimentalities(experimentalities, ((FirVariableAssignment)expression2).getLValue(), context2, reporter2);
            return;
        }
        Set experimentalities = SetsKt.plus(((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).loadExperimentalities(resolvedSymbol, context2, false), (Iterable)((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).loadExperimentalitiesFromTypeArguments(context2, expression2.getTypeArguments()));
        ((FirOptInUsageBaseChecker)$this$check_u24lambda_u2d0).reportNotAcceptedExperimentalities(experimentalities, expression2, context2, reporter2);
    }
}

