/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.output;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.output.NoPermissionException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001ag\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042S\u0010\u0005\u001aO\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0006\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0013"}, d2={"writeAll", "", "Lorg/jetbrains/kotlin/backend/common/output/OutputFileCollection;", "outputDir", "Ljava/io/File;", "report", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/backend/common/output/OutputFile;", "Lkotlin/ParameterName;", "name", "file", "", "sources", "output", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "reportOutputFiles", "", "writeAllTo", "cli"})
public final class OutputUtilsKt {
    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir2, @Nullable Function3<? super OutputFile, ? super List<? extends File>, ? super File, Unit> report2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"$this$writeAll");
        Intrinsics.checkNotNullParameter((Object)outputDir2, (String)"outputDir");
        for (OutputFile file2 : $this$writeAll.asList()) {
            List<File> sources = file2.getSourceFiles();
            File output = new File(outputDir2, file2.getRelativePath());
            Function3<? super OutputFile, ? super List<? extends File>, ? super File, Unit> function3 = report2;
            if (function3 != null) {
                Unit cfr_ignored_0 = (Unit)function3.invoke((Object)file2, sources, (Object)output);
            }
            try {
                FileUtil.writeToFile((File)output, (byte[])file2.asByteArray());
            }
            catch (FileNotFoundException e) {
                if (outputDir2.isDirectory()) {
                    throw (Throwable)new NoPermissionException("error while writing " + output + " (Permission denied)", e);
                }
                throw (Throwable)e;
            }
        }
    }

    public static final void writeAllTo(@NotNull OutputFileCollection $this$writeAllTo, @NotNull File outputDir2) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAllTo, (String)"$this$writeAllTo");
        Intrinsics.checkNotNullParameter((Object)outputDir2, (String)"outputDir");
        OutputUtilsKt.writeAll($this$writeAllTo, outputDir2, null);
    }

    public static final void writeAll(@NotNull OutputFileCollection $this$writeAll, @NotNull File outputDir2, @NotNull MessageCollector messageCollector2, boolean reportOutputFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAll, (String)"$this$writeAll");
        Intrinsics.checkNotNullParameter((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        try {
            if (!reportOutputFiles) {
                OutputUtilsKt.writeAllTo($this$writeAll, outputDir2);
            } else {
                OutputUtilsKt.writeAll($this$writeAll, outputDir2, (Function3<? super OutputFile, ? super List<? extends File>, ? super File, Unit>)((Function3)new Function3<OutputFile, List<? extends File>, File, Unit>(messageCollector2){
                    final /* synthetic */ MessageCollector $messageCollector;

                    public final void invoke(@NotNull OutputFile $noName_0, @NotNull List<? extends File> sources, @NotNull File output) {
                        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter(sources, (String)"sources");
                        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                        String string2 = OutputMessageUtil.formatOutputMessage((Collection<File>)sources, output);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"OutputMessageUtil.format\u2026tMessage(sources, output)");
                        MessageCollector.DefaultImpls.report$default(this.$messageCollector, CompilerMessageSeverity.OUTPUT, string2, null, 4, null);
                    }
                    {
                        this.$messageCollector = messageCollector2;
                        super(3);
                    }
                }));
            }
        }
        catch (NoPermissionException e) {
            String string2 = e.getMessage();
            Intrinsics.checkNotNull((Object)string2);
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, string2, null, 4, null);
        }
        catch (FileNotFoundException e) {
            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "directory not found: " + outputDir2, null, 4, null);
        }
    }
}

