/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirImportingScopeFilter;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u001c\u0010\u0016\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00140\u0017H\u0016J$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00140\u001bH\u0016J(\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0016\u0010\u0016\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0004\u0012\u00020\u00140\u001bH\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractStarImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "filter", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirImportingScopeFilter;", "lookupInFir", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/scopes/impl/FirImportingScopeFilter;Z)V", "absentClassifierNames", "", "Lorg/jetbrains/kotlin/name/Name;", "starImports", "", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "getStarImports", "()Ljava/util/List;", "processClassifiersByNameWithSubstitution", "", "name", "processor", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processFunctionsByName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processPropertiesByName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "providers"})
public abstract class FirAbstractStarImportingScope
extends FirAbstractImportingScope {
    @NotNull
    private final Set<Name> absentClassifierNames;

    public FirAbstractStarImportingScope(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull FirImportingScopeFilter filter2, boolean lookupInFir) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        Intrinsics.checkNotNullParameter((Object)((Object)filter2), (String)"filter");
        super(session2, scopeSession, filter2, lookupInFir);
        this.absentClassifierNames = new LinkedHashSet();
    }

    @NotNull
    public abstract List<FirResolvedImport> getStarImports();

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name2, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor2) {
        block7: {
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                    Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                    if (name2.isSpecial()) break block5;
                    String string2 = name2.getIdentifier();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.identifier");
                    if (((CharSequence)string2).length() == 0) break block6;
                }
                if (!this.getStarImports().isEmpty() && !this.absentClassifierNames.contains(name2)) break block7;
            }
            return;
        }
        FirClassLikeSymbol<?> symbol2 = this.findSingleClassifierSymbolByName(name2, this.getStarImports());
        if (symbol2 != null) {
            processor2.invoke(symbol2, (Object)ConeSubstitutor.Empty.INSTANCE);
        } else {
            ((Collection)this.absentClassifierNames).add(name2);
        }
    }

    @Override
    public void processFunctionsByName(@NotNull Name name2, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.processFunctionsByName(name2, this.getStarImports(), processor2);
    }

    @Override
    public void processPropertiesByName(@NotNull Name name2, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        this.processPropertiesByName(name2, this.getStarImports(), processor2);
    }
}

