/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirUnderscoreHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReservedUnderscoreDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportIfUnderscore", "isSingleUnderscoreAllowed", "", "checkers"})
public final class FirReservedUnderscoreDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirReservedUnderscoreDeclarationChecker INSTANCE = new FirReservedUnderscoreDeclarationChecker();

    private FirReservedUnderscoreDeclarationChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        block4: {
            block5: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
                    if (!(declaration instanceof FirRegularClass) && !(declaration instanceof FirTypeParameter) && !(declaration instanceof FirProperty) && !(declaration instanceof FirTypeAlias)) break block3;
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration, context, reporter2, false, 8, null);
                    break block4;
                }
                if (!(declaration instanceof FirFunction)) break block5;
                if (declaration instanceof FirSimpleFunction) {
                    FirReservedUnderscoreDeclarationChecker.reportIfUnderscore$default(this, declaration, context, reporter2, false, 8, null);
                }
                boolean isSingleUnderscoreAllowed = declaration instanceof FirAnonymousFunction || declaration instanceof FirPropertyAccessor;
                for (FirValueParameter parameter2 : ((FirFunction)declaration).getValueParameters()) {
                    this.reportIfUnderscore(parameter2, context, reporter2, isSingleUnderscoreAllowed);
                }
                break block4;
            }
            if (!(declaration instanceof FirFile)) break block4;
            for (FirImport firImport : ((FirFile)declaration).getImports()) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(firImport.getAliasSource(), context, reporter2, false);
            }
        }
    }

    private final void reportIfUnderscore(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter2, boolean isSingleUnderscoreAllowed) {
        FirTypeRef delegatedTypeRef;
        FirTypeRef returnOrReceiverTypeRef;
        Object $this$reportIfUnderscore_u24lambda_u2d0;
        KtSourceElement declarationSource = declaration.getSource();
        if (declarationSource != null && !(declarationSource.getKind() instanceof KtFakeSourceElementKind)) {
            String rawName;
            $this$reportIfUnderscore_u24lambda_u2d0 = SourceNavigator.Companion.forElement(declaration);
            boolean bl = false;
            String string2 = rawName = $this$reportIfUnderscore_u24lambda_u2d0.getRawName(declaration);
            boolean bl2 = string2 != null ? FirUnderscoreHelpersKt.isUnderscore(string2) : false;
            if (!(!bl2 || isSingleUnderscoreAllowed && Intrinsics.areEqual((Object)rawName, (Object)"_"))) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declarationSource, FirErrors.INSTANCE.getUNDERSCORE_IS_RESERVED(), (DiagnosticContext)context, null, 8, null);
            }
        }
        FirTypeRef firTypeRef = ($this$reportIfUnderscore_u24lambda_u2d0 = declaration) instanceof FirValueParameter ? ((FirValueParameter)declaration).getReturnTypeRef() : (returnOrReceiverTypeRef = $this$reportIfUnderscore_u24lambda_u2d0 instanceof FirFunction ? ((FirFunction)declaration).getReceiverTypeRef() : null);
        if (returnOrReceiverTypeRef instanceof FirResolvedTypeRef && (delegatedTypeRef = ((FirResolvedTypeRef)returnOrReceiverTypeRef).getDelegatedTypeRef()) instanceof FirUserTypeRef) {
            for (FirQualifierPart qualifierPart : ((FirUserTypeRef)delegatedTypeRef).getQualifier()) {
                FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(qualifierPart.getSource(), context, reporter2, true);
                for (FirTypeProjection typeArgument : qualifierPart.getTypeArgumentList().getTypeArguments()) {
                    FirUnderscoreHelpersKt.checkUnderscoreDiagnostics(typeArgument.getSource(), context, reporter2, true);
                }
            }
        }
    }

    static /* synthetic */ void reportIfUnderscore$default(FirReservedUnderscoreDeclarationChecker firReservedUnderscoreDeclarationChecker, FirDeclaration firDeclaration, CheckerContext checkerContext, DiagnosticReporter diagnosticReporter, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        firReservedUnderscoreDeclarationChecker.reportIfUnderscore(firDeclaration, checkerContext, diagnosticReporter, bl);
    }
}

