/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.SingleNonLocalDeclarationDiagnosticRetriever;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.LockProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactoryKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FirElementsRecorder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.KtToFirMapping;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.NonReanalyzableDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.NonLocalDeclarationUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableDeclarationStructureElement;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "fir", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "psi", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "lockProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/LockProvider;", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/LockProvider;)V", "diagnostics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics;", "getDiagnostics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics;", "getFir", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "mappings", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/KtToFirMapping;", "getMappings", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/KtToFirMapping;", "getPsi", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Companion", "low-level-api-fir"})
public final class NonReanalyzableDeclarationStructureElement
extends FileStructureElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirDeclaration fir;
    @NotNull
    private final KtDeclaration psi;
    @NotNull
    private final KtToFirMapping mappings;
    @NotNull
    private final FileStructureElementDiagnostics diagnostics;
    @NotNull
    private static final Companion.recorder.1 recorder = new FirElementsRecorder(){

        public void visitProperty(@NotNull FirProperty property2, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PsiElement psiElement = UtilsKt.getPsi(property2);
            KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
            if (ktProperty == null) {
                super.visitProperty(property2, data);
                return;
            }
            KtProperty psi2 = ktProperty;
            if (!FileElementFactoryKt.isReanalyzableContainer((KtDeclaration)psi2) || !NonLocalDeclarationUtilsKt.declarationCanBeLazilyResolved(psi2)) {
                super.visitProperty(property2, data);
            }
        }

        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull Map<KtElement, FirElement> data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            PsiElement psiElement = UtilsKt.getPsi(simpleFunction);
            KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            if (ktNamedFunction == null) {
                super.visitSimpleFunction(simpleFunction, data);
                return;
            }
            KtNamedFunction psi2 = ktNamedFunction;
            if (!FileElementFactoryKt.isReanalyzableContainer((KtDeclaration)psi2) || !NonLocalDeclarationUtilsKt.declarationCanBeLazilyResolved(psi2)) {
                super.visitSimpleFunction(simpleFunction, data);
            }
        }
    };

    public NonReanalyzableDeclarationStructureElement(@NotNull FirFile firFile, @NotNull FirDeclaration fir, @NotNull KtDeclaration psi2, @NotNull LockProvider<FirFile> lockProvider) {
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)psi2, (String)"psi");
        Intrinsics.checkNotNullParameter(lockProvider, (String)"lockProvider");
        super(firFile, lockProvider, null);
        this.fir = fir;
        this.psi = psi2;
        this.mappings = new KtToFirMapping(this.fir, recorder);
        this.diagnostics = new FileStructureElementDiagnostics(firFile, lockProvider, new SingleNonLocalDeclarationDiagnosticRetriever(this.fir));
    }

    @NotNull
    public final FirDeclaration getFir() {
        return this.fir;
    }

    @Override
    @NotNull
    public KtDeclaration getPsi() {
        return this.psi;
    }

    @Override
    @NotNull
    public KtToFirMapping getMappings() {
        return this.mappings;
    }

    @Override
    @NotNull
    public FileStructureElementDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableDeclarationStructureElement$Companion;", "", "()V", "recorder", "org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableDeclarationStructureElement$Companion$recorder$1", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/NonReanalyzableDeclarationStructureElement$Companion$recorder$1;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

