/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.components.KtDeclarationRendererOptions;
import org.jetbrains.kotlin.analysis.api.fir.renderer.FirIdeRendererBase;
import org.jetbrains.kotlin.analysis.api.fir.renderer.FirIdeRendererKt;
import org.jetbrains.kotlin.analysis.utils.printer.PrettyPrinter;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.PsiSourceNavigator;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 A2\u00020\u0001:\u0001AB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\f*\u00020\rH\u0002J\u0014\u0010\u0011\u001a\u00020\f*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\f*\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\f*\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\f*\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u00020\f*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\f*\u00020\r2\u0006\u0010!\u001a\u00020\"J\u0014\u0010#\u001a\u00020\f*\u00020\r2\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010&\u001a\u00020\f*\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010)\u001a\u00020\f*\u00020\r2\u0006\u0010*\u001a\u00020+H\u0002J\u0014\u0010,\u001a\u00020\f*\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010-\u001a\u00020\f*\u00020\r2\u0006\u0010.\u001a\u00020/H\u0002J\u0014\u00100\u001a\u00020\f*\u00020\r2\u0006\u00101\u001a\u000202H\u0002J\u0014\u00103\u001a\u00020\f*\u00020\r2\u0006\u00104\u001a\u000205H\u0002J\u0014\u00106\u001a\u00020\f*\u00020\r2\u0006\u0010!\u001a\u00020\tH\u0002J\u001e\u00107\u001a\u00020\f*\u00020\r2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u00108\u001a\u000209H\u0002J\u0014\u0010:\u001a\u00020\f*\u00020\r2\u0006\u0010;\u001a\u00020<H\u0002J\u0014\u0010=\u001a\u00020\f*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010>\u001a\u00020\f*\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u0014\u0010?\u001a\u00020\f*\u00020\r2\u0006\u0010!\u001a\u00020@H\u0002\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/renderer/FirIdeRenderer;", "Lorg/jetbrains/kotlin/analysis/api/fir/renderer/FirIdeRendererBase;", "options", "Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;Lorg/jetbrains/kotlin/fir/FirSession;)V", "sortDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "declarations", "renderAnonymousObject", "", "Lorg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinter;", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "renderBackingField", "renderClassBody", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "renderClassName", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "renderConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "renderEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "renderFunctionBody", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "renderMemberDeclaration", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "renderPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "renderPropertyOrField", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "renderReceiver", "firCallableDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "renderRegularClass", "renderSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "renderTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "renderTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "renderTypeParameters", "renderValVarPrefix", "isInPrimaryConstructor", "", "renderValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "renderValueParameters", "renderVariable", "renderWhereSuffix", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "Companion", "analysis-api-fir"})
public final class FirIdeRenderer
extends FirIdeRendererBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FirIdeRenderer(KtDeclarationRendererOptions options, FirSession session2) {
        super(options, session2);
    }

    public final void renderMemberDeclaration(@NotNull PrettyPrinter $this$renderMemberDeclaration, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)$this$renderMemberDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirAnonymousObject) {
            this.renderAnonymousObject($this$renderMemberDeclaration, (FirAnonymousObject)declaration);
        } else if (firDeclaration instanceof FirRegularClass) {
            this.renderRegularClass($this$renderMemberDeclaration, (FirRegularClass)declaration);
        } else if (firDeclaration instanceof FirTypeAlias) {
            this.renderTypeAlias($this$renderMemberDeclaration, (FirTypeAlias)declaration);
        } else if (firDeclaration instanceof FirConstructor) {
            this.renderConstructor($this$renderMemberDeclaration, (FirConstructor)declaration);
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            this.renderPropertyAccessor($this$renderMemberDeclaration, (FirPropertyAccessor)declaration);
        } else if (firDeclaration instanceof FirSimpleFunction) {
            this.renderSimpleFunction($this$renderMemberDeclaration, (FirSimpleFunction)declaration);
        } else if (firDeclaration instanceof FirBackingField) {
            this.renderBackingField($this$renderMemberDeclaration);
        } else if (firDeclaration instanceof FirEnumEntry) {
            this.renderEnumEntry($this$renderMemberDeclaration, (FirEnumEntry)declaration);
        } else if (firDeclaration instanceof FirProperty) {
            this.renderPropertyOrField($this$renderMemberDeclaration, (FirVariable)declaration);
        } else if (firDeclaration instanceof FirValueParameter) {
            this.renderValueParameter($this$renderMemberDeclaration, (FirValueParameter)declaration);
        } else if (firDeclaration instanceof FirField) {
            this.renderPropertyOrField($this$renderMemberDeclaration, (FirVariable)declaration);
        } else {
            if (firDeclaration instanceof FirErrorFunction) {
                throw new IllegalStateException("FirErrorFunction should not be rendered".toString());
            }
            if (firDeclaration instanceof FirErrorProperty) {
                throw new IllegalStateException("FirErrorProperty should not be rendered".toString());
            }
            if (firDeclaration instanceof FirAnonymousInitializer) {
                throw new IllegalStateException("FirAnonymousInitializer should not be rendered".toString());
            }
            if (firDeclaration instanceof FirFile) {
                throw new IllegalStateException("FirFile should not be rendered".toString());
            }
            if (firDeclaration instanceof FirTypeParameter) {
                this.renderTypeParameter($this$renderMemberDeclaration, (FirTypeParameter)declaration);
            } else if (firDeclaration instanceof FirAnonymousFunction) {
                throw new NotImplementedError(null, 1, null);
            }
        }
    }

    private final void renderBackingField(PrettyPrinter $this$renderBackingField) {
        $this$renderBackingField.append("field");
    }

    private final void renderPropertyOrField(PrettyPrinter $this$renderPropertyOrField, FirVariable variable2) {
        boolean needToRenderAccessors;
        if (!(variable2 instanceof FirProperty || variable2 instanceof FirField)) {
            boolean $i$a$-check-FirIdeRenderer$renderPropertyOrField$22 = false;
            String $i$a$-check-FirIdeRenderer$renderPropertyOrField$22 = "Required either FirProperty or FirField but was " + Reflection.getOrCreateKotlinClass(variable2.getClass()).getSimpleName();
            throw new IllegalStateException($i$a$-check-FirIdeRenderer$renderPropertyOrField$22.toString());
        }
        this.renderAnnotationsAndModifiers($this$renderPropertyOrField, variable2);
        FirIdeRenderer.renderValVarPrefix$default(this, $this$renderPropertyOrField, variable2, false, 2, null);
        this.renderTypeParameters($this$renderPropertyOrField, variable2);
        this.renderReceiver($this$renderPropertyOrField, variable2);
        this.renderName($this$renderPropertyOrField, variable2);
        $this$renderPropertyOrField.append(": ");
        this.renderType($this$renderPropertyOrField, variable2.getReturnTypeRef(), this.getOptions().getApproximateTypes());
        this.renderWhereSuffix($this$renderPropertyOrField, variable2);
        boolean bl = needToRenderAccessors = this.getOptions().getRenderClassMembers() && (FirIdeRenderer.renderPropertyOrField$needToRender(variable2.getGetter(), variable2) || variable2.isVar() && FirIdeRenderer.renderPropertyOrField$needToRender(variable2.getSetter(), variable2));
        if (needToRenderAccessors) {
            PrettyPrinter this_$iv = $this$renderPropertyOrField;
            boolean $i$f$withIndent = false;
            this_$iv.setIndent(this_$iv.getIndent() + 1);
            PrettyPrinter $this$renderPropertyOrField_u24lambda_u243 = this_$iv;
            boolean bl2 = false;
            FirPropertyAccessor firPropertyAccessor = variable2.getGetter();
            if (firPropertyAccessor != null) {
                FirPropertyAccessor getter2 = firPropertyAccessor;
                boolean bl3 = false;
                if (FirIdeRenderer.renderPropertyOrField$needToRender(getter2, variable2)) {
                    Intrinsics.checkNotNullExpressionValue((Object)((Appendable)$this$renderPropertyOrField_u24lambda_u243).append('\n'), (String)"append('\\n')");
                    this.renderPropertyAccessor($this$renderPropertyOrField_u24lambda_u243, getter2);
                }
            }
            FirPropertyAccessor firPropertyAccessor2 = variable2.getSetter();
            if (firPropertyAccessor2 != null) {
                FirPropertyAccessor setter2 = firPropertyAccessor2;
                boolean bl4 = false;
                if (FirIdeRenderer.renderPropertyOrField$needToRender(setter2, variable2)) {
                    Intrinsics.checkNotNullExpressionValue((Object)((Appendable)$this$renderPropertyOrField_u24lambda_u243).append('\n'), (String)"append('\\n')");
                    this.renderPropertyAccessor($this$renderPropertyOrField_u24lambda_u243, setter2);
                }
            }
            this_$iv.setIndent(this_$iv.getIndent() - 1);
        }
    }

    private final void renderPropertyAccessor(PrettyPrinter $this$renderPropertyAccessor, FirPropertyAccessor propertyAccessor) {
        this.renderAnnotationsAndModifiers($this$renderPropertyAccessor, propertyAccessor);
        $this$renderPropertyAccessor.append(propertyAccessor.isGetter() ? "get" : "set");
        if (propertyAccessor.isSetter()) {
            $this$renderPropertyAccessor.append("(value: ");
            FirIdeRendererBase.renderType$default(this, $this$renderPropertyAccessor, ((FirValueParameter)CollectionsKt.first(propertyAccessor.getValueParameters())).getReturnTypeRef(), false, 2, null);
            $this$renderPropertyAccessor.append(")");
        } else {
            $this$renderPropertyAccessor.append("()");
        }
        this.renderFunctionBody($this$renderPropertyAccessor, propertyAccessor);
    }

    private final void renderFunctionBody(PrettyPrinter $this$renderFunctionBody, FirFunction function2) {
    }

    private final void renderSimpleFunction(PrettyPrinter $this$renderSimpleFunction, FirSimpleFunction simpleFunction) {
        this.renderAnnotationsAndModifiers($this$renderSimpleFunction, simpleFunction);
        $this$renderSimpleFunction.append("fun ");
        this.renderTypeParameters($this$renderSimpleFunction, simpleFunction);
        this.renderReceiver($this$renderSimpleFunction, simpleFunction);
        this.renderName($this$renderSimpleFunction, simpleFunction);
        this.renderValueParameters($this$renderSimpleFunction, simpleFunction);
        FirTypeRef returnType2 = simpleFunction.getReturnTypeRef();
        if (this.getOptions().getRenderUnitReturnType() || !FirTypeUtilsKt.isUnit(returnType2)) {
            $this$renderSimpleFunction.append(": ");
            this.renderType($this$renderSimpleFunction, returnType2, this.getOptions().getApproximateTypes());
            $this$renderSimpleFunction.append(' ');
        }
        this.renderWhereSuffix($this$renderSimpleFunction, simpleFunction);
        this.renderFunctionBody($this$renderSimpleFunction, simpleFunction);
    }

    private final void renderAnonymousObject(PrettyPrinter $this$renderAnonymousObject, FirAnonymousObject anonymousObject) {
        this.renderAnnotationsAndModifiers($this$renderAnonymousObject, anonymousObject);
        $this$renderAnonymousObject.append("object ");
        this.renderSuperTypes($this$renderAnonymousObject, anonymousObject);
        this.renderClassBody($this$renderAnonymousObject, anonymousObject);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderClassBody(PrettyPrinter $this$renderClassBody, FirClass firClass) {
        FirMemberDeclaration declaration;
        Iterable collection$iv;
        void before$iv$iv;
        void this_$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Object element$iv2;
        Iterable iterable;
        if (!this.getOptions().getRenderClassMembers()) {
            return;
        }
        if (firClass.getDeclarations().isEmpty()) {
            return;
        }
        List $this$renderClassBody_u24lambda_u245 = iterable = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-FirIdeRenderer$renderClassBody$allDeclarations$22 = false;
        Iterable $this$filterNotTo$iv = firClass.getDeclarations();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv2 : $this$filterNotTo$iv) {
            FirDeclaration member2 = (FirDeclaration)element$iv2;
            boolean bl = false;
            if (FirIdeRendererKt.access$isDefaultPrimaryConstructor(member2) || FirIdeRendererKt.access$isDefaultEnumEntryMember(member2, firClass) || member2 instanceof FirConstructor && firClass.getClassKind() == ClassKind.OBJECT) continue;
            ((Collection)$this$renderClassBody_u24lambda_u245).add(element$iv2);
        }
        $this$renderClassBody_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedNestedClassifiers(firClass, this.getUseSiteSession()));
        $this$renderClassBody_u24lambda_u245.addAll((Collection)GeneratedDeclarationsUtilsKt.generatedMembers(firClass, this.getUseSiteSession()));
        iterable = CollectionsKt.build((List)iterable);
        boolean $i$f$filterIsInstance = false;
        void $i$a$-buildList-FirIdeRenderer$renderClassBody$allDeclarations$22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirMemberDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allDeclarations2 = (List)destination$iv$iv;
        if (allDeclarations2.isEmpty()) {
            return;
        }
        Iterable $this$partition$iv = allDeclarations2;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            FirMemberDeclaration it = (FirMemberDeclaration)element$iv2;
            boolean bl = false;
            if (it instanceof FirEnumEntry) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        iterable = new Pair(first$iv, second$iv);
        List enumEntries = (List)iterable.component1();
        List nonEnumEntries = (List)iterable.component2();
        PrettyPrinter this_$iv = $this$renderClassBody;
        boolean $i$f$withIndentInBraces = false;
        PrettyPrinter prettyPrinter = this_$iv;
        element$iv2 = "{";
        String after$iv$iv = "}";
        boolean $i$f$withIndentWrapped = false;
        this_$iv$iv.append((CharSequence)before$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)this_$iv$iv).append('\n'), (String)"append('\\n')");
        void this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$withIndent = false;
        this_$iv$iv$iv.setIndent(this_$iv$iv$iv.getIndent() + 1);
        void $this$renderClassBody_u24lambda_u249 = this_$iv$iv$iv;
        boolean bl = false;
        Iterable iterable2 = this.sortDeclarations(enumEntries);
        String separator$iv = ",\n";
        String prefix$iv = "";
        String postfix$iv = "";
        boolean $i$f$printCollection = false;
        $this$renderClassBody_u24lambda_u249.append(prefix$iv);
        Iterator iterator$iv = collection$iv.iterator();
        while (iterator$iv.hasNext()) {
            FirMemberDeclaration firMemberDeclaration = (FirMemberDeclaration)iterator$iv.next();
            void $this$renderClassBody_u24lambda_u249_u24lambda_u247 = $this$renderClassBody_u24lambda_u249;
            boolean bl2 = false;
            this.renderMemberDeclaration((PrettyPrinter)$this$renderClassBody_u24lambda_u249_u24lambda_u247, declaration);
            if (!iterator$iv.hasNext()) continue;
            $this$renderClassBody_u24lambda_u249.append(separator$iv);
        }
        $this$renderClassBody_u24lambda_u249.append(postfix$iv);
        if (!((Collection)enumEntries).isEmpty() && !((Collection)nonEnumEntries).isEmpty()) {
            Appendable appendable = ((Appendable)$this$renderClassBody_u24lambda_u249).append(";\n");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
        }
        collection$iv = this.sortDeclarations(nonEnumEntries);
        separator$iv = "\n\n";
        prefix$iv = "";
        postfix$iv = "";
        $i$f$printCollection = false;
        $this$renderClassBody_u24lambda_u249.append(prefix$iv);
        iterator$iv = collection$iv.iterator();
        while (iterator$iv.hasNext()) {
            declaration = (FirMemberDeclaration)iterator$iv.next();
            void $this$renderClassBody_u24lambda_u249_u24lambda_u248 = $this$renderClassBody_u24lambda_u249;
            boolean bl3 = false;
            this.renderMemberDeclaration((PrettyPrinter)$this$renderClassBody_u24lambda_u249_u24lambda_u248, declaration);
            if (!iterator$iv.hasNext()) continue;
            $this$renderClassBody_u24lambda_u249.append(separator$iv);
        }
        $this$renderClassBody_u24lambda_u249.append(postfix$iv);
        this_$iv$iv$iv.setIndent(this_$iv$iv$iv.getIndent() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)this_$iv$iv).append('\n'), (String)"append('\\n')");
        this_$iv$iv.append(after$iv$iv);
    }

    private final void renderConstructor(PrettyPrinter $this$renderConstructor, FirConstructor constructor2) {
        this.renderAnnotationsAndModifiers($this$renderConstructor, constructor2);
        $this$renderConstructor.append("constructor");
        this.renderValueParameters($this$renderConstructor, constructor2);
        this.renderFunctionBody($this$renderConstructor, constructor2);
    }

    private final void renderRegularClass(PrettyPrinter $this$renderRegularClass, FirRegularClass regularClass) {
        this.renderAnnotationsAndModifiers($this$renderRegularClass, regularClass);
        this.renderClassifierKind($this$renderRegularClass, regularClass);
        this.renderClassName($this$renderRegularClass, regularClass);
        this.renderTypeParameters($this$renderRegularClass, regularClass);
        $this$renderRegularClass.printCharIfNotThere(' ');
        this.renderSuperTypes($this$renderRegularClass, regularClass);
        this.renderWhereSuffix($this$renderRegularClass, regularClass);
        this.renderClassBody($this$renderRegularClass, regularClass);
    }

    private final void renderClassName(PrettyPrinter $this$renderClassName, FirRegularClass regularClass) {
        FirRegularClass $this$isCompanion$iv = regularClass;
        boolean $i$f$isCompanion = false;
        if (!$this$isCompanion$iv.getStatus().isCompanion()) {
            this.renderName($this$renderClassName, regularClass);
        } else if (!Intrinsics.areEqual((Object)regularClass.getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
            $this$renderClassName.append(RenderingUtilsKt.render(regularClass.getName()));
        }
    }

    private final void renderTypeAlias(PrettyPrinter $this$renderTypeAlias, FirTypeAlias typeAlias) {
        this.renderAnnotationsAndModifiers($this$renderTypeAlias, typeAlias);
        $this$renderTypeAlias.append("typealias ");
        this.renderName($this$renderTypeAlias, typeAlias);
        this.renderTypeParameters($this$renderTypeAlias, typeAlias);
        $this$renderTypeAlias.printCharIfNotThere(' ');
        $this$renderTypeAlias.append("= ");
        FirIdeRendererBase.renderType$default(this, $this$renderTypeAlias, typeAlias.getExpandedTypeRef(), false, 2, null);
    }

    private final void renderEnumEntry(PrettyPrinter $this$renderEnumEntry, FirEnumEntry enumEntry) {
        this.renderName($this$renderEnumEntry, enumEntry);
    }

    private final void renderTypeParameter(PrettyPrinter $this$renderTypeParameter, FirTypeParameter typeParameter) {
        FirTypeRef upperBound2;
        this.renderIf($this$renderTypeParameter, typeParameter.isReified(), "reified");
        String variance = typeParameter.getVariance().getLabel();
        this.renderIf($this$renderTypeParameter, ((CharSequence)variance).length() > 0, variance);
        this.renderAnnotations($this$renderTypeParameter, typeParameter);
        this.renderName($this$renderTypeParameter, typeParameter);
        int upperBoundsCount = typeParameter.getBounds().size();
        if (upperBoundsCount >= 1 && !FirTypeUtilsKt.isNullableAny(upperBound2 = (FirTypeRef)CollectionsKt.first(typeParameter.getBounds()))) {
            $this$renderTypeParameter.append(" : ");
            FirIdeRendererBase.renderType$default(this, $this$renderTypeParameter, upperBound2, false, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameters(PrettyPrinter $this$renderTypeParameters, FirMemberDeclaration declaration) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = declaration.getTypeParameters();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirTypeParameter)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List typeParameters2 = (List)destination$iv$iv;
        if (!((Collection)typeParameters2).isEmpty()) {
            $this$renderTypeParameters.append("<");
            String separator$iv = ", ";
            String prefix$iv = "";
            String postfix$iv = "";
            boolean $i$f$printCollection = false;
            $this$renderTypeParameters.append(prefix$iv);
            Iterator iterator$iv = ((Iterable)typeParameters2).iterator();
            while (iterator$iv.hasNext()) {
                void it;
                FirTypeParameter firTypeParameter = (FirTypeParameter)iterator$iv.next();
                PrettyPrinter $this$renderTypeParameters_u24lambda_u2410 = $this$renderTypeParameters;
                boolean bl = false;
                this.renderTypeParameter($this$renderTypeParameters_u24lambda_u2410, (FirTypeParameter)it);
                if (!iterator$iv.hasNext()) continue;
                $this$renderTypeParameters.append(separator$iv);
            }
            $this$renderTypeParameters.append(postfix$iv);
            $this$renderTypeParameters.append("> ");
        }
    }

    private final void renderReceiver(PrettyPrinter $this$renderReceiver, FirCallableDeclaration firCallableDeclaration) {
        FirTypeRef receiverType = firCallableDeclaration.getReceiverTypeRef();
        if (receiverType != null) {
            boolean needBrackets;
            if (this.getOptions().getRenderDeclarationHeader()) {
                this.renderAnnotations($this$renderReceiver, firCallableDeclaration);
            }
            boolean bl = needBrackets = this.getTypeIdeRenderer().shouldRenderAsPrettyFunctionType(FirTypeUtilsKt.getConeType(receiverType)) && Intrinsics.areEqual((Object)FirTypeUtilsKt.isMarkedNullable(receiverType), (Object)true);
            if (needBrackets) {
                $this$renderReceiver.append('(');
            }
            FirIdeRendererBase.renderType$default(this, $this$renderReceiver, receiverType, false, 2, null);
            if (needBrackets) {
                $this$renderReceiver.append(')');
            }
            $this$renderReceiver.append(".");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(PrettyPrinter $this$renderWhereSuffix, FirTypeParameterRefsOwner declaration) {
        ArrayList upperBoundStrings = new ArrayList(0);
        for (FirTypeParameterRef typeParameter : declaration.getTypeParameters()) {
            void $this$mapTo$iv;
            if (!(typeParameter instanceof FirTypeParameter)) continue;
            Iterable iterable = CollectionsKt.drop((Iterable)typeParameter.getSymbol().getResolvedBounds(), (int)1);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv;
                Collection collection = upperBoundStrings;
                boolean bl = false;
                collection.add(RenderingUtilsKt.render(((FirTypeParameter)typeParameter).getName()) + " : " + this.renderTypeToString(FirTypeUtilsKt.getConeType((FirTypeRef)it)));
            }
        }
        if (!((Collection)upperBoundStrings).isEmpty()) {
            $this$renderWhereSuffix.append("where ");
            CollectionsKt.joinTo$default((Iterable)upperBoundStrings, (Appendable)$this$renderWhereSuffix, (CharSequence)", ", null, null, (int)0, null, null, (int)124, null);
            $this$renderWhereSuffix.append(' ');
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderValueParameters(PrettyPrinter $this$renderValueParameters, FirFunction function2) {
        void collection$iv;
        void prefix$iv;
        Iterable iterable = function2.getValueParameters();
        String string2 = "(";
        String postfix$iv = ")";
        String separator$iv = ", ";
        boolean $i$f$printCollection = false;
        $this$renderValueParameters.append((CharSequence)prefix$iv);
        Iterator iterator$iv = collection$iv.iterator();
        while (iterator$iv.hasNext()) {
            void it;
            FirValueParameter firValueParameter = (FirValueParameter)iterator$iv.next();
            PrettyPrinter $this$renderValueParameters_u24lambda_u2412 = $this$renderValueParameters;
            boolean bl = false;
            this.renderValueParameter($this$renderValueParameters_u24lambda_u2412, (FirValueParameter)it);
            if (!iterator$iv.hasNext()) continue;
            $this$renderValueParameters.append(separator$iv);
        }
        $this$renderValueParameters.append(postfix$iv);
    }

    private final void renderValueParameter(PrettyPrinter $this$renderValueParameter, FirValueParameter valueParameter2) {
        if (this.getOptions().getRenderDeclarationHeader()) {
            this.renderAnnotations($this$renderValueParameter, valueParameter2);
        }
        this.renderIf($this$renderValueParameter, valueParameter2.isCrossinline(), "crossinline");
        this.renderIf($this$renderValueParameter, valueParameter2.isNoinline(), "noinline");
        this.renderVariable($this$renderValueParameter, valueParameter2);
        if (this.getOptions().getRenderDefaultParameterValue()) {
            boolean withDefaultValue;
            boolean bl = withDefaultValue = valueParameter2.getDefaultValue() != null;
            if (withDefaultValue) {
                $this$renderValueParameter.append(" = ...");
            }
        }
    }

    private final void renderValVarPrefix(PrettyPrinter $this$renderValVarPrefix, FirVariable variable2, boolean isInPrimaryConstructor) {
        if (!isInPrimaryConstructor || !(variable2 instanceof FirValueParameter)) {
            $this$renderValVarPrefix.append(variable2.isVar() ? "var" : "val");
            $this$renderValVarPrefix.append(' ');
        }
    }

    static /* synthetic */ void renderValVarPrefix$default(FirIdeRenderer firIdeRenderer, PrettyPrinter prettyPrinter, FirVariable firVariable, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        firIdeRenderer.renderValVarPrefix(prettyPrinter, firVariable, bl);
    }

    private final void renderVariable(PrettyPrinter $this$renderVariable, FirVariable variable2) {
        ConeKotlinType typeToRender = FirTypeUtilsKt.getConeType(variable2.getReturnTypeRef());
        FirValueParameter firValueParameter = variable2 instanceof FirValueParameter ? (FirValueParameter)variable2 : null;
        boolean isVarArg = firValueParameter != null ? firValueParameter.isVararg() : false;
        this.renderIf($this$renderVariable, isVarArg, "vararg");
        this.renderName($this$renderVariable, variable2);
        $this$renderVariable.append(": ");
        if (isVarArg) {
            ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType(typeToRender);
            if (coneKotlinType == null) {
                coneKotlinType = typeToRender;
            }
            this.renderType($this$renderVariable, coneKotlinType);
        } else {
            this.renderType($this$renderVariable, typeToRender);
        }
    }

    @NotNull
    public final List<FirMemberDeclaration> sortDeclarations(@NotNull List<? extends FirMemberDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        if (!this.getOptions().getSortNestedDeclarations()) {
            return declarations2;
        }
        return CollectionsKt.sortedWith((Iterable)declarations2, (arg_0, arg_1) -> FirIdeRenderer.sortDeclarations$lambda$15(this, arg_0, arg_1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean renderPropertyOrField$needToRender(FirPropertyAccessor $this$renderPropertyOrField_u24needToRender, FirVariable $variable) {
        if ($this$renderPropertyOrField_u24needToRender == null) return false;
        if (!((Collection)$this$renderPropertyOrField_u24needToRender.getAnnotations()).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        FirMemberDeclaration $this$visibility$iv = $this$renderPropertyOrField_u24needToRender;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        $this$visibility$iv = $variable;
        $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)visibility2, (Object)$this$visibility$iv.getStatus().getVisibility())) return false;
        return true;
    }

    private static final int sortDeclarations$getDeclarationKind(FirDeclaration declaration) {
        FirDeclaration firDeclaration = declaration;
        return firDeclaration instanceof FirEnumEntry ? 0 : (firDeclaration instanceof FirConstructor ? (((FirConstructor)declaration).isPrimary() ? 1 : 2) : (firDeclaration instanceof FirProperty ? 3 : (firDeclaration instanceof FirFunction ? 4 : 5)));
    }

    private static final int sortDeclarations$lambda$15(FirIdeRenderer this$0, FirMemberDeclaration left, FirMemberDeclaration right) {
        PrettyPrinter prettyPrinter;
        PrettyPrinter prettyPrinter2;
        int nameResult;
        String string2;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)left, (String)"left");
        int n = FirIdeRenderer.sortDeclarations$getDeclarationKind(left);
        Intrinsics.checkNotNullExpressionValue((Object)right, (String)"right");
        int kindResult = n - FirIdeRenderer.sortDeclarations$getDeclarationKind(right);
        if (kindResult != 0) {
            return kindResult;
        }
        String string3 = PsiSourceNavigator.INSTANCE.getRawName(left);
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = PsiSourceNavigator.INSTANCE.getRawName(right)) == null) {
            string2 = "";
        }
        if ((nameResult = string3.compareTo(string2)) != 0) {
            return nameResult;
        }
        boolean $i$f$prettyPrint = false;
        PrettyPrinter $this$sortDeclarations_u24lambda_u2415_u24lambda_u2413 = prettyPrinter2 = new PrettyPrinter(0, 1, null);
        boolean bl = false;
        this$0.renderMemberDeclaration($this$sortDeclarations_u24lambda_u2415_u24lambda_u2413, left);
        String leftString = prettyPrinter2.toString();
        boolean $i$f$prettyPrint2 = false;
        PrettyPrinter $this$sortDeclarations_u24lambda_u2415_u24lambda_u2414 = prettyPrinter = new PrettyPrinter(0, 1, null);
        boolean bl2 = false;
        this$0.renderMemberDeclaration($this$sortDeclarations_u24lambda_u2415_u24lambda_u2414, right);
        String rightString = prettyPrinter.toString();
        return leftString.compareTo(rightString);
    }

    public /* synthetic */ FirIdeRenderer(KtDeclarationRendererOptions options, FirSession session2, DefaultConstructorMarker $constructor_marker) {
        this(options, session2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/renderer/FirIdeRenderer$Companion;", "", "()V", "render", "", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "options", "Lorg/jetbrains/kotlin/analysis/api/components/KtDeclarationRendererOptions;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "analysis-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String render(@NotNull FirDeclaration firDeclaration, @NotNull KtDeclarationRendererOptions options, @NotNull FirSession session2) {
            void $this$trim$iv;
            PrettyPrinter prettyPrinter;
            Intrinsics.checkNotNullParameter((Object)firDeclaration, (String)"firDeclaration");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            FirIdeRenderer renderer2 = new FirIdeRenderer(options, session2, null);
            boolean $i$f$prettyPrint22 = false;
            PrettyPrinter $this$render_u24lambda_u241 = prettyPrinter = new PrettyPrinter(0, 1, null);
            boolean bl = false;
            FirIdeRenderer $this$render_u24lambda_u241_u24lambda_u240 = renderer2;
            boolean bl2 = false;
            $this$render_u24lambda_u241_u24lambda_u240.renderMemberDeclaration($this$render_u24lambda_u241, firDeclaration);
            String $i$f$prettyPrint22 = prettyPrinter.toString();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl3 = false;
                boolean match$iv$iv = CharsKt.isWhitespace((char)it);
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

