/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.backend.jvm.intrinsics.SignatureString;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.inline.ReifiedTypeInliner;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBasedDescriptorsKt;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0018\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0011H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020\u0002H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/codegen/IrInlineIntrinsicsSupport;", "Lorg/jetbrains/kotlin/codegen/inline/ReifiedTypeInliner$IntrinsicsSupport;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "typeMapper", "Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;", "reportErrorsOn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "containingFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/backend/jvm/mapping/IrTypeMapper;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "getState", "()Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "generateCallableReference", "", "v", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "implClass", "Lorg/jetbrains/org/objectweb/asm/Type;", "withArity", "", "generateFunctionReference", "generatePropertyReference", "property", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "generateTypeParameterContainer", "typeParameter", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "isMutableCollectionType", "type", "putClassInstance", "reportNonReifiedTypeParameterWithRecursiveBoundUnsupported", "typeParameterName", "Lorg/jetbrains/kotlin/name/Name;", "reportSuspendTypeUnsupported", "toKotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "backend.jvm.codegen"})
public final class IrInlineIntrinsicsSupport
implements ReifiedTypeInliner.IntrinsicsSupport<IrType> {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrTypeMapper typeMapper;
    @NotNull
    private final IrExpression reportErrorsOn;
    @NotNull
    private final IrFile containingFile;

    public IrInlineIntrinsicsSupport(@NotNull JvmBackendContext context, @NotNull IrTypeMapper typeMapper2, @NotNull IrExpression reportErrorsOn, @NotNull IrFile containingFile) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)typeMapper2, (String)"typeMapper");
        Intrinsics.checkNotNullParameter((Object)reportErrorsOn, (String)"reportErrorsOn");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        this.context = context;
        this.typeMapper = typeMapper2;
        this.reportErrorsOn = reportErrorsOn;
        this.containingFile = containingFile;
    }

    @Override
    @NotNull
    public GenerationState getState() {
        return this.context.getState();
    }

    @Override
    public void putClassInstance(@NotNull InstructionAdapter v, @NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ExpressionCodegen.Companion.generateClassInstance$backend_jvm_codegen(v, type2, this.typeMapper);
    }

    @Override
    public void generateTypeParameterContainer(@NotNull InstructionAdapter v, @NotNull TypeParameterMarker typeParameter) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        if (!(typeParameter instanceof IrTypeParameterSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        IrDeclarationParent parent2 = ((IrTypeParameter)((IrTypeParameterSymbol)typeParameter).getOwner()).getParent();
        if (parent2 instanceof IrClass) {
            Unit unit2;
            this.putClassInstance(v, IrUtilsKt.getDefaultType((IrClass)parent2));
            Unit it = unit2 = Unit.INSTANCE;
            boolean bl = false;
            AsmUtil.wrapJavaClassIntoKClass(v);
        } else if (parent2 instanceof IrSimpleFunction) {
            if (!this.context.getState().getGenerateOptimizedCallableReferenceSuperClasses()) {
                boolean bl = false;
                String string3 = "typeOf() of a non-reified type parameter is only allowed if optimized callable references are enabled.\nPlease make sure API version is set to 1.4, and -Xno-optimized-callable-references is NOT used.\nContainer: " + parent2;
                throw new IllegalStateException(string3.toString());
            }
            IrPropertySymbol property2 = ((IrSimpleFunction)parent2).getCorrespondingPropertySymbol();
            if (property2 != null) {
                this.generatePropertyReference(v, (IrProperty)property2.getOwner());
            } else {
                this.generateFunctionReference(v, (IrFunction)parent2);
            }
        } else {
            throw new IllegalStateException(("Unknown parent of type parameter: " + RenderIrElementKt.render(parent2) + ' ' + ((IrTypeParameter)((IrTypeParameterSymbol)typeParameter).getOwner()).getName() + ')').toString());
        }
    }

    private final void generateFunctionReference(InstructionAdapter v, IrFunction function2) {
        IrDeclarationWithName irDeclarationWithName = function2;
        Type type2 = AsmTypes.FUNCTION_REFERENCE_IMPL;
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"FUNCTION_REFERENCE_IMPL");
        this.generateCallableReference(v, irDeclarationWithName, function2, type2, true);
    }

    private final void generatePropertyReference(InstructionAdapter v, IrProperty property2) {
        IrSimpleFunction irSimpleFunction = property2.getGetter();
        if (irSimpleFunction == null) {
            throw new IllegalStateException(("Property without getter: " + RenderIrElementKt.render(property2)).toString());
        }
        IrSimpleFunction getter2 = irSimpleFunction;
        int arity = IrUtilsKt.getAllParametersCount(getter2);
        Type[] typeArray = property2.isVar() ? AsmTypes.MUTABLE_PROPERTY_REFERENCE_IMPL : AsmTypes.PROPERTY_REFERENCE_IMPL;
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"if (property.isVar) MUTA\u2026e PROPERTY_REFERENCE_IMPL");
        Type type2 = (Type)ArraysKt.getOrNull((Object[])typeArray, (int)arity);
        if (type2 == null) {
            throw new IllegalStateException(("No property reference impl class with arity " + arity + " (" + RenderIrElementKt.render(property2)).toString());
        }
        Type implClass = type2;
        this.generateCallableReference(v, property2, getter2, implClass, false);
    }

    private final void generateCallableReference(InstructionAdapter v, IrDeclarationWithName declaration, IrFunction function2, Type implClass, boolean withArity) {
        v.anew(implClass);
        v.dup();
        if (withArity) {
            v.iconst(IrUtilsKt.getAllParametersCount(function2));
        }
        this.putClassInstance(v, JvmIrUtilsKt.getCallableReferenceOwnerKClassType(declaration.getParent(), this.context));
        v.aconst((Object)declaration.getName().asString());
        SignatureString.INSTANCE.generateSignatureString$backend_jvm_codegen(v, function2, this.context);
        v.iconst(JvmIrUtilsKt.getCallableReferenceTopLevelFlag(declaration));
        Object[] objectArray = new Type[]{AsmTypes.JAVA_CLASS_TYPE, AsmTypes.JAVA_STRING_TYPE, AsmTypes.JAVA_STRING_TYPE, Type.INT_TYPE};
        List parameterTypes2 = CollectionsKt.plus((Collection)(withArity ? CollectionsKt.listOf((Object)Type.INT_TYPE) : CollectionsKt.emptyList()), (Iterable)CollectionsKt.listOf((Object[])objectArray));
        String string2 = implClass.getInternalName();
        Collection $this$toTypedArray$iv = parameterTypes2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Type[] typeArray = thisCollection$iv.toArray(new Type[0]);
        Intrinsics.checkNotNull((Object)typeArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        objectArray = typeArray;
        v.invokespecial(string2, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])((Type[])Arrays.copyOf(objectArray, objectArray.length))), false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMutableCollectionType(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        IrClassSymbol classifier = IrTypesKt.getClassOrNull(type2);
        if (classifier == null) return false;
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)classifier.getOwner());
        if (!JavaToKotlinClassMap.INSTANCE.isMutable(fqName2 != null ? fqName2.toUnsafe() : null)) return false;
        return true;
    }

    @Override
    @NotNull
    public KotlinType toKotlinType(@NotNull IrType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return IrBasedDescriptorsKt.toIrBasedKotlinType(type2);
    }

    @Override
    public void reportSuspendTypeUnsupported() {
        KtDiagnosticReporterWithContext.DiagnosticContextImpl.report$default(this.context.getKtDiagnosticReporter().at((IrElement)this.reportErrorsOn, this.containingFile), JvmBackendErrors.INSTANCE.getTYPEOF_SUSPEND_TYPE(), null, 2, null);
    }

    @Override
    public void reportNonReifiedTypeParameterWithRecursiveBoundUnsupported(@NotNull Name typeParameterName) {
        Intrinsics.checkNotNullParameter((Object)typeParameterName, (String)"typeParameterName");
        KtDiagnosticReporterWithContext.DiagnosticContextImpl diagnosticContextImpl = this.context.getKtDiagnosticReporter().at((IrElement)this.reportErrorsOn, this.containingFile);
        KtDiagnosticFactory1<String> ktDiagnosticFactory1 = JvmBackendErrors.INSTANCE.getTYPEOF_NON_REIFIED_TYPE_PARAMETER_WITH_RECURSIVE_BOUND();
        String string2 = typeParameterName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeParameterName.asString()");
        KtDiagnosticReporterWithContext.DiagnosticContextImpl.report$default(diagnosticContextImpl, ktDiagnosticFactory1, string2, null, 4, null);
    }
}

