/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ResultClassInReturnTypeChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isForbiddenReturnType", "", "returnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "declarationDescriptor", "frontend"})
public final class ResultClassInReturnTypeChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LanguageVersionSettings languageVersionSettings2 = context.getLanguageVersionSettings();
        if (languageVersionSettings2.getFlag(AnalysisFlags.getAllowResultReturnType()).booleanValue()) {
            return;
        }
        if ((languageVersionSettings2.getFeatureSupport(LanguageFeature.InlineClasses) == LanguageFeature.State.ENABLED || languageVersionSettings2.supportsFeature(LanguageFeature.JvmInlineValueClasses)) && languageVersionSettings2.supportsFeature(LanguageFeature.AllowResultInReturnType)) {
            return;
        }
        if (languageVersionSettings2.supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        if (!(declaration instanceof KtCallableDeclaration) || !(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType2 = kotlinType;
        if (this.isForbiddenReturnType(returnType2, declaration, descriptor2)) {
            PsiElement psiElement;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration).getTypeReference();
            if (ktTypeReference != null) {
                psiElement = ktTypeReference;
            } else {
                psiElement = ((KtCallableDeclaration)declaration).getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
            }
            PsiElement typeReferenceOrDeclarationName = psiElement;
            BindingTrace bindingTrace = context.getTrace();
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.RESULT_CLASS_IN_RETURN_TYPE.on(typeReferenceOrDeclarationName);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, (String)"RESULT_CLASS_IN_RETURN_T\u2026ferenceOrDeclarationName)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private final boolean isForbiddenReturnType(KotlinType returnType2, KtDeclaration declaration, DeclarationDescriptor declarationDescriptor) {
        if (!ResultClassInReturnTypeCheckerKt.isResultType(returnType2)) {
            return false;
        }
        if (declarationDescriptor instanceof PropertyDescriptor || declarationDescriptor instanceof PropertyGetterDescriptor) {
            if (declaration instanceof KtProperty) {
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration).getGetter();
                boolean bl = ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
                if (bl) {
                    return true;
                }
            }
            DescriptorVisibility descriptorVisibility = ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility();
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"declarationDescriptor as\u2026ithVisibility).visibility");
            DescriptorVisibility visibility2 = descriptorVisibility;
            return !DescriptorVisibilities.isPrivate(visibility2) && !Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.LOCAL);
        }
        return true;
    }
}

