/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.KtTypeArgument;
import org.jetbrains.kotlin.analysis.api.components.KtSamResolver;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirSamResolver;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSamConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.pointers.PointerUtilsKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSamConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtSubstitutor;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirBodyResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0010B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSamResolver;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getSamConstructor", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSamConstructorSymbol;", "ktClassLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "LocalSamResolver", "analysis-api-fir"})
public final class KtFirSamResolver
extends KtSamResolver
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirSamResolver(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KtSamConstructorSymbol getSamConstructor(@NotNull KtClassLikeSymbol ktClassLikeSymbol) {
        KtFirSamConstructorSymbol ktFirSamConstructorSymbol;
        Intrinsics.checkNotNullParameter((Object)ktClassLikeSymbol, (String)"ktClassLikeSymbol");
        ClassId classId = ktClassLikeSymbol.getClassIdIfNonLocal();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        FirClassLikeDeclaration firClassLikeDeclaration = PointerUtilsKt.getClassLikeSymbol(this.getAnalysisSession(), classId2);
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass owner = firRegularClass;
        LocalSamResolver resolver = new LocalSamResolver(this.getAnalysisSession(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
        FirSimpleFunction firSimpleFunction = resolver.getSamConstructor(owner);
        if (firSimpleFunction != null) {
            FirSimpleFunction it = firSimpleFunction;
            boolean bl = false;
            ktFirSamConstructorSymbol = this.getAnalysisSession().getFirSymbolBuilder$analysis_api_fir().getFunctionLikeBuilder().buildSamConstructorSymbol(it.getSymbol());
        } else {
            ktFirSamConstructorSymbol = null;
        }
        return ktFirSamConstructorSymbol;
    }

    @Override
    @NotNull
    public FirSession getRootModuleSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getRootModuleSession(this);
    }

    @Override
    @NotNull
    public ConeInferenceContext getTypeContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getTypeContext(this);
    }

    @Override
    @NotNull
    public KtSymbolByFirBuilder getFirSymbolBuilder() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirSymbolBuilder(this);
    }

    @Override
    @NotNull
    public LLFirResolveSession getFirResolveSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirResolveSession(this);
    }

    @Override
    @NotNull
    public KtType asKtType(@NotNull ConeKotlinType $this$asKtType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtType(this, $this$asKtType);
    }

    @Override
    @NotNull
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull KtPsiDiagnostic $this$asKtDiagnostic) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic);
    }

    @Override
    @Nullable
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull ConeDiagnostic $this$asKtDiagnostic, @NotNull KtSourceElement source2, @Nullable KtSourceElement qualifiedAccessSource) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic, source2, qualifiedAccessSource);
    }

    @Override
    @NotNull
    public ConeKotlinType getConeType(@NotNull KtType $this$coneType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeType(this, $this$coneType);
    }

    @Override
    @NotNull
    public ConeTypeProjection getConeTypeProjection(@NotNull KtTypeArgument $this$coneTypeProjection) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeTypeProjection(this, $this$coneTypeProjection);
    }

    @Override
    @NotNull
    public TypeCheckerState createTypeCheckerContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.createTypeCheckerContext(this);
    }

    @Override
    @Nullable
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @Nullable
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @NotNull
    public KtSubstitutor toKtSubstitutor(@NotNull ConeSubstitutor $this$toKtSubstitutor) {
        return KtFirAnalysisSessionComponent.DefaultImpls.toKtSubstitutor(this, $this$toKtSubstitutor);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\f\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver;", "", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/fir/FirSession;)V", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "stubBodyResolveTransformer", "org/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver$stubBodyResolveTransformer$1", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver$stubBodyResolveTransformer$1;", "getSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "analysis-api-fir"})
    private static final class LocalSamResolver {
        @NotNull
        private final FirSession firSession;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final stubBodyResolveTransformer.1 stubBodyResolveTransformer;
        @NotNull
        private final FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents bodyResolveComponents;

        public LocalSamResolver(@NotNull KtFirAnalysisSession analysisSession, @NotNull FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
            Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
            this.firSession = firSession;
            this.scopeSession = analysisSession.getScopeSessionFor(this.firSession);
            FirSession firSession2 = this.firSession;
            FirResolvePhase firResolvePhase = FirResolvePhase.BODY_RESOLVE;
            ScopeSession scopeSession = this.scopeSession;
            this.stubBodyResolveTransformer = new FirBodyResolveTransformer(firSession2, firResolvePhase, scopeSession){};
            this.bodyResolveComponents = new FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents(this.firSession, this.scopeSession, this.stubBodyResolveTransformer, this.stubBodyResolveTransformer.getContext());
        }

        @Nullable
        public final FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firClass) {
            Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
            FirSimpleFunction firSimpleFunction = this.bodyResolveComponents.getSamResolver().getSamConstructor(firClass);
            if (firSimpleFunction == null) {
                return null;
            }
            FirSimpleFunction samConstructor = firSimpleFunction;
            if (!Intrinsics.areEqual((Object)samConstructor.getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
                return null;
            }
            return samConstructor;
        }
    }
}

