/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.jline.builtins.NfaMatcher;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class Completers {

    public static class RegexCompleter
    implements org.jline.reader.Completer {
        private final NfaMatcher<String> matcher;
        private final Function<String, org.jline.reader.Completer> completers;

        public RegexCompleter(String syntax, Function<String, org.jline.reader.Completer> completers) {
            this.matcher = new NfaMatcher<String>(syntax, this::doMatch);
            this.completers = completers;
        }

        @Override
        public synchronized void complete(LineReader reader, ParsedLine line, List<Candidate> candidates2) {
            List<String> words = line.words().subList(0, line.wordIndex());
            Set<String> next = this.matcher.matchPartial(words);
            for (String n : next) {
                this.completers.apply(n).complete(reader, new ArgumentLine(n, n.length()), candidates2);
            }
        }

        private boolean doMatch(String arg, String name2) {
            ArrayList<Candidate> candidates2 = new ArrayList<Candidate>();
            this.completers.apply(name2).complete(null, new ArgumentLine(arg, arg.length()), candidates2);
            return candidates2.stream().anyMatch(c -> c.value().equals(arg));
        }

        public static class ArgumentLine
        implements ParsedLine {
            private final String word;
            private final int cursor;

            public ArgumentLine(String word, int cursor) {
                this.word = word;
                this.cursor = cursor;
            }

            @Override
            public String word() {
                return this.word;
            }

            @Override
            public int wordCursor() {
                return this.cursor;
            }

            @Override
            public int wordIndex() {
                return 0;
            }

            @Override
            public List<String> words() {
                return Collections.singletonList(this.word);
            }

            @Override
            public String line() {
                return this.word;
            }

            @Override
            public int cursor() {
                return this.cursor;
            }
        }
    }

    public static class TreeCompleter
    implements org.jline.reader.Completer {
        final Map<String, org.jline.reader.Completer> completers = new HashMap<String, org.jline.reader.Completer>();
        final RegexCompleter completer;

        public TreeCompleter(Node ... nodes) {
            this(Arrays.asList(nodes));
        }

        public TreeCompleter(List<Node> nodes) {
            StringBuilder sb = new StringBuilder();
            this.addRoots(sb, nodes);
            this.completer = new RegexCompleter(sb.toString(), this.completers::get);
        }

        public static Node node(Object ... objs) {
            org.jline.reader.Completer comp = null;
            ArrayList<Candidate> cands = new ArrayList<Candidate>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Object obj : objs) {
                if (obj instanceof String) {
                    cands.add(new Candidate((String)obj));
                    continue;
                }
                if (obj instanceof Candidate) {
                    cands.add((Candidate)obj);
                    continue;
                }
                if (obj instanceof Node) {
                    nodes.add((Node)obj);
                    continue;
                }
                if (obj instanceof Completer) {
                    comp = (org.jline.reader.Completer)obj;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (comp != null) {
                if (!cands.isEmpty()) {
                    throw new IllegalArgumentException();
                }
                return new Node(comp, nodes);
            }
            if (!cands.isEmpty()) {
                return new Node((r, l, c) -> c.addAll(cands), nodes);
            }
            throw new IllegalArgumentException();
        }

        void addRoots(StringBuilder sb, List<Node> nodes) {
            if (!nodes.isEmpty()) {
                sb.append(" ( ");
                boolean first = true;
                for (Node n : nodes) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" | ");
                    }
                    String name2 = "c" + this.completers.size();
                    this.completers.put(name2, n.completer);
                    sb.append(name2);
                    this.addRoots(sb, n.nodes);
                }
                sb.append(" ) ");
            }
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates2) {
            this.completer.complete(reader, line, candidates2);
        }

        public static class Node {
            final org.jline.reader.Completer completer;
            final List<Node> nodes;

            public Node(org.jline.reader.Completer completer, List<Node> nodes) {
                this.completer = completer;
                this.nodes = nodes;
            }
        }
    }

    public static class FileNameCompleter
    implements org.jline.reader.Completer {
        @Override
        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates2) {
            Path current;
            String curBuf;
            assert (commandLine != null);
            assert (candidates2 != null);
            String buffer = commandLine.word().substring(0, commandLine.wordCursor());
            int lastSep = buffer.lastIndexOf(File.separator);
            if (lastSep >= 0) {
                curBuf = buffer.substring(0, lastSep + 1);
                current = curBuf.startsWith("~") ? (curBuf.startsWith("~/") ? this.getUserHome().resolve(curBuf.substring(2)) : this.getUserHome().getParent().resolve(curBuf.substring(1))) : this.getUserDir().resolve(curBuf);
            } else {
                curBuf = "";
                current = this.getUserDir();
            }
            try {
                Files.newDirectoryStream(current, this::accept).forEach(p -> {
                    String value2 = curBuf + p.getFileName().toString();
                    if (Files.isDirectory(p, new LinkOption[0])) {
                        candidates2.add(new Candidate(value2 + (reader.isSet(LineReader.Option.AUTO_PARAM_SLASH) ? "/" : ""), this.getDisplay(reader.getTerminal(), (Path)p), null, null, reader.isSet(LineReader.Option.AUTO_REMOVE_SLASH) ? "/" : null, null, false));
                    } else {
                        candidates2.add(new Candidate(value2, this.getDisplay(reader.getTerminal(), (Path)p), null, null, null, null, true));
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected boolean accept(Path path2) {
            try {
                return !Files.isHidden(path2);
            }
            catch (IOException e) {
                return false;
            }
        }

        protected Path getUserDir() {
            return Paths.get(System.getProperty("user.dir"), new String[0]);
        }

        protected Path getUserHome() {
            return Paths.get(System.getProperty("user.home"), new String[0]);
        }

        protected String getDisplay(Terminal terminal, Path p) {
            String name2 = p.getFileName().toString();
            if (Files.isDirectory(p, new LinkOption[0])) {
                AttributedStringBuilder sb = new AttributedStringBuilder();
                sb.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)name2);
                sb.append("/");
                name2 = sb.toAnsi(terminal);
            } else if (Files.isSymbolicLink(p)) {
                AttributedStringBuilder sb = new AttributedStringBuilder();
                sb.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)name2);
                sb.append("@");
                name2 = sb.toAnsi(terminal);
            }
            return name2;
        }
    }

    public static class FilesCompleter
    extends FileNameCompleter {
        private final Path currentDir;

        public FilesCompleter(File currentDir) {
            this(currentDir.toPath());
        }

        public FilesCompleter(Path currentDir) {
            this.currentDir = currentDir;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir;
        }
    }

    public static class DirectoriesCompleter
    extends FileNameCompleter {
        private final Path currentDir;

        public DirectoriesCompleter(File currentDir) {
            this(currentDir.toPath());
        }

        public DirectoriesCompleter(Path currentDir) {
            this.currentDir = currentDir;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir;
        }

        @Override
        protected boolean accept(Path path2) {
            return Files.isDirectory(path2, new LinkOption[0]) && super.accept(path2);
        }
    }

    public static class Completer
    implements org.jline.reader.Completer {
        private final CompletionEnvironment environment;

        public Completer(CompletionEnvironment environment2) {
            this.environment = environment2;
        }

        @Override
        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates2) {
            if (line.wordIndex() == 0) {
                this.completeCommand(candidates2);
            } else {
                this.tryCompleteArguments(reader, line, candidates2);
            }
        }

        protected void tryCompleteArguments(LineReader reader, ParsedLine line, List<Candidate> candidates2) {
            List<CompletionData> cmd;
            String command = line.words().get(0);
            String resolved = this.environment.resolveCommand(command);
            Map<String, List<CompletionData>> comp = this.environment.getCompletions();
            if (comp != null && (cmd = comp.get(resolved)) != null) {
                this.completeCommandArguments(reader, line, candidates2, cmd);
            }
        }

        protected void completeCommandArguments(LineReader reader, ParsedLine line, List<Candidate> candidates2, List<CompletionData> completions) {
            for (CompletionData completion : completions) {
                Object res2;
                boolean isOption = line.word().startsWith("-");
                String prevOption = line.wordIndex() >= 2 && line.words().get(line.wordIndex() - 1).startsWith("-") ? line.words().get(line.wordIndex() - 1) : null;
                String key = UUID.randomUUID().toString();
                boolean conditionValue = true;
                if (completion.condition != null) {
                    res2 = Boolean.FALSE;
                    try {
                        res2 = this.environment.evaluate(reader, line, completion.condition);
                    }
                    catch (Throwable t) {
                        t.getCause();
                    }
                    conditionValue = this.isTrue(res2);
                }
                if (conditionValue && isOption && completion.options != null) {
                    for (String opt : completion.options) {
                        candidates2.add(new Candidate(opt, opt, "options", completion.description, null, key, true));
                    }
                    continue;
                }
                if (!isOption && prevOption != null && completion.argument != null && completion.options != null && completion.options.contains(prevOption)) {
                    res2 = null;
                    try {
                        res2 = this.environment.evaluate(reader, line, completion.argument);
                    }
                    catch (Throwable opt) {
                        // empty catch block
                    }
                    if (res2 instanceof Candidate) {
                        candidates2.add((Candidate)res2);
                        continue;
                    }
                    if (res2 instanceof String) {
                        candidates2.add(new Candidate((String)res2, (String)res2, null, null, null, null, true));
                        continue;
                    }
                    if (res2 instanceof Collection) {
                        for (Object s : (Collection)res2) {
                            if (s instanceof Candidate) {
                                candidates2.add((Candidate)s);
                                continue;
                            }
                            if (!(s instanceof String)) continue;
                            candidates2.add(new Candidate((String)s, (String)s, null, null, null, null, true));
                        }
                        continue;
                    }
                    if (res2 == null || !res2.getClass().isArray()) continue;
                    int l = Array.getLength(res2);
                    for (int i = 0; i < l; ++i) {
                        Object s = Array.get(res2, i);
                        if (s instanceof Candidate) {
                            candidates2.add((Candidate)s);
                            continue;
                        }
                        if (!(s instanceof String)) continue;
                        candidates2.add(new Candidate((String)s, (String)s, null, null, null, null, true));
                    }
                    continue;
                }
                if (isOption || completion.argument == null) continue;
                res2 = null;
                try {
                    res2 = this.environment.evaluate(reader, line, completion.argument);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (res2 instanceof Candidate) {
                    candidates2.add((Candidate)res2);
                    continue;
                }
                if (res2 instanceof String) {
                    candidates2.add(new Candidate((String)res2, (String)res2, null, completion.description, null, null, true));
                    continue;
                }
                if (!(res2 instanceof Collection)) continue;
                for (Object s : (Collection)res2) {
                    if (s instanceof Candidate) {
                        candidates2.add((Candidate)s);
                        continue;
                    }
                    if (!(s instanceof String)) continue;
                    candidates2.add(new Candidate((String)s, (String)s, null, completion.description, null, null, true));
                }
            }
        }

        protected void completeCommand(List<Candidate> candidates2) {
            Set<String> commands = this.environment.getCommands();
            for (String command : commands) {
                List<CompletionData> completions;
                String name2 = this.environment.commandName(command);
                boolean resolved = command.equals(this.environment.resolveCommand(name2));
                if (name2.startsWith("_")) continue;
                String desc = null;
                Map<String, List<CompletionData>> comp = this.environment.getCompletions();
                if (comp != null && (completions = comp.get(command)) != null) {
                    for (CompletionData completion : completions) {
                        if (completion.description == null || completion.options != null || completion.argument != null || completion.condition != null) continue;
                        desc = completion.description;
                    }
                }
                String key = UUID.randomUUID().toString();
                if (desc != null) {
                    candidates2.add(new Candidate(command, command, null, desc, null, key, true));
                    if (!resolved) continue;
                    candidates2.add(new Candidate(name2, name2, null, desc, null, key, true));
                    continue;
                }
                candidates2.add(new Candidate(command, command, null, null, null, key, true));
                if (!resolved) continue;
                candidates2.add(new Candidate(name2, name2, null, null, null, key, true));
            }
        }

        private boolean isTrue(Object result2) {
            if (result2 == null) {
                return false;
            }
            if (result2 instanceof Boolean) {
                return (Boolean)result2;
            }
            if (result2 instanceof Number && 0 == ((Number)result2).intValue()) {
                return false;
            }
            return !"".equals(result2) && !"0".equals(result2);
        }
    }

    public static class CompletionData {
        public final List<String> options;
        public final String description;
        public final String argument;
        public final String condition;

        public CompletionData(List<String> options, String description2, String argument2, String condition) {
            this.options = options;
            this.description = description2;
            this.argument = argument2;
            this.condition = condition;
        }
    }

    public static interface CompletionEnvironment {
        public Map<String, List<CompletionData>> getCompletions();

        public Set<String> getCommands();

        public String resolveCommand(String var1);

        public String commandName(String var1);

        public Object evaluate(LineReader var1, ParsedLine var2, String var3) throws Exception;
    }
}

