/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.api.KtTypeArgument;
import org.jetbrains.kotlin.analysis.api.components.KtSymbolInfoProvider;
import org.jetbrains.kotlin.analysis.api.diagnostics.KtDiagnosticWithPsi;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.KtSymbolByFirBuilder;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirBackingFieldSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirPackageSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSyntheticJavaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.types.KtSubstitutor;
import org.jetbrains.kotlin.analysis.api.types.KtType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.types.TypeCheckerState;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u0013H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getDeprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "annotationUseSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "getGetterDeprecation", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtPropertySymbol;", "getJavaGetterName", "Lorg/jetbrains/kotlin/name/Name;", "getJavaSetterName", "getSetterDeprecation", "analysis-api-fir"})
public final class KtFirSymbolInfoProvider
extends KtSymbolInfoProvider
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirSymbolInfoProvider(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2) {
        DeprecationInfo deprecationInfo;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (symbol2 instanceof KtFirBackingFieldSymbol || symbol2 instanceof KtFirPackageSymbol) {
            return null;
        }
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object firSymbol = ((KtFirSymbol)symbol2).getFirSymbol();
        if (firSymbol instanceof FirPropertySymbol) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY};
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol, annotationUseSiteTargetArray);
        } else {
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(firSymbol, new AnnotationUseSiteTarget[0]);
        }
        return deprecationInfo;
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2, @Nullable AnnotationUseSiteTarget annotationUseSiteTarget) {
        DeprecationInfo deprecationInfo;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (annotationUseSiteTarget != null) {
            AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{annotationUseSiteTarget};
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)symbol2).getFirSymbol(), annotationUseSiteTargetArray);
        } else {
            deprecationInfo = DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)symbol2).getFirSymbol(), new AnnotationUseSiteTarget[0]);
        }
        return deprecationInfo;
    }

    @Override
    @Nullable
    public DeprecationInfo getGetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.PROPERTY};
        return DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)((Object)symbol2)).getFirSymbol(), annotationUseSiteTargetArray);
    }

    @Override
    @Nullable
    public DeprecationInfo getSetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.PROPERTY};
        return DeprecationUtilsKt.getDeprecationForCallSite(((KtFirSymbol)((Object)symbol2)).getFirSymbol(), annotationUseSiteTargetArray);
    }

    @Override
    @NotNull
    public Name getJavaGetterName(@NotNull KtPropertySymbol symbol2) {
        String jvmName2;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string4 = "Failed requirement.";
            throw new IllegalArgumentException(string4.toString());
        }
        if (symbol2 instanceof KtFirSyntheticJavaPropertySymbol) {
            return ((KtFirSyntheticJavaPropertySymbol)symbol2).getJavaGetterSymbol().getName();
        }
        KtFirSymbolInfoProvider $this$getJavaGetterName_u24lambda_u240 = this;
        boolean bl = false;
        Object e = ((FirBasedSymbol)((KtFirSymbol)((Object)symbol2)).getFirSymbol()).getFir();
        FirProperty firProperty = e instanceof FirProperty ? (FirProperty)e : null;
        if (firProperty == null) {
            string3 = null;
        } else {
            FirProperty firProperty2 = firProperty;
            string3 = FirAnnotationUtilsKt.getJvmNameFromAnnotation(firProperty2, AnnotationUseSiteTarget.PROPERTY_GETTER);
            if (string3 == null) {
                FirPropertyAccessor firPropertyAccessor = firProperty2.getGetter();
                string3 = firPropertyAccessor != null ? FirAnnotationUtilsKt.getJvmNameFromAnnotation$default(firPropertyAccessor, null, 1, null) : null;
            }
        }
        if ((string2 = (jvmName2 = string3)) == null) {
            String string5 = symbol2.getName().getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"symbol.name.identifier");
            string2 = JvmAbi.getterName(string5);
        }
        Name name2 = Name.identifier(string2);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(jvmName ?: Jv\u2026(symbol.name.identifier))");
        return name2;
    }

    @Override
    @Nullable
    public Name getJavaSetterName(@NotNull KtPropertySymbol symbol2) {
        Name name2;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        if (!(symbol2 instanceof KtFirSymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (symbol2 instanceof KtFirSyntheticJavaPropertySymbol) {
            KtFunctionSymbol ktFunctionSymbol = ((KtFirSyntheticJavaPropertySymbol)symbol2).getJavaSetterSymbol();
            return ktFunctionSymbol != null ? ktFunctionSymbol.getName() : null;
        }
        if (symbol2.isVal()) {
            name2 = null;
        } else {
            String jvmName2;
            String string3;
            String string4;
            KtFirSymbolInfoProvider $this$getJavaSetterName_u24lambda_u241 = this;
            boolean bl = false;
            Object e = ((FirBasedSymbol)((KtFirSymbol)((Object)symbol2)).getFirSymbol()).getFir();
            FirProperty firProperty = e instanceof FirProperty ? (FirProperty)e : null;
            if (firProperty == null) {
                string4 = null;
            } else {
                FirProperty firProperty2 = firProperty;
                string4 = FirAnnotationUtilsKt.getJvmNameFromAnnotation(firProperty2, AnnotationUseSiteTarget.PROPERTY_GETTER);
                if (string4 == null) {
                    FirPropertyAccessor firPropertyAccessor = firProperty2.getSetter();
                    string4 = firPropertyAccessor != null ? FirAnnotationUtilsKt.getJvmNameFromAnnotation$default(firPropertyAccessor, null, 1, null) : null;
                }
            }
            if ((string3 = (jvmName2 = string4)) == null) {
                String string5 = symbol2.getName().getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"symbol.name.identifier");
                string3 = JvmAbi.setterName(string5);
            }
            name2 = Name.identifier(string3);
        }
        return name2;
    }

    @Override
    @NotNull
    public FirSession getRootModuleSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getRootModuleSession(this);
    }

    @Override
    @NotNull
    public ConeInferenceContext getTypeContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getTypeContext(this);
    }

    @Override
    @NotNull
    public KtSymbolByFirBuilder getFirSymbolBuilder() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirSymbolBuilder(this);
    }

    @Override
    @NotNull
    public LLFirResolveSession getFirResolveSession() {
        return KtFirAnalysisSessionComponent.DefaultImpls.getFirResolveSession(this);
    }

    @Override
    @NotNull
    public KtType asKtType(@NotNull ConeKotlinType $this$asKtType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtType(this, $this$asKtType);
    }

    @Override
    @NotNull
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull KtPsiDiagnostic $this$asKtDiagnostic) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic);
    }

    @Override
    @Nullable
    public KtDiagnosticWithPsi<?> asKtDiagnostic(@NotNull ConeDiagnostic $this$asKtDiagnostic, @NotNull KtSourceElement source2, @Nullable KtSourceElement qualifiedAccessSource) {
        return KtFirAnalysisSessionComponent.DefaultImpls.asKtDiagnostic(this, $this$asKtDiagnostic, source2, qualifiedAccessSource);
    }

    @Override
    @NotNull
    public ConeKotlinType getConeType(@NotNull KtType $this$coneType) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeType(this, $this$coneType);
    }

    @Override
    @NotNull
    public ConeTypeProjection getConeTypeProjection(@NotNull KtTypeArgument $this$coneTypeProjection) {
        return KtFirAnalysisSessionComponent.DefaultImpls.getConeTypeProjection(this, $this$coneTypeProjection);
    }

    @Override
    @NotNull
    public TypeCheckerState createTypeCheckerContext() {
        return KtFirAnalysisSessionComponent.DefaultImpls.createTypeCheckerContext(this);
    }

    @Override
    @Nullable
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public KtSubstitutor createSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createSubstitutorFromTypeArguments(this, $this$createSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @Nullable
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments);
    }

    @Override
    @NotNull
    public ConeSubstitutor createConeSubstitutorFromTypeArguments(@NotNull FirQualifiedAccess $this$createConeSubstitutorFromTypeArguments, @NotNull FirCallableSymbol<?> callableSymbol) {
        return KtFirAnalysisSessionComponent.DefaultImpls.createConeSubstitutorFromTypeArguments(this, $this$createConeSubstitutorFromTypeArguments, callableSymbol);
    }

    @Override
    @NotNull
    public KtSubstitutor toKtSubstitutor(@NotNull ConeSubstitutor $this$toKtSubstitutor) {
        return KtFirAnalysisSessionComponent.DefaultImpls.toKtSubstitutor(this, $this$toKtSubstitutor);
    }
}

