/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.providers;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.builder.LLFirFileBuilder;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.FirElementFinder;
import org.jetbrains.kotlin.analysis.providers.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.providers.KotlinPackageProvider;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017J \u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000e2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cJ&\u0010!\u001a\u00020\"*\u00020#2\u0010\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R,\u0010\u000b\u001a \u0012\u0004\u0012\u00020\r\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/providers/LLFirProviderHelper;", "", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "firFileBuilder", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/LLFirFileBuilder;", "declarationProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;", "packageProvider", "Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/builder/LLFirFileBuilder;Lorg/jetbrains/kotlin/analysis/providers/KotlinDeclarationProvider;Lorg/jetbrains/kotlin/analysis/providers/KotlinPackageProvider;)V", "callablesByCallableId", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/CallableId;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "", "classifierByClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getFirClassifierByFqName", "classId", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbols", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbols", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "collectCallableDeclarationsTo", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "list", "", "low-level-api-fir"})
public final class LLFirProviderHelper {
    @NotNull
    private final LLFirFileBuilder firFileBuilder;
    @NotNull
    private final KotlinDeclarationProvider declarationProvider;
    @NotNull
    private final KotlinPackageProvider packageProvider;
    @NotNull
    private final FirCache classifierByClassId;
    @NotNull
    private final FirCache callablesByCallableId;

    public LLFirProviderHelper(@NotNull FirSession firSession, @NotNull LLFirFileBuilder firFileBuilder, @NotNull KotlinDeclarationProvider declarationProvider, @NotNull KotlinPackageProvider packageProvider) {
        Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
        Intrinsics.checkNotNullParameter((Object)firFileBuilder, (String)"firFileBuilder");
        Intrinsics.checkNotNullParameter((Object)declarationProvider, (String)"declarationProvider");
        Intrinsics.checkNotNullParameter((Object)packageProvider, (String)"packageProvider");
        this.firFileBuilder = firFileBuilder;
        this.declarationProvider = declarationProvider;
        this.packageProvider = packageProvider;
        FirCachesFactory $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(firSession);
        boolean $i$f$createCache = false;
        this.classifierByClassId = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ LLFirProviderHelper this$0;
            {
                this.this$0 = lLFirProviderHelper;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                FirClassLikeDeclaration firClassLikeDeclaration;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                ClassId classId = (ClassId)key;
                boolean bl = false;
                KtClassLikeDeclaration ktClassLikeDeclaration = LLFirProviderHelper.access$getDeclarationProvider$p(this.this$0).getClassLikeDeclarationByClassId(classId);
                if (ktClassLikeDeclaration == null) {
                    firClassLikeDeclaration = null;
                } else {
                    KtClassLikeDeclaration ktClass = ktClassLikeDeclaration;
                    if (ktClass.getClassId() == null) {
                        firClassLikeDeclaration = null;
                    } else {
                        LLFirFileBuilder lLFirFileBuilder = LLFirProviderHelper.access$getFirFileBuilder$p(this.this$0);
                        KtFile ktFile = ktClass.getContainingKtFile();
                        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktClass.containingKtFile");
                        FirFile firFile = lLFirFileBuilder.buildRawFirFileWithCaching(ktFile);
                        FirElementFinder this_$iv = FirElementFinder.INSTANCE;
                        boolean $i$f$findElementIn = false;
                        Ref.ObjectRef result$iv = new Ref.ObjectRef();
                        ((FirElement)firFile).accept(new FirVisitorVoid(result$iv, classId){
                            final /* synthetic */ Ref.ObjectRef $result;
                            final /* synthetic */ ClassId $classId$inlined;
                            {
                                this.$result = $result;
                                this.$classId$inlined = classId;
                            }

                            public void visitElement(@NotNull FirElement element) {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                if (this.$result.element != null) {
                                    return;
                                }
                                if (!(element instanceof FirClassLikeDeclaration) || element instanceof FirFile) {
                                    element.acceptChildren(this);
                                } else {
                                    FirClassLikeDeclaration it = (FirClassLikeDeclaration)element;
                                    boolean bl = false;
                                    if (Intrinsics.areEqual((Object)it.getSymbol().getClassId(), (Object)this.$classId$inlined)) {
                                        this.$result.element = element;
                                    } else {
                                        it = (FirClassLikeDeclaration)element;
                                        boolean bl2 = false;
                                        if (it instanceof FirRegularClass) {
                                            element.acceptChildren(this);
                                        }
                                    }
                                }
                            }

                            public void visitRegularClass(@NotNull FirRegularClass regularClass) {
                                Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
                                FirResolvePhase oldResolvePhase = regularClass.getResolvePhase();
                                List oldList = CollectionsKt.toList((Iterable)regularClass.getSuperTypeRefs());
                                try {
                                    super.visitRegularClass(regularClass);
                                }
                                catch (ConcurrentModificationException e) {
                                    FirResolvePhase newResolvePhase = regularClass.getResolvePhase();
                                    List newList = CollectionsKt.toList((Iterable)regularClass.getSuperTypeRefs());
                                    throw new IllegalStateException(StringsKt.trimIndent((String)("\n                        CME while traversing superTypeRefs of declaration=" + FirRendererKt.render$default(regularClass, null, 1, null) + ":\n                        classId: " + FirDeclarationUtilKt.getClassId(regularClass) + ",\n                        oldPhase: " + (Object)((Object)oldResolvePhase) + ", oldList: " + CollectionsKt.joinToString$default((Iterable)oldList, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)FirElementFinder.findElementIn.visitRegularClass.1.INSTANCE, (int)24, null) + ",\n                        newPhase: " + (Object)((Object)newResolvePhase) + ", newList: " + CollectionsKt.joinToString$default((Iterable)newList, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)FirElementFinder.findElementIn.visitRegularClass.2.INSTANCE, (int)24, null) + "\n                        ")), e);
                                }
                            }
                        });
                        firClassLikeDeclaration = (FirClassLikeDeclaration)((FirElement)result$iv.element);
                        if (firClassLikeDeclaration == null) {
                            throw new IllegalStateException(("Classifier " + classId + " was found in file " + ktClass.getContainingKtFile().getVirtualFilePath() + " but was not found in FirFile").toString());
                        }
                    }
                }
                return firClassLikeDeclaration;
            }
        });
        $this$createCache$iv = FirCachesFactoryKt.getFirCachesFactory(firSession);
        $i$f$createCache = false;
        this.callablesByCallableId = $this$createCache$iv.createCache((Function2)new Function2(this){
            final /* synthetic */ LLFirProviderHelper this$0;
            {
                this.this$0 = lLFirProviderHelper;
                super(2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(@NotNull Object key, @Nullable Void void_) {
                KtProperty it;
                Collection collection;
                Collection<E> collection2;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                CallableId callableId = (CallableId)key;
                boolean bl = false;
                Set $this$callablesByCallableId_u24lambda_u248_u24lambda_u245 = collection2 = Sets.newIdentityHashSet();
                boolean bl2 = false;
                Iterable $this$mapTo$iv = LLFirProviderHelper.access$getDeclarationProvider$p(this.this$0).getTopLevelFunctions(callableId);
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    KtNamedFunction ktNamedFunction = (KtNamedFunction)item$iv;
                    collection = $this$callablesByCallableId_u24lambda_u248_u24lambda_u245;
                    boolean bl3 = false;
                    collection.add(it.getContainingKtFile());
                }
                Collection cfr_ignored_0 = (Collection)$this$callablesByCallableId_u24lambda_u248_u24lambda_u245;
                $this$mapTo$iv = LLFirProviderHelper.access$getDeclarationProvider$p(this.this$0).getTopLevelProperties(callableId);
                $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    it = (KtProperty)item$iv;
                    collection = $this$callablesByCallableId_u24lambda_u248_u24lambda_u245;
                    boolean bl4 = false;
                    collection.add(it.getContainingKtFile());
                }
                Collection cfr_ignored_1 = (Collection)$this$callablesByCallableId_u24lambda_u248_u24lambda_u245;
                Set files2 = collection2;
                Collection<E> $this$callablesByCallableId_u24lambda_u248_u24lambda_u247 = collection2 = CollectionsKt.createListBuilder();
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)files2, (String)"files");
                Iterable $this$forEach$iv = files2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    KtFile ktFile = (KtFile)element$iv;
                    boolean bl6 = false;
                    LLFirFileBuilder lLFirFileBuilder = LLFirProviderHelper.access$getFirFileBuilder$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktFile");
                    FirFile firFile = lLFirFileBuilder.buildRawFirFileWithCaching(ktFile);
                    LLFirProviderHelper.access$collectCallableDeclarationsTo(this.this$0, firFile, (List)$this$callablesByCallableId_u24lambda_u248_u24lambda_u247, callableId.getCallableName());
                }
                return CollectionsKt.build((List)collection2);
            }
        });
    }

    @Nullable
    public final FirClassLikeDeclaration getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        if (classId.isLocal()) {
            return null;
        }
        FirCache $this$getValue$iv = this.classifierByClassId;
        boolean $i$f$getValue = false;
        return (FirClassLikeDeclaration)$this$getValue$iv.getValue(classId, null);
    }

    @NotNull
    public final List<FirCallableSymbol<?>> getTopLevelCallableSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        CallableId callableId = new CallableId(packageFqName, name2);
        FirCache $this$getValue$iv = this.callablesByCallableId;
        boolean $i$f$getValue = false;
        return (List)$this$getValue$iv.getValue(callableId, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirNamedFunctionSymbol> getTopLevelFunctionSymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$filterIsInstance$iv = this.getTopLevelCallableSymbols(packageFqName, name2);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirNamedFunctionSymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirPropertySymbol> getTopLevelPropertySymbols(@NotNull FqName packageFqName, @NotNull Name name2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Iterable $this$filterIsInstance$iv = this.getTopLevelCallableSymbols(packageFqName, name2);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirPropertySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void collectCallableDeclarationsTo(FirFile $this$collectCallableDeclarationsTo, List<FirCallableSymbol<?>> list2, Name name2) {
        Iterable $this$mapNotNullTo$iv = $this$collectCallableDeclarationsTo.getDeclarations();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            FirCallableSymbol<? extends FirCallableDeclaration> it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            FirDeclaration declaration = (FirDeclaration)element$iv;
            boolean bl2 = false;
            if ((declaration instanceof FirCallableDeclaration && Intrinsics.areEqual((Object)((FirCallableDeclaration)declaration).getSymbol().getCallableId().getCallableName(), (Object)name2) ? ((FirCallableDeclaration)declaration).getSymbol() : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            ((Collection)list2).add(it$iv);
        }
    }

    @Nullable
    public final FqName getPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FqName fqName3 = fqName2;
        KotlinPackageProvider kotlinPackageProvider = this.packageProvider;
        FqName p0 = fqName3;
        boolean bl = false;
        return kotlinPackageProvider.doKotlinPackageExists(p0) ? fqName3 : null;
    }

    public static final /* synthetic */ KotlinDeclarationProvider access$getDeclarationProvider$p(LLFirProviderHelper $this) {
        return $this.declarationProvider;
    }

    public static final /* synthetic */ LLFirFileBuilder access$getFirFileBuilder$p(LLFirProviderHelper $this) {
        return $this.firFileBuilder;
    }

    public static final /* synthetic */ void access$collectCallableDeclarationsTo(LLFirProviderHelper $this, FirFile $receiver, List list2, Name name2) {
        $this.collectCallableDeclarationsTo($receiver, list2, name2);
    }
}

