/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.utils.printer.PsiUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\t\u0010\r\u001a\u00020\u000eH\u0080\b\u001a'\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u000e\b\u0004\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u001a\f\u0010\u0014\u001a\u00020\u0006*\u00020\nH\u0000\u001a1\u0010\u0015\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u0010*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"containingKtFileIfAny", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getContainingKtFileIfAny", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtFile;", "isErrorElement", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "(Lorg/jetbrains/kotlin/fir/FirElement;)Z", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getKtDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "checkCanceled", "", "executeWithoutPCE", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "isNonAnonymousClassOrObject", "lockWithPCECheck", "Ljava/util/concurrent/locks/Lock;", "lockingIntervalMs", "", "(Ljava/util/concurrent/locks/Lock;JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "low-level-api-fir"})
public final class UtilsKt {
    public static final <T> T executeWithoutPCE(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$executeWithoutPCE = false;
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        ProgressManager.getInstance().executeNonCancelableSection(new Runnable(result2, action){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function0<T> $action;
            {
                this.$result = $result;
                this.$action = $action;
            }

            public final void run() {
                this.$result.element = this.$action.invoke();
            }
        });
        return (T)result2.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T lockWithPCECheck(@NotNull Lock $this$lockWithPCECheck, long lockingIntervalMs, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)$this$lockWithPCECheck, (String)"<this>");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean $i$f$lockWithPCECheck = false;
        boolean needToRun = true;
        Object result2 = null;
        while (needToRun) {
            boolean $i$f$checkCanceled = false;
            ProgressManager.checkCanceled();
            if (!$this$lockWithPCECheck.tryLock(lockingIntervalMs, TimeUnit.MILLISECONDS)) continue;
            try {
                needToRun = false;
                result2 = action.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                $this$lockWithPCECheck.unlock();
                InlineMarker.finallyEnd((int)1);
            }
        }
        Object object = result2;
        Intrinsics.checkNotNull(object);
        return (T)object;
    }

    public static final void checkCanceled() {
        boolean $i$f$checkCanceled = false;
        ProgressManager.checkCanceled();
    }

    public static final boolean isErrorElement(@NotNull FirElement $this$isErrorElement) {
        Intrinsics.checkNotNullParameter((Object)$this$isErrorElement, (String)"<this>");
        return $this$isErrorElement instanceof FirDiagnosticHolder;
    }

    @NotNull
    public static final KtDeclaration getKtDeclaration(@NotNull FirDeclaration $this$ktDeclaration) {
        KtDeclaration ktDeclaration;
        Intrinsics.checkNotNullParameter((Object)$this$ktDeclaration, (String)"<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$ktDeclaration);
        if (psiElement == null) {
            throw new IllegalStateException(("PSI element was not found for" + FirRendererKt.render$default($this$ktDeclaration, null, 1, null)).toString());
        }
        PsiElement psi2 = psiElement;
        PsiElement psiElement2 = psi2;
        if (psiElement2 instanceof KtDeclaration) {
            ktDeclaration = (KtDeclaration)psi2;
        } else if (psiElement2 instanceof KtObjectLiteralExpression) {
            KtObjectDeclaration ktObjectDeclaration = ((KtObjectLiteralExpression)psi2).getObjectDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"psi.objectDeclaration");
            ktDeclaration = ktObjectDeclaration;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append("\n                   FirDeclaration.psi (").append(Reflection.getOrCreateKotlinClass($this$ktDeclaration.getClass()).getSimpleName()).append(") should be KtDeclaration but was ").append(Reflection.getOrCreateKotlinClass(psi2.getClass()).getSimpleName()).append("\n                   ");
            Object object = psi2 instanceof KtElement ? (KtElement)psi2 : null;
            if (object == null || (object = PsiUtilsKt.getElementTextInContext((KtElement)object)) == null) {
                object = psi2.getText();
            }
            String string2 = StringsKt.trimIndent((String)stringBuilder2.append((String)object).append("\n                   \n                   ").append(FirRendererKt.render$default($this$ktDeclaration, null, 1, null)).append("\n                   ").toString());
            throw new IllegalStateException(string2.toString());
        }
        return ktDeclaration;
    }

    @Nullable
    public static final KtFile getContainingKtFileIfAny(@NotNull FirDeclaration $this$containingKtFileIfAny) {
        Intrinsics.checkNotNullParameter((Object)$this$containingKtFileIfAny, (String)"<this>");
        PsiElement psiElement = org.jetbrains.kotlin.fir.UtilsKt.getPsi($this$containingKtFileIfAny);
        PsiFile psiFile = psiElement != null ? psiElement.getContainingFile() : null;
        return psiFile instanceof KtFile ? (KtFile)psiFile : null;
    }

    public static final boolean isNonAnonymousClassOrObject(@NotNull KtDeclaration $this$isNonAnonymousClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonAnonymousClassOrObject, (String)"<this>");
        return $this$isNonAnonymousClassOrObject instanceof KtClassOrObject && !KtPsiUtilKt.isObjectLiteral((KtClassOrObject)$this$isNonAnonymousClassOrObject);
    }
}

