/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.kotlin.preloading.instrumentation.InterceptionInstrumenterAdaptor;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.ClassName;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.MethodDesc;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.MethodInterceptor;
import org.jetbrains.kotlin.preloading.instrumentation.annotations.MethodName;

public class ProfilingInstrumenterExample
extends InterceptionInstrumenterAdaptor {
    @MethodInterceptor(className=".*Visitor.*", methodName="visit.*", methodDesc=".*", allowMultipleMatches=true)
    public static final Object a = new InvocationCount();
    @MethodInterceptor(className="org/.*", methodName="equals", methodDesc="\\(Ljava/lang/Object;\\)Z", logInterceptions=true)
    public static final Object b = new TotalTime();
    @MethodInterceptor(className="com/intellij/openapi/util/text/StringUtil", methodName="capitalize", methodDesc="\\(Ljava/lang/String;\\).*", dumpByteCode=true)
    public static Object c = new CollectFirstArguments();
    @MethodInterceptor(className=".*", methodName=".*", methodDesc="\\(.*JL.*?\\).*", allowMultipleMatches=true)
    public static Object d = new MethodCollector();
    @MethodInterceptor(className=".*", methodName=".*", methodDesc="\\(.+\\).*", allowMultipleMatches=true)
    public static Object e = new FirstArgumentCollector(){

        @Override
        protected boolean accept(Object arg) {
            return arg instanceof Integer;
        }
    };

    public static abstract class FirstArgumentCollector {
        private final Collection<Object> collected = new HashSet<Object>();

        protected abstract boolean accept(Object var1);

        public void enter(Object arg) {
            if (this.accept(arg)) {
                this.collected.add(arg);
            }
        }

        public void dump(PrintStream out) {
            out.println("Arguments: " + this.collected.size());
        }
    }

    public static class MethodCollector {
        private final Collection<String> collected = new LinkedHashSet<String>();

        public void enter(@ClassName String className2, @MethodName String name2, @MethodDesc String desc) {
            this.collected.add(className2 + "." + name2 + desc);
        }

        public void dump(PrintStream out) {
            for (String s : this.collected) {
                out.println(s);
            }
        }
    }

    public static class CollectFirstArguments {
        private final List<Object> arguments = new ArrayList<Object>(30000);

        public void enter(Object arg) {
            this.arguments.add(arg);
        }

        public void dump(PrintStream out) {
            out.println("Different values: " + new HashSet<Object>(this.arguments).size());
        }
    }

    public static class TotalTime {
        private long time = 0L;
        private long start = 0L;
        private boolean started = false;

        public void enter() {
            if (!this.started) {
                this.start = System.nanoTime();
                this.started = true;
            }
        }

        public void exit() {
            if (this.started) {
                this.time += System.nanoTime() - this.start;
                this.started = false;
            }
        }

        public void dump(PrintStream out) {
            out.printf("Total time: %.3fs\n", (double)this.time / 1.0E9);
        }
    }

    public static class InvocationCount {
        private int count = 0;

        public void enter() {
            ++this.count;
        }

        public void dump(PrintStream out) {
            out.println("Invocation count: " + this.count);
        }
    }
}

