/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin;

import com.intellij.core.CoreFileTypeRegistry;
import com.intellij.mock.MockProject;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.extensions.CompilerConfigurationExtension;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.scripting.compiler.plugin.ConfigurationKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.definitions.CliScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.compiler.plugin.impl.ErrorReportingKt;
import org.jetbrains.kotlin.scripting.configuration.ScriptingConfigurationKeys;
import org.jetbrains.kotlin.scripting.definitions.AutoloadedScriptDefinitions;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsFromClasspathDiscoverySource;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/ScriptingCompilerConfigurationExtension;", "Lorg/jetbrains/kotlin/extensions/CompilerConfigurationExtension;", "project", "Lcom/intellij/mock/MockProject;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "(Lcom/intellij/mock/MockProject;Lkotlin/script/experimental/host/ScriptingHostConfiguration;)V", "getBaseHostConfiguration", "()Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "getProject", "()Lcom/intellij/mock/MockProject;", "updateConfiguration", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "updateFileRegistry", "kotlin-scripting-compiler"})
public final class ScriptingCompilerConfigurationExtension
implements CompilerConfigurationExtension {
    @NotNull
    private final MockProject project;
    @NotNull
    private final ScriptingHostConfiguration baseHostConfiguration;

    public ScriptingCompilerConfigurationExtension(@NotNull MockProject project, @NotNull ScriptingHostConfiguration baseHostConfiguration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        this.project = project;
        this.baseHostConfiguration = baseHostConfiguration;
    }

    @NotNull
    public final MockProject getProject() {
        return this.project;
    }

    @NotNull
    public final ScriptingHostConfiguration getBaseHostConfiguration() {
        return this.baseHostConfiguration;
    }

    @Override
    public void updateConfiguration(@NotNull CompilerConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        if (!configuration2.getBoolean(ScriptingConfigurationKeys.INSTANCE.getDISABLE_SCRIPTING_PLUGIN_OPTION())) {
            CliScriptDefinitionProvider scriptDefinitionProvider;
            AutoloadedScriptDefinitions autoloadedScriptDefinitions;
            ScriptDefinitionsFromClasspathDiscoverySource definitionsFromClasspath;
            File projectRoot;
            File file2;
            MessageCollector messageCollector2 = configuration2.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            if (messageCollector2 == null) {
                messageCollector2 = MessageCollector.Companion.getNONE();
            }
            Intrinsics.checkNotNullExpressionValue((Object)messageCollector2, (String)"configuration.get(CLICon\u2026 ?: MessageCollector.NONE");
            MessageCollector messageCollector3 = messageCollector2;
            MockProject $this$updateConfiguration_u24lambda_u240 = this.project;
            boolean bl = false;
            String string2 = $this$updateConfiguration_u24lambda_u240.getBasePath();
            if (string2 == null) {
                VirtualFile virtualFile = $this$updateConfiguration_u24lambda_u240.getBaseDir();
                string2 = virtualFile != null ? virtualFile.getCanonicalPath() : null;
            }
            if (string2 != null) {
                String p0 = string2;
                boolean bl2 = false;
                file2 = new File(p0);
            } else {
                file2 = projectRoot = null;
            }
            if (projectRoot != null) {
                configuration2.put(ScriptingConfigurationKeys.INSTANCE.getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION(), "projectRoot", projectRoot);
            }
            ScriptingHostConfiguration[] scriptingHostConfigurationArray = new ScriptingHostConfiguration[]{this.baseHostConfiguration};
            ScriptingHostConfiguration hostConfiguration2 = new ScriptingHostConfiguration(scriptingHostConfigurationArray, (Function1<? super ScriptingHostConfiguration.Builder, Unit>)((Function1)new Function1<ScriptingHostConfiguration.Builder, Unit>(configuration2){
                final /* synthetic */ CompilerConfiguration $configuration;
                {
                    this.$configuration = $configuration;
                    super(1);
                }

                public final void invoke(@NotNull ScriptingHostConfiguration.Builder $this$$receiver) {
                    Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                    $this$$receiver.invoke(ScriptCompilationConfigurationFromDefinitionKt.getGetEnvironment($this$$receiver), new Function0<Map<String, Object>>(this.$configuration){
                        final /* synthetic */ CompilerConfiguration $configuration;
                        {
                            this.$configuration = $configuration;
                            super(0);
                        }

                        @NotNull
                        public final Map<String, Object> invoke() {
                            return this.$configuration.getMap(ScriptingConfigurationKeys.INSTANCE.getLEGACY_SCRIPT_RESOLVER_ENVIRONMENT_OPTION());
                        }
                    });
                }
            }));
            List<String> list2 = configuration2.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS_CLASSES());
            Intrinsics.checkNotNullExpressionValue(list2, (String)"configuration.getList(Sc\u2026RIPT_DEFINITIONS_CLASSES)");
            List<String> explicitScriptDefinitions = list2;
            if (!((Collection)explicitScriptDefinitions).isEmpty()) {
                ClassLoader classLoader2 = this.getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"this::class.java.classLoader");
                ConfigurationKt.configureScriptDefinitions(explicitScriptDefinitions, configuration2, classLoader2, messageCollector3, hostConfiguration2);
            }
            if (!configuration2.getBoolean(JVMConfigurationKeys.DISABLE_STANDARD_SCRIPT_DEFINITION)) {
                boolean bl3;
                block15: {
                    List list3 = configuration2.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS());
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"configuration.getList(Sc\u2026nKeys.SCRIPT_DEFINITIONS)");
                    Iterable $this$none$iv = list3;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            ScriptDefinition it = (ScriptDefinition)((Object)element$iv);
                            boolean bl4 = false;
                            if (!it.isDefault()) continue;
                            bl3 = false;
                            break block15;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    configuration2.add(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS(), ScriptDefinition.Companion.getDefault(hostConfiguration2));
                }
            }
            ScriptDefinitionsFromClasspathDiscoverySource scriptDefinitionsFromClasspathDiscoverySource = definitionsFromClasspath = configuration2.getBoolean(ScriptingConfigurationKeys.INSTANCE.getDISABLE_SCRIPT_DEFINITIONS_FROM_CLASSPATH_OPTION()) ? null : new ScriptDefinitionsFromClasspathDiscoverySource(JvmContentRootsKt.getJvmClasspathRoots(configuration2), hostConfiguration2, ErrorReportingKt.getReporter(messageCollector3));
            if (configuration2.getBoolean(ScriptingConfigurationKeys.INSTANCE.getDISABLE_SCRIPT_DEFINITIONS_AUTOLOADING_OPTION())) {
                autoloadedScriptDefinitions = null;
            } else {
                ClassLoader classLoader3 = this.getClass().getClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader3, (String)"this::class.java.classLoader");
                autoloadedScriptDefinitions = new AutoloadedScriptDefinitions(hostConfiguration2, classLoader3, ErrorReportingKt.getReporter(messageCollector3));
            }
            AutoloadedScriptDefinitions autoloadedScriptDefinitions2 = autoloadedScriptDefinitions;
            Object[] objectArray = new ScriptDefinitionsSource[]{definitionsFromClasspath, autoloadedScriptDefinitions2};
            configuration2.addAll(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS_SOURCES(), CollectionsKt.listOfNotNull((Object[])objectArray));
            ScriptDefinitionProvider scriptDefinitionProvider2 = ScriptDefinitionProvider.Companion.getInstance((Project)this.project);
            CliScriptDefinitionProvider cliScriptDefinitionProvider = scriptDefinitionProvider = scriptDefinitionProvider2 instanceof CliScriptDefinitionProvider ? (CliScriptDefinitionProvider)scriptDefinitionProvider2 : null;
            if (scriptDefinitionProvider != null) {
                List list4 = configuration2.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS_SOURCES());
                Intrinsics.checkNotNullExpressionValue(list4, (String)"configuration.getList(Sc\u2026RIPT_DEFINITIONS_SOURCES)");
                scriptDefinitionProvider.setScriptDefinitionsSources(list4);
                List list5 = configuration2.getList(ScriptingConfigurationKeys.INSTANCE.getSCRIPT_DEFINITIONS());
                Intrinsics.checkNotNullExpressionValue(list5, (String)"configuration.getList(Sc\u2026nKeys.SCRIPT_DEFINITIONS)");
                scriptDefinitionProvider.setScriptDefinitions(list5);
            }
        }
    }

    @Override
    public void updateFileRegistry() {
        CliScriptDefinitionProvider scriptDefinitionProvider;
        ScriptDefinitionProvider scriptDefinitionProvider2 = ScriptDefinitionProvider.Companion.getInstance((Project)this.project);
        CliScriptDefinitionProvider cliScriptDefinitionProvider = scriptDefinitionProvider = scriptDefinitionProvider2 instanceof CliScriptDefinitionProvider ? (CliScriptDefinitionProvider)scriptDefinitionProvider2 : null;
        if (scriptDefinitionProvider != null) {
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            Intrinsics.checkNotNull((Object)fileTypeRegistry, (String)"null cannot be cast to non-null type com.intellij.core.CoreFileTypeRegistry");
            CoreFileTypeRegistry fileTypeRegistry2 = (CoreFileTypeRegistry)fileTypeRegistry;
            Sequence $this$forEach$iv = SequencesKt.filter(scriptDefinitionProvider.getKnownFilenameExtensions(), (Function1)((Function1)new Function1<String, Boolean>(fileTypeRegistry2){
                final /* synthetic */ CoreFileTypeRegistry $fileTypeRegistry;
                {
                    this.$fileTypeRegistry = $fileTypeRegistry;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)this.$fileTypeRegistry.getFileTypeByExtension(it), (Object)((Object)KotlinFileType.INSTANCE));
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                fileTypeRegistry2.registerFileType((FileType)KotlinFileType.INSTANCE, it);
            }
        }
    }
}

