/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jline.builtins.Source;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;

public class Less {
    private static final int ESCAPE = 27;
    public boolean quitAtSecondEof;
    public boolean quitAtFirstEof;
    public boolean quitIfOneScreen;
    public boolean printLineNumbers;
    public boolean quiet;
    public boolean veryQuiet;
    public boolean chopLongLines;
    public boolean ignoreCaseCond;
    public boolean ignoreCaseAlways;
    public boolean noKeypad;
    public boolean noInit;
    public int tabs = 4;
    protected final Terminal terminal;
    protected final Display display;
    protected final BindingReader bindingReader;
    protected List<Source> sources;
    protected int sourceIdx;
    protected BufferedReader reader;
    protected KeyMap<Operation> keys;
    protected int firstLineInMemory = 0;
    protected List<AttributedString> lines = new ArrayList<AttributedString>();
    protected int firstLineToDisplay = 0;
    protected int firstColumnToDisplay = 0;
    protected int offsetInLine = 0;
    protected String message;
    protected final StringBuilder buffer = new StringBuilder();
    protected final Map<String, Operation> options = new TreeMap<String, Operation>();
    protected int window;
    protected int halfWindow;
    protected int nbEof;
    protected String pattern;
    protected final Size size = new Size();

    public Less(Terminal terminal) {
        this.terminal = terminal;
        this.display = new Display(terminal, true);
        this.bindingReader = new BindingReader(terminal.reader());
    }

    public void handle(Terminal.Signal signal) {
        this.size.copy(this.terminal.getSize());
        try {
            this.display.clear();
            this.display(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run(Source ... sources) throws IOException, InterruptedException {
        this.run(Arrays.asList(sources));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(List<Source> sources) throws IOException, InterruptedException {
        block76: {
            if (sources == null || sources.isEmpty()) {
                throw new IllegalArgumentException("No sources");
            }
            this.sources = sources;
            this.sourceIdx = 0;
            this.openSource();
            try {
                block75: {
                    this.size.copy(this.terminal.getSize());
                    if (this.quitIfOneScreen && sources.size() == 1 && this.display(true)) {
                        return;
                    }
                    Terminal.SignalHandler prevHandler = this.terminal.handle(Terminal.Signal.WINCH, this::handle);
                    Attributes attr = this.terminal.enterRawMode();
                    try {
                        Operation op;
                        this.window = this.size.getRows() - 1;
                        this.halfWindow = this.window / 2;
                        this.keys = new KeyMap();
                        this.bindKeys(this.keys);
                        if (!this.noInit) {
                            this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
                        }
                        if (!this.noKeypad) {
                            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
                        }
                        this.terminal.writer().flush();
                        this.display(false);
                        Less.checkInterrupted();
                        this.options.put("-e", Operation.OPT_QUIT_AT_SECOND_EOF);
                        this.options.put("--quit-at-eof", Operation.OPT_QUIT_AT_SECOND_EOF);
                        this.options.put("-E", Operation.OPT_QUIT_AT_FIRST_EOF);
                        this.options.put("-QUIT-AT-EOF", Operation.OPT_QUIT_AT_FIRST_EOF);
                        this.options.put("-N", Operation.OPT_PRINT_LINES);
                        this.options.put("--LINE-NUMBERS", Operation.OPT_PRINT_LINES);
                        this.options.put("-q", Operation.OPT_QUIET);
                        this.options.put("--quiet", Operation.OPT_QUIET);
                        this.options.put("--silent", Operation.OPT_QUIET);
                        this.options.put("-Q", Operation.OPT_VERY_QUIET);
                        this.options.put("--QUIET", Operation.OPT_VERY_QUIET);
                        this.options.put("--SILENT", Operation.OPT_VERY_QUIET);
                        this.options.put("-S", Operation.OPT_CHOP_LONG_LINES);
                        this.options.put("--chop-long-lines", Operation.OPT_CHOP_LONG_LINES);
                        this.options.put("-i", Operation.OPT_IGNORE_CASE_COND);
                        this.options.put("--ignore-case", Operation.OPT_IGNORE_CASE_COND);
                        this.options.put("-I", Operation.OPT_IGNORE_CASE_ALWAYS);
                        this.options.put("--IGNORE-CASE", Operation.OPT_IGNORE_CASE_ALWAYS);
                        do {
                            Less.checkInterrupted();
                            op = null;
                            if (this.buffer.length() > 0 && this.buffer.charAt(0) == '-') {
                                int c = this.terminal.reader().read();
                                this.message = null;
                                if (this.buffer.length() == 1) {
                                    this.buffer.append((char)c);
                                    if (c != 45 && (op = this.options.get(this.buffer.toString())) == null) {
                                        this.message = "There is no " + this.printable(this.buffer.toString()) + " option";
                                        this.buffer.setLength(0);
                                    }
                                } else if (c == 13) {
                                    op = this.options.get(this.buffer.toString());
                                    if (op == null) {
                                        this.message = "There is no " + this.printable(this.buffer.toString()) + " option";
                                        this.buffer.setLength(0);
                                    }
                                } else {
                                    this.buffer.append((char)c);
                                    HashMap<String, Operation> matching = new HashMap<String, Operation>();
                                    for (Map.Entry<String, Operation> entry : this.options.entrySet()) {
                                        if (!entry.getKey().startsWith(this.buffer.toString())) continue;
                                        matching.put(entry.getKey(), entry.getValue());
                                    }
                                    switch (matching.size()) {
                                        case 0: {
                                            this.buffer.setLength(0);
                                            break;
                                        }
                                        case 1: {
                                            this.buffer.setLength(0);
                                            this.buffer.append((String)matching.keySet().iterator().next());
                                        }
                                    }
                                }
                            } else if (this.buffer.length() > 0 && (this.buffer.charAt(0) == '/' || this.buffer.charAt(0) == '?')) {
                                int c = this.terminal.reader().read();
                                this.message = null;
                                if (c == 13) {
                                    this.pattern = this.buffer.toString().substring(1);
                                    if (this.buffer.charAt(0) == '/') {
                                        this.moveToNextMatch();
                                    } else {
                                        this.moveToPreviousMatch();
                                    }
                                    this.buffer.setLength(0);
                                } else {
                                    this.buffer.append((char)c);
                                }
                            } else {
                                Operation obj = this.bindingReader.readBinding(this.keys, null, false);
                                if (obj == Operation.CHAR) {
                                    char c = this.bindingReader.getLastBinding().charAt(0);
                                    if (c == '-' || c == '/' || c == '?') {
                                        this.buffer.setLength(0);
                                    }
                                    this.buffer.append(c);
                                } else {
                                    op = obj;
                                }
                            }
                            if (op != null) {
                                this.message = null;
                                switch (op) {
                                    case FORWARD_ONE_LINE: {
                                        this.moveForward(this.getStrictPositiveNumberInBuffer(1));
                                        break;
                                    }
                                    case BACKWARD_ONE_LINE: {
                                        this.moveBackward(this.getStrictPositiveNumberInBuffer(1));
                                        break;
                                    }
                                    case FORWARD_ONE_WINDOW_OR_LINES: {
                                        this.moveForward(this.getStrictPositiveNumberInBuffer(this.window));
                                        break;
                                    }
                                    case FORWARD_ONE_WINDOW_AND_SET: {
                                        this.window = this.getStrictPositiveNumberInBuffer(this.window);
                                        this.moveForward(this.window);
                                        break;
                                    }
                                    case FORWARD_ONE_WINDOW_NO_STOP: {
                                        this.moveForward(this.window);
                                        break;
                                    }
                                    case FORWARD_HALF_WINDOW_AND_SET: {
                                        this.halfWindow = this.getStrictPositiveNumberInBuffer(this.halfWindow);
                                        this.moveForward(this.halfWindow);
                                        break;
                                    }
                                    case BACKWARD_ONE_WINDOW_AND_SET: {
                                        this.window = this.getStrictPositiveNumberInBuffer(this.window);
                                        this.moveBackward(this.window);
                                        break;
                                    }
                                    case BACKWARD_ONE_WINDOW_OR_LINES: {
                                        this.moveBackward(this.getStrictPositiveNumberInBuffer(this.window));
                                        break;
                                    }
                                    case BACKWARD_HALF_WINDOW_AND_SET: {
                                        this.halfWindow = this.getStrictPositiveNumberInBuffer(this.halfWindow);
                                        this.moveBackward(this.halfWindow);
                                        break;
                                    }
                                    case GO_TO_FIRST_LINE_OR_N: {
                                        this.firstLineToDisplay = this.firstLineInMemory;
                                        this.offsetInLine = 0;
                                        break;
                                    }
                                    case GO_TO_LAST_LINE_OR_N: {
                                        this.moveForward(Integer.MAX_VALUE);
                                        break;
                                    }
                                    case LEFT_ONE_HALF_SCREEN: {
                                        this.firstColumnToDisplay = Math.max(0, this.firstColumnToDisplay - this.size.getColumns() / 2);
                                        break;
                                    }
                                    case RIGHT_ONE_HALF_SCREEN: {
                                        this.firstColumnToDisplay += this.size.getColumns() / 2;
                                        break;
                                    }
                                    case REPEAT_SEARCH_BACKWARD: 
                                    case REPEAT_SEARCH_BACKWARD_SPAN_FILES: {
                                        this.moveToPreviousMatch();
                                        break;
                                    }
                                    case REPEAT_SEARCH_FORWARD: 
                                    case REPEAT_SEARCH_FORWARD_SPAN_FILES: {
                                        this.moveToNextMatch();
                                        break;
                                    }
                                    case UNDO_SEARCH: {
                                        this.pattern = null;
                                        break;
                                    }
                                    case OPT_PRINT_LINES: {
                                        this.buffer.setLength(0);
                                        this.printLineNumbers = !this.printLineNumbers;
                                        this.message = this.printLineNumbers ? "Constantly display line numbers" : "Don't use line numbers";
                                        break;
                                    }
                                    case OPT_QUIET: {
                                        this.buffer.setLength(0);
                                        this.quiet = !this.quiet;
                                        this.veryQuiet = false;
                                        this.message = this.quiet ? "Ring the bell for errors but not at eof/bof" : "Ring the bell for errors AND at eof/bof";
                                        break;
                                    }
                                    case OPT_VERY_QUIET: {
                                        this.buffer.setLength(0);
                                        this.veryQuiet = !this.veryQuiet;
                                        this.quiet = false;
                                        this.message = this.veryQuiet ? "Never ring the bell" : "Ring the bell for errors AND at eof/bof";
                                        break;
                                    }
                                    case OPT_CHOP_LONG_LINES: {
                                        this.buffer.setLength(0);
                                        this.offsetInLine = 0;
                                        this.chopLongLines = !this.chopLongLines;
                                        this.message = this.chopLongLines ? "Chop long lines" : "Fold long lines";
                                        break;
                                    }
                                    case OPT_IGNORE_CASE_COND: {
                                        this.ignoreCaseCond = !this.ignoreCaseCond;
                                        this.ignoreCaseAlways = false;
                                        this.message = this.ignoreCaseCond ? "Ignore case in searches" : "Case is significant in searches";
                                        break;
                                    }
                                    case OPT_IGNORE_CASE_ALWAYS: {
                                        this.ignoreCaseAlways = !this.ignoreCaseAlways;
                                        this.ignoreCaseCond = false;
                                        this.message = this.ignoreCaseAlways ? "Ignore case in searches and in patterns" : "Case is significant in searches";
                                        break;
                                    }
                                    case NEXT_FILE: {
                                        if (this.sourceIdx < sources.size() - 1) {
                                            ++this.sourceIdx;
                                            this.openSource();
                                            break;
                                        }
                                        this.message = "No next file";
                                        break;
                                    }
                                    case PREV_FILE: {
                                        if (this.sourceIdx > 0) {
                                            --this.sourceIdx;
                                            this.openSource();
                                            break;
                                        }
                                        this.message = "No previous file";
                                    }
                                }
                                this.buffer.setLength(0);
                            }
                            if (this.quitAtFirstEof && this.nbEof > 0 || this.quitAtSecondEof && this.nbEof > 1) {
                                if (this.sourceIdx < sources.size() - 1) {
                                    ++this.sourceIdx;
                                    this.openSource();
                                } else {
                                    op = Operation.EXIT;
                                }
                            }
                            this.display(false);
                        } while (op != Operation.EXIT);
                        this.terminal.setAttributes(attr);
                        if (prevHandler == null) break block75;
                        this.terminal.handle(Terminal.Signal.WINCH, prevHandler);
                    }
                    catch (InterruptedException interruptedException) {
                        this.terminal.setAttributes(attr);
                        if (prevHandler != null) {
                            this.terminal.handle(Terminal.Signal.WINCH, prevHandler);
                        }
                        if (!this.noInit) {
                            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                        }
                        if (!this.noKeypad) {
                            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                        }
                        this.terminal.writer().flush();
                        break block76;
                        catch (Throwable throwable) {
                            this.terminal.setAttributes(attr);
                            if (prevHandler != null) {
                                this.terminal.handle(Terminal.Signal.WINCH, prevHandler);
                            }
                            if (!this.noInit) {
                                this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                            }
                            if (!this.noKeypad) {
                                this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                            }
                            this.terminal.writer().flush();
                            throw throwable;
                        }
                    }
                }
                if (!this.noInit) {
                    this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                }
                if (!this.noKeypad) {
                    this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                }
                this.terminal.writer().flush();
            }
            finally {
                this.reader.close();
            }
        }
    }

    protected void openSource() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        Source source = this.sources.get(this.sourceIdx);
        InputStream in = source.read();
        this.message = this.sources.size() == 1 ? source.getName() : source.getName() + " (file " + (this.sourceIdx + 1) + " of " + this.sources.size() + ")";
        this.reader = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(in)));
        this.firstLineInMemory = 0;
        this.lines = new ArrayList<AttributedString>();
        this.firstLineToDisplay = 0;
        this.firstColumnToDisplay = 0;
        this.offsetInLine = 0;
    }

    private void moveToNextMatch() throws IOException {
        Pattern compiled = this.getPattern();
        if (compiled != null) {
            AttributedString line;
            int lineNumber = this.firstLineToDisplay + 1;
            while ((line = this.getLine(lineNumber)) != null) {
                if (compiled.matcher(line).find()) {
                    this.firstLineToDisplay = lineNumber;
                    this.offsetInLine = 0;
                    return;
                }
                ++lineNumber;
            }
        }
        this.message = "Pattern not found";
    }

    private void moveToPreviousMatch() throws IOException {
        Pattern compiled = this.getPattern();
        if (compiled != null) {
            AttributedString line;
            for (int lineNumber = this.firstLineToDisplay - 1; lineNumber >= this.firstLineInMemory && (line = this.getLine(lineNumber)) != null; --lineNumber) {
                if (!compiled.matcher(line).find()) continue;
                this.firstLineToDisplay = lineNumber;
                this.offsetInLine = 0;
                return;
            }
        }
        this.message = "Pattern not found";
    }

    private String printable(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if (c == '\u001b') {
                sb.append("ESC");
                continue;
            }
            if (c < ' ') {
                sb.append('^').append((char)(c + 64));
                continue;
            }
            if (c < '\u0080') {
                sb.append(c);
                continue;
            }
            sb.append('\\').append(String.format("%03o", c));
        }
        return sb.toString();
    }

    void moveForward(int lines) throws IOException {
        int width = this.size.getColumns() - (this.printLineNumbers ? 8 : 0);
        int height = this.size.getRows();
        while (--lines >= 0) {
            int lastLineToDisplay = this.firstLineToDisplay;
            if (this.firstColumnToDisplay > 0 || this.chopLongLines) {
                lastLineToDisplay += height - 1;
            } else {
                AttributedString line;
                int off = this.offsetInLine;
                for (int l = 0; l < height - 1 && (line = this.getLine(lastLineToDisplay)) != null; ++l) {
                    if (line.columnLength() > off + width) {
                        off += width;
                        continue;
                    }
                    off = 0;
                    ++lastLineToDisplay;
                }
            }
            if (this.getLine(lastLineToDisplay) == null) {
                this.eof();
                return;
            }
            AttributedString line = this.getLine(this.firstLineToDisplay);
            if (line.columnLength() > width + this.offsetInLine) {
                this.offsetInLine += width;
                continue;
            }
            this.offsetInLine = 0;
            ++this.firstLineToDisplay;
        }
    }

    void moveBackward(int lines) throws IOException {
        int width = this.size.getColumns() - (this.printLineNumbers ? 8 : 0);
        while (--lines >= 0) {
            if (this.offsetInLine > 0) {
                this.offsetInLine = Math.max(0, this.offsetInLine - width);
                continue;
            }
            if (this.firstLineInMemory < this.firstLineToDisplay) {
                --this.firstLineToDisplay;
                AttributedString line = this.getLine(this.firstLineToDisplay);
                int length = line.columnLength();
                this.offsetInLine = length - length % width;
                continue;
            }
            this.bof();
            return;
        }
    }

    private void eof() {
        ++this.nbEof;
        this.message = this.sourceIdx < this.sources.size() - 1 ? "(END) - Next: " + this.sources.get(this.sourceIdx + 1).getName() : "(END)";
        if (!(this.quiet || this.veryQuiet || this.quitAtFirstEof || this.quitAtSecondEof)) {
            this.terminal.puts(InfoCmp.Capability.bell, new Object[0]);
            this.terminal.writer().flush();
        }
    }

    private void bof() {
        if (!this.quiet && !this.veryQuiet) {
            this.terminal.puts(InfoCmp.Capability.bell, new Object[0]);
            this.terminal.writer().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getStrictPositiveNumberInBuffer(int def) {
        try {
            int n = Integer.parseInt(this.buffer.toString());
            int n2 = n > 0 ? n : def;
            return n2;
        }
        catch (NumberFormatException e) {
            int n = def;
            return n;
        }
        finally {
            this.buffer.setLength(0);
        }
    }

    boolean display(boolean oneScreen) throws IOException {
        ArrayList<AttributedString> newLines = new ArrayList<AttributedString>();
        int width = this.size.getColumns() - (this.printLineNumbers ? 8 : 0);
        int height = this.size.getRows();
        int inputLine = this.firstLineToDisplay;
        AttributedString curLine = null;
        Pattern compiled = this.getPattern();
        boolean fitOnOneScreen = false;
        for (int terminalLine = 0; terminalLine < height - 1; ++terminalLine) {
            AttributedString toDisplay;
            if (curLine == null) {
                if ((curLine = this.getLine(inputLine++)) == null) {
                    if (oneScreen) {
                        fitOnOneScreen = true;
                        break;
                    }
                    curLine = new AttributedString("");
                }
                if (compiled != null) {
                    curLine = curLine.styleMatches(compiled, AttributedStyle.DEFAULT.inverse());
                }
            }
            if (this.firstColumnToDisplay > 0 || this.chopLongLines) {
                int off = this.firstColumnToDisplay;
                if (terminalLine == 0 && this.offsetInLine > 0) {
                    off = Math.max(this.offsetInLine, off);
                }
                toDisplay = curLine.columnSubSequence(off, off + width);
                curLine = null;
            } else {
                if (terminalLine == 0 && this.offsetInLine > 0) {
                    curLine = curLine.columnSubSequence(this.offsetInLine, Integer.MAX_VALUE);
                }
                toDisplay = curLine.columnSubSequence(0, width);
                if ((curLine = curLine.columnSubSequence(width, Integer.MAX_VALUE)).length() == 0) {
                    curLine = null;
                }
            }
            if (this.printLineNumbers) {
                AttributedStringBuilder sb = new AttributedStringBuilder();
                sb.append(String.format("%7d ", inputLine));
                sb.append(toDisplay);
                newLines.add(sb.toAttributedString());
                continue;
            }
            newLines.add(toDisplay);
        }
        if (oneScreen) {
            if (fitOnOneScreen) {
                newLines.forEach(l -> this.terminal.writer().println(l.toAnsi(this.terminal)));
            }
            return fitOnOneScreen;
        }
        AttributedStringBuilder msg2 = new AttributedStringBuilder();
        if (this.buffer.length() > 0) {
            msg2.append(" ").append(this.buffer);
        } else if (this.bindingReader.getCurrentBuffer().length() > 0 && this.terminal.reader().peek(1L) == -2) {
            msg2.append(" ").append(this.printable(this.bindingReader.getCurrentBuffer()));
        } else if (this.message != null) {
            msg2.style(AttributedStyle.INVERSE);
            msg2.append(this.message);
            msg2.style(AttributedStyle.INVERSE.inverseOff());
        } else {
            msg2.append(":");
        }
        newLines.add(msg2.toAttributedString());
        this.display.resize(this.size.getRows(), this.size.getColumns());
        this.display.update(newLines, -1);
        return false;
    }

    private Pattern getPattern() {
        Pattern compiled = null;
        if (this.pattern != null) {
            boolean insensitive = this.ignoreCaseAlways || this.ignoreCaseCond && this.pattern.toLowerCase().equals(this.pattern);
            compiled = Pattern.compile("(" + this.pattern + ")", insensitive ? 66 : 0);
        }
        return compiled;
    }

    AttributedString getLine(int line) throws IOException {
        String str;
        while (line >= this.lines.size() && (str = this.reader.readLine()) != null) {
            this.lines.add(AttributedString.fromAnsi(str, this.tabs));
        }
        if (line < this.lines.size()) {
            return this.lines.get(line);
        }
        return null;
    }

    public static void checkInterrupted() throws InterruptedException {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private void bindKeys(KeyMap<Operation> map) {
        map.bind(Operation.HELP, "h", "H");
        map.bind(Operation.EXIT, "q", ":q", "Q", ":Q", "ZZ");
        map.bind(Operation.FORWARD_ONE_LINE, "e", KeyMap.ctrl('E'), "j", KeyMap.ctrl('N'), "\r", KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        map.bind(Operation.BACKWARD_ONE_LINE, "y", KeyMap.ctrl('Y'), "k", KeyMap.ctrl('K'), KeyMap.ctrl('P'), KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        map.bind(Operation.FORWARD_ONE_WINDOW_OR_LINES, "f", KeyMap.ctrl('F'), KeyMap.ctrl('V'), " ");
        map.bind(Operation.BACKWARD_ONE_WINDOW_OR_LINES, "b", KeyMap.ctrl('B'), KeyMap.alt('v'));
        map.bind(Operation.FORWARD_ONE_WINDOW_AND_SET, (CharSequence)"z");
        map.bind(Operation.BACKWARD_ONE_WINDOW_AND_SET, (CharSequence)"w");
        map.bind(Operation.FORWARD_ONE_WINDOW_NO_STOP, (CharSequence)KeyMap.alt(' '));
        map.bind(Operation.FORWARD_HALF_WINDOW_AND_SET, "d", KeyMap.ctrl('D'));
        map.bind(Operation.BACKWARD_HALF_WINDOW_AND_SET, "u", KeyMap.ctrl('U'));
        map.bind(Operation.RIGHT_ONE_HALF_SCREEN, KeyMap.alt(')'), KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        map.bind(Operation.LEFT_ONE_HALF_SCREEN, KeyMap.alt('('), KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        map.bind(Operation.FORWARD_FOREVER, (CharSequence)"F");
        map.bind(Operation.REPEAT_SEARCH_FORWARD, "n", "N");
        map.bind(Operation.REPEAT_SEARCH_FORWARD_SPAN_FILES, KeyMap.alt('n'), KeyMap.alt('N'));
        map.bind(Operation.UNDO_SEARCH, (CharSequence)KeyMap.alt('u'));
        map.bind(Operation.GO_TO_FIRST_LINE_OR_N, "g", "<", KeyMap.alt('<'));
        map.bind(Operation.GO_TO_LAST_LINE_OR_N, "G", ">", KeyMap.alt('>'));
        map.bind(Operation.NEXT_FILE, (CharSequence)":n");
        map.bind(Operation.PREV_FILE, (CharSequence)":p");
        "-/0123456789?".chars().forEach(c -> map.bind(Operation.CHAR, (CharSequence)Character.toString((char)c)));
    }

    static class InterruptibleInputStream
    extends FilterInputStream {
        InterruptibleInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            return super.read(b, off, len);
        }
    }

    protected static enum Operation {
        HELP,
        EXIT,
        FORWARD_ONE_LINE,
        BACKWARD_ONE_LINE,
        FORWARD_ONE_WINDOW_OR_LINES,
        BACKWARD_ONE_WINDOW_OR_LINES,
        FORWARD_ONE_WINDOW_AND_SET,
        BACKWARD_ONE_WINDOW_AND_SET,
        FORWARD_ONE_WINDOW_NO_STOP,
        FORWARD_HALF_WINDOW_AND_SET,
        BACKWARD_HALF_WINDOW_AND_SET,
        LEFT_ONE_HALF_SCREEN,
        RIGHT_ONE_HALF_SCREEN,
        FORWARD_FOREVER,
        REPAINT,
        REPAINT_AND_DISCARD,
        REPEAT_SEARCH_FORWARD,
        REPEAT_SEARCH_BACKWARD,
        REPEAT_SEARCH_FORWARD_SPAN_FILES,
        REPEAT_SEARCH_BACKWARD_SPAN_FILES,
        UNDO_SEARCH,
        GO_TO_FIRST_LINE_OR_N,
        GO_TO_LAST_LINE_OR_N,
        GO_TO_PERCENT_OR_N,
        GO_TO_NEXT_TAG,
        GO_TO_PREVIOUS_TAG,
        FIND_CLOSE_BRACKET,
        FIND_OPEN_BRACKET,
        OPT_PRINT_LINES,
        OPT_CHOP_LONG_LINES,
        OPT_QUIT_AT_FIRST_EOF,
        OPT_QUIT_AT_SECOND_EOF,
        OPT_QUIET,
        OPT_VERY_QUIET,
        OPT_IGNORE_CASE_COND,
        OPT_IGNORE_CASE_ALWAYS,
        NEXT_FILE,
        PREV_FILE,
        CHAR;

    }
}

