/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J>\u0010\u0013\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationOnSuperclass", "superTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkClassCannotBeExtendedDirectly", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "checkDelegationNotToInterface", "checkExpandedTypeCannotBeInherited", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "fullyExpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneType", "checkProjectionInImmediateArgumentToSupertype", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSupertypesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,185:1\n49#2:186\n21#3:187\n*S KotlinDebug\n*F\n+ 1 FirSupertypesChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSupertypesChecker\n*L\n77#1:186\n175#1:187\n*E\n"})
public final class FirSupertypesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirSupertypesChecker INSTANCE = new FirSupertypesChecker();

    private FirSupertypesChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        KtSourceElement ktSourceElement = declaration.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        boolean isInterface2 = declaration.getClassKind() == ClassKind.INTERFACE;
        boolean nullableSupertypeReported = false;
        boolean extensionFunctionSupertypeReported = false;
        boolean interfaceWithSuperclassReported = !isInterface2;
        boolean finalSupertypeReported = false;
        boolean singletonInSupertypeReported = false;
        boolean classAppeared = false;
        HashSet superClassSymbols = new HashSet();
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            Object object;
            if (superTypeRef.getSource() == null) continue;
            ConeKotlinType coneType = FirTypeUtilsKt.getConeType(superTypeRef);
            if (!nullableSupertypeReported && coneType.getNullability() == ConeNullability.NULLABLE) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_SUPERTYPE(), (DiagnosticContext)context, null, 8, null);
                nullableSupertypeReported = true;
            }
            if (!extensionFunctionSupertypeReported && CompilerConeAttributesKt.isExtensionFunctionType(coneType) && !FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession()).supportsFeature(LanguageFeature.FunctionalTypeWithExtensionAsSupertype)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
                extensionFunctionSupertypeReported = true;
            }
            if ((object = coneType instanceof ConeClassLikeType ? (ConeClassLikeType)coneType : null) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) continue;
            Object lookupTag2 = object;
            FirClassLikeSymbol<?> superTypeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag2, context.getSession());
            if (superTypeSymbol instanceof FirRegularClassSymbol) {
                boolean isObject2;
                if (!superClassSymbols.add(superTypeSymbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_APPEARS_TWICE(), (DiagnosticContext)context, null, 8, null);
                }
                if (((FirRegularClassSymbol)superTypeSymbol).getClassKind() != ClassKind.INTERFACE) {
                    if (classAppeared) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getMANY_CLASSES_IN_SUPERTYPE_LIST(), (DiagnosticContext)context, null, 8, null);
                    } else {
                        classAppeared = true;
                    }
                    if (!interfaceWithSuperclassReported) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getINTERFACE_WITH_SUPERCLASS(), (DiagnosticContext)context, null, 8, null);
                        interfaceWithSuperclassReported = true;
                    }
                }
                boolean bl = isObject2 = ((FirRegularClassSymbol)superTypeSymbol).getClassKind() == ClassKind.OBJECT;
                if (!finalSupertypeReported && !isObject2) {
                    FirClassSymbol $this$modality$iv = (FirClassSymbol)superTypeSymbol;
                    boolean $i$f$getModality = false;
                    if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getFINAL_SUPERTYPE(), (DiagnosticContext)context, null, 8, null);
                        finalSupertypeReported = true;
                    }
                }
                if (!singletonInSupertypeReported && isObject2) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSINGLETON_IN_SUPERTYPE(), (DiagnosticContext)context, null, 8, null);
                    singletonInSupertypeReported = true;
                }
            }
            this.checkAnnotationOnSuperclass(superTypeRef, context, reporter2);
            ConeClassLikeType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)coneType, context.getSession(), null, 2, null);
            FirClassLikeSymbol<?> symbol2 = TypeUtilsKt.toSymbol(fullyExpandedType2, context.getSession());
            this.checkClassCannotBeExtendedDirectly((FirClassifierSymbol)symbol2, reporter2, superTypeRef, context);
            if (!(coneType.getTypeArguments().length == 0)) {
                this.checkProjectionInImmediateArgumentToSupertype(coneType, superTypeRef, reporter2, context);
                continue;
            }
            this.checkExpandedTypeCannotBeInherited((FirBasedSymbol)symbol2, fullyExpandedType2, reporter2, superTypeRef, coneType, context);
        }
        this.checkDelegationNotToInterface(declaration, context, reporter2);
        if (declaration instanceof FirRegularClass && declaration.getSuperTypeRefs().size() > 1) {
            FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(CollectionsKt.listOf((Object)new Pair(null, (Object)((FirRegularClass)declaration).getSymbol())), context, reporter2, declaration.getSource(), true);
        }
    }

    private final void checkAnnotationOnSuperclass(FirTypeRef superTypeRef, CheckerContext context, DiagnosticReporter reporter2) {
        for (FirAnnotation annotation2 : superTypeRef.getAnnotations()) {
            if (annotation2.getUseSiteTarget() == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getANNOTATION_ON_SUPERCLASS(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkClassCannotBeExtendedDirectly(FirClassifierSymbol<?> symbol2, DiagnosticReporter reporter2, FirTypeRef superTypeRef, CheckerContext context) {
        if (symbol2 instanceof FirRegularClassSymbol && Intrinsics.areEqual((Object)((FirRegularClassSymbol)symbol2).getClassId(), (Object)StandardClassIds.INSTANCE.getEnum())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getCLASS_CANNOT_BE_EXTENDED_DIRECTLY(), symbol2, (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkProjectionInImmediateArgumentToSupertype(ConeKotlinType coneType, FirTypeRef superTypeRef, DiagnosticReporter reporter2, CheckerContext context) {
        List<FirTypeRefSource> list2 = FirHelpersKt.extractArgumentsTypeRefAndSource(superTypeRef);
        if (list2 == null) {
            return;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list2;
        ConeTypeProjection[] coneTypeProjectionArray = coneType.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        for (int j = 0; j < n; ++j) {
            int index2 = j;
            ConeTypeProjection typeArgument = coneTypeProjectionArray[j];
            if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
            FirTypeRefSource firTypeRefSource = (FirTypeRefSource)CollectionsKt.getOrNull(typeRefAndSourcesForArguments, (int)index2);
            if (firTypeRefSource == null) continue;
            KtSourceElement argSource = firTypeRefSource.component2();
            KtSourceElement ktSourceElement = argSource;
            if (ktSourceElement == null) {
                ktSourceElement = superTypeRef.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getPROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkExpandedTypeCannotBeInherited(FirBasedSymbol<?> symbol2, ConeKotlinType fullyExpandedType2, DiagnosticReporter reporter2, FirTypeRef superTypeRef, ConeKotlinType coneType, CheckerContext context) {
        if (symbol2 instanceof FirRegularClassSymbol && ((FirRegularClassSymbol)symbol2).getClassKind() == ClassKind.INTERFACE) {
            for (ConeTypeProjection typeArgument : fullyExpandedType2.getTypeArguments()) {
                if (!FirHelpersKt.isConflictingOrNotInvariant(typeArgument)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getEXPANDED_TYPE_CANNOT_BE_INHERITED(), (Object)coneType, (DiagnosticContext)context, null, 16, null);
                break;
            }
        }
    }

    private final void checkDelegationNotToInterface(FirClass declaration, CheckerContext context, DiagnosticReporter reporter2) {
        for (FirDeclaration subDeclaration : declaration.getDeclarations()) {
            FirRegularClassSymbol delegatedClassSymbol;
            if (!(subDeclaration instanceof FirField)) continue;
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)subDeclaration;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE) || !FirHelpersKt.isDelegated(((FirField)subDeclaration).getName()) || (delegatedClassSymbol = FirHelpersKt.toRegularClassSymbol(((FirField)subDeclaration).getReturnTypeRef(), context.getSession())) == null || delegatedClassSymbol.getClassKind() == ClassKind.INTERFACE) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)((FirField)subDeclaration).getReturnTypeRef().getSource(), FirErrors.INSTANCE.getDELEGATION_NOT_TO_INTERFACE(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

