/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeAnnotationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTypeAnnotationChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirTypeAnnotationChecker INSTANCE = new FirTypeAnnotationChecker();

    private FirTypeAnnotationChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (!(typeRef instanceof FirResolvedTypeRef)) {
            return;
        }
        for (FirAnnotation annotation2 : typeRef.getAnnotations()) {
            AnnotationUseSiteTarget useSiteTarget;
            if (annotation2.getSource() == null) continue;
            Set<KotlinTarget> annotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation2, context.getSession());
            if (!(annotationTargets.contains((Object)KotlinTarget.TYPE) || (useSiteTarget = annotation2.getUseSiteTarget()) != null && CollectionsKt.contains((Iterable)annotationTargets, (Object)((Object)KotlinTarget.Companion.getUSE_SITE_MAPPING().get((Object)useSiteTarget))))) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"type usage", (DiagnosticContext)context, null, 16, null);
            }
            if (!Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId(annotation2, context.getSession()), (Object)StandardClassIds.Annotations.INSTANCE.getExtensionFunctionType())) continue;
            if (!InferenceUtilsKt.isBuiltinFunctionalType(((FirResolvedTypeRef)typeRef).getType(), context.getSession())) {
                if (context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidExtensionFunctionTypeOnNonFunctionTypes)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE_WARNING(), (DiagnosticContext)context, null, 8, null);
                continue;
            }
            if (((FirResolvedTypeRef)typeRef).getType().getTypeArguments().length > 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotation2.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

