/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeBinaryLogicExpression;
import org.jetbrains.kotlin.fir.contracts.description.ConeBooleanConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeCallsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConditionalEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeConstantReference;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionElement;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractDescriptionVisitor;
import org.jetbrains.kotlin.fir.contracts.description.ConeEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsInstancePredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeIsNullPredicate;
import org.jetbrains.kotlin.fir.contracts.description.ConeLogicalNot;
import org.jetbrains.kotlin.fir.contracts.description.ConeReturnsEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeValueParameterReference;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.LogicOperationKind;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirContractSerializer;", "", "()V", "serializeContractOfFunctionIfAny", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "parentSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "ContractSerializerWorker", "fir-serialization"})
public final class FirContractSerializer {
    public final void serializeContractOfFunctionIfAny(@NotNull FirFunction function2, @NotNull ProtoBuf.Function.Builder proto, @NotNull FirElementSerializer parentSerializer) {
        Collection collection;
        FirContractDescription contractDescription;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)parentSerializer, (String)"parentSerializer");
        FirSimpleFunction firSimpleFunction = function2 instanceof FirSimpleFunction ? (FirSimpleFunction)function2 : null;
        FirContractDescription firContractDescription = contractDescription = firSimpleFunction != null ? firSimpleFunction.getContractDescription() : null;
        if (contractDescription == null || (collection = (Collection)ContractUtilsKt.getEffects(contractDescription)) == null || collection.isEmpty()) {
            return;
        }
        ContractSerializerWorker worker = new ContractSerializerWorker(parentSerializer);
        proto.setContract(worker.contractProto(contractDescription));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirContractSerializer$ContractSerializerWorker;", "", "parentSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "(Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "constantValueProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "constantReference", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConstantReference;", "contractExpressionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$Builder;", "contractDescriptionElement", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "contractProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract$Builder;", "effectProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$Builder;", "effectDeclaration", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeEffectDeclaration;", "fillEffectProto", "", "builder", "invocationKindProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "kind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "writeFlags", "newFlagsValue", "", "fir-serialization"})
    @SourceDebugExtension(value={"SMAP\nFirContractSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirContractSerializer$ContractSerializerWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n1855#2,2:217\n*S KotlinDebug\n*F\n+ 1 FirContractSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirContractSerializer$ContractSerializerWorker\n*L\n35#1:217,2\n*E\n"})
    private static final class ContractSerializerWorker {
        @NotNull
        private final FirElementSerializer parentSerializer;

        public ContractSerializerWorker(@NotNull FirElementSerializer parentSerializer) {
            Intrinsics.checkNotNullParameter((Object)parentSerializer, (String)"parentSerializer");
            this.parentSerializer = parentSerializer;
        }

        @NotNull
        public final ProtoBuf.Contract.Builder contractProto(@NotNull FirContractDescription contractDescription) {
            ProtoBuf.Contract.Builder builder2;
            Intrinsics.checkNotNullParameter((Object)contractDescription, (String)"contractDescription");
            ProtoBuf.Contract.Builder $this$contractProto_u24lambda_u241 = builder2 = ProtoBuf.Contract.newBuilder();
            boolean bl = false;
            List<FirEffectDeclaration> list2 = ContractUtilsKt.getEffects(contractDescription);
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirEffectDeclaration it = (FirEffectDeclaration)element$iv;
                    boolean bl2 = false;
                    $this$contractProto_u24lambda_u241.addEffect(this.effectProto(it.getEffect(), contractDescription));
                }
            }
            ProtoBuf.Contract.Builder builder3 = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder().apply {\n   \u2026ription)) }\n            }");
            return builder3;
        }

        private final ProtoBuf.Effect.Builder effectProto(ConeEffectDeclaration effectDeclaration, FirContractDescription contractDescription) {
            ProtoBuf.Effect.Builder builder2;
            ProtoBuf.Effect.Builder $this$effectProto_u24lambda_u242 = builder2 = ProtoBuf.Effect.newBuilder();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$effectProto_u24lambda_u242, (String)"this");
            this.fillEffectProto($this$effectProto_u24lambda_u242, effectDeclaration, contractDescription);
            ProtoBuf.Effect.Builder builder3 = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder().apply {\n   \u2026escription)\n            }");
            return builder3;
        }

        private final void fillEffectProto(ProtoBuf.Effect.Builder builder2, ConeEffectDeclaration effectDeclaration, FirContractDescription contractDescription) {
            ConeEffectDeclaration coneEffectDeclaration = effectDeclaration;
            if (coneEffectDeclaration instanceof ConeConditionalEffectDeclaration) {
                builder2.setConclusionOfConditionalEffect(this.contractExpressionProto(((ConeConditionalEffectDeclaration)effectDeclaration).getCondition(), contractDescription));
                this.fillEffectProto(builder2, ((ConeConditionalEffectDeclaration)effectDeclaration).getEffect(), contractDescription);
            } else if (coneEffectDeclaration instanceof ConeReturnsEffectDeclaration) {
                ConeConstantReference coneConstantReference = ((ConeReturnsEffectDeclaration)effectDeclaration).getValue();
                if (Intrinsics.areEqual((Object)coneConstantReference, (Object)ConeConstantReference.Companion.getNOT_NULL())) {
                    builder2.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL);
                } else if (Intrinsics.areEqual((Object)coneConstantReference, (Object)ConeConstantReference.Companion.getWILDCARD())) {
                    builder2.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                } else {
                    builder2.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                    builder2.addEffectConstructorArgument(this.contractExpressionProto(((ConeReturnsEffectDeclaration)effectDeclaration).getValue(), contractDescription));
                }
            } else if (coneEffectDeclaration instanceof ConeCallsEffectDeclaration) {
                builder2.setEffectType(ProtoBuf.Effect.EffectType.CALLS);
                builder2.addEffectConstructorArgument(this.contractExpressionProto(((ConeCallsEffectDeclaration)effectDeclaration).getValueParameterReference(), contractDescription));
                ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum = this.invocationKindProtobufEnum(((ConeCallsEffectDeclaration)effectDeclaration).getKind());
                if (invocationKindProtobufEnum != null) {
                    builder2.setKind(invocationKindProtobufEnum);
                }
            } else {
                throw new IllegalStateException("Unsupported effect type: " + Reflection.getOrCreateKotlinClass(effectDeclaration.getClass()).getSimpleName());
            }
        }

        private final ProtoBuf.Expression.Builder contractExpressionProto(ConeContractDescriptionElement contractDescriptionElement, FirContractDescription contractDescription) {
            return (ProtoBuf.Expression.Builder)contractDescriptionElement.accept((ConeContractDescriptionVisitor)new ConeContractDescriptionVisitor<ProtoBuf.Expression.Builder, Unit>(this, contractDescription){
                final /* synthetic */ ContractSerializerWorker this$0;
                final /* synthetic */ FirContractDescription $contractDescription;
                {
                    this.this$0 = $receiver;
                    this.$contractDescription = $contractDescription;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitLogicalBinaryOperationContractExpression(@NotNull ConeBinaryLogicExpression binaryLogicExpression, @NotNull Unit data2) {
                    Intrinsics.checkNotNullParameter((Object)binaryLogicExpression, (String)"binaryLogicExpression");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    return binaryLogicExpression.getKind() == LogicOperationKind.AND ? this.visitLogicalAnd(binaryLogicExpression, data2) : this.visitLogicalOr(binaryLogicExpression, data2);
                }

                private final ProtoBuf.Expression.Builder visitLogicalOr(ConeBinaryLogicExpression logicalOr, Unit data2) {
                    ProtoBuf.Expression.Builder builder2;
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalOr.getLeft().accept(this, data2);
                    if (leftBuilder.getAndArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder3 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u240 = builder3;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(leftBuilder);
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), firContractDescription));
                        ProtoBuf.Expression.Builder builder4 = builder3;
                        builder2 = builder4;
                        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"{\n                      \u2026  }\n                    }");
                    } else {
                        ProtoBuf.Expression.Builder builder5 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u241 = builder5;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u241.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), firContractDescription));
                        builder2 = builder5;
                    }
                    return builder2;
                }

                private final ProtoBuf.Expression.Builder visitLogicalAnd(ConeBinaryLogicExpression logicalAnd, Unit data2) {
                    ProtoBuf.Expression.Builder builder2;
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalAnd.getLeft().accept(this, data2);
                    if (leftBuilder.getOrArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder3 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u242 = builder3;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(leftBuilder);
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), firContractDescription));
                        ProtoBuf.Expression.Builder builder4 = builder3;
                        builder2 = builder4;
                        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"{\n                      \u2026  }\n                    }");
                    } else {
                        ProtoBuf.Expression.Builder builder5 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u243 = builder5;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u243.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), firContractDescription));
                        builder2 = builder5;
                    }
                    return builder2;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitLogicalNot(@NotNull ConeLogicalNot logicalNot, @NotNull Unit data2) {
                    Intrinsics.checkNotNullParameter((Object)logicalNot, (String)"logicalNot");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    R r = logicalNot.getArg().accept(this, data2);
                    ContractSerializerWorker contractSerializerWorker = this.this$0;
                    ProtoBuf.Expression.Builder $this$visitLogicalNot_u24lambda_u244 = (ProtoBuf.Expression.Builder)r;
                    boolean bl = false;
                    ContractSerializerWorker.access$writeFlags(contractSerializerWorker, $this$visitLogicalNot_u24lambda_u244, Flags.IS_NEGATED.invert($this$visitLogicalNot_u24lambda_u244.getFlags()));
                    return (ProtoBuf.Expression.Builder)r;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitIsInstancePredicate(@NotNull ConeIsInstancePredicate isInstancePredicate, @NotNull Unit data2) {
                    Intrinsics.checkNotNullParameter((Object)isInstancePredicate, (String)"isInstancePredicate");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    ProtoBuf.Expression.Builder builder2 = this.visitValueParameterReference(isInstancePredicate.getArg(), data2);
                    builder2.setIsInstanceTypeId(ContractSerializerWorker.access$getParentSerializer$p(this.this$0).typeId(isInstancePredicate.getType()));
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder2, Flags.getContractExpressionFlags(isInstancePredicate.isNegated(), false));
                    return builder2;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitIsNullPredicate(@NotNull ConeIsNullPredicate isNullPredicate, @NotNull Unit data2) {
                    Intrinsics.checkNotNullParameter((Object)isNullPredicate, (String)"isNullPredicate");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    ProtoBuf.Expression.Builder builder2 = this.visitValueParameterReference(isNullPredicate.getArg(), data2);
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder2, Flags.getContractExpressionFlags(isNullPredicate.isNegated(), true));
                    return builder2;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitConstantDescriptor(@NotNull ConeConstantReference constantReference, @NotNull Unit data2) {
                    Intrinsics.checkNotNullParameter((Object)constantReference, (String)"constantReference");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                    ProtoBuf.Expression.ConstantValue constantValueProtobufEnum = ContractSerializerWorker.access$constantValueProtobufEnum(this.this$0, constantReference);
                    if (constantValueProtobufEnum != null) {
                        builder2.setConstantValue(constantValueProtobufEnum);
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
                    return builder2;
                }

                @NotNull
                public ProtoBuf.Expression.Builder visitValueParameterReference(@NotNull ConeValueParameterReference valueParameterReference, @NotNull Unit data2) {
                    Intrinsics.checkNotNullParameter((Object)valueParameterReference, (String)"valueParameterReference");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                    ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                    int indexOfParameter = valueParameterReference.getParameterIndex() + 1;
                    builder2.setValueParameterReference(indexOfParameter);
                    Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder");
                    return builder2;
                }
            }, Unit.INSTANCE);
        }

        private final void writeFlags(ProtoBuf.Expression.Builder $this$writeFlags, int newFlagsValue) {
            if ($this$writeFlags.getFlags() != newFlagsValue) {
                $this$writeFlags.setFlags(newFlagsValue);
            }
        }

        private final ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum(EventOccurrencesRange kind) {
            ProtoBuf.Effect.InvocationKind invocationKind;
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE;
                    break;
                }
                default: {
                    invocationKind = null;
                }
            }
            return invocationKind;
        }

        private final ProtoBuf.Expression.ConstantValue constantValueProtobufEnum(ConeConstantReference constantReference) {
            ProtoBuf.Expression.ConstantValue constantValue;
            ConeConstantReference coneConstantReference = constantReference;
            if (Intrinsics.areEqual((Object)coneConstantReference, (Object)ConeBooleanConstantReference.Companion.getTRUE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.TRUE;
            } else if (Intrinsics.areEqual((Object)coneConstantReference, (Object)ConeBooleanConstantReference.Companion.getFALSE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.FALSE;
            } else if (Intrinsics.areEqual((Object)coneConstantReference, (Object)ConeConstantReference.Companion.getNULL())) {
                constantValue = ProtoBuf.Expression.ConstantValue.NULL;
            } else {
                if (Intrinsics.areEqual((Object)coneConstantReference, (Object)ConeConstantReference.Companion.getNOT_NULL())) {
                    throw new IllegalStateException("Internal error during serialization of function contract: NOT_NULL constant isn't denotable in protobuf format. Its serialization should be handled at higher level");
                }
                if (Intrinsics.areEqual((Object)coneConstantReference, (Object)ConeConstantReference.Companion.getWILDCARD())) {
                    constantValue = null;
                } else {
                    throw new IllegalArgumentException("Unknown constant: " + constantReference);
                }
            }
            return constantValue;
        }

        public static final /* synthetic */ FirElementSerializer access$getParentSerializer$p(ContractSerializerWorker $this) {
            return $this.parentSerializer;
        }

        public static final /* synthetic */ void access$writeFlags(ContractSerializerWorker $this, ProtoBuf.Expression.Builder $receiver, int newFlagsValue) {
            $this.writeFlags($receiver, newFlagsValue);
        }

        public static final /* synthetic */ ProtoBuf.Expression.ConstantValue access$constantValueProtobufEnum(ContractSerializerWorker $this, ConeConstantReference constantReference) {
            return $this.constantValueProtobufEnum(constantReference);
        }

        public static final /* synthetic */ ProtoBuf.Expression.Builder access$contractExpressionProto(ContractSerializerWorker $this, ConeContractDescriptionElement contractDescriptionElement, FirContractDescription contractDescription) {
            return $this.contractExpressionProto(contractDescriptionElement, contractDescription);
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EventOccurrencesRange.values().length];
                try {
                    nArray[EventOccurrencesRange.AT_MOST_ONCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.EXACTLY_ONCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.AT_LEAST_ONCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

