/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.FileDeserializationState;
import org.jetbrains.kotlin.backend.common.serialization.IdSignatureDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrDeserializationSettings;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrKlibBytesSource;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFileFromBytes;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.library.IrLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001ZBO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u001c01H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0001H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020(H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020(H\u0016J\u0011\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020(H\u0096\u0002J\u001a\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010<\u001a\u00020(2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010<\u001a\u00020(H\u0016J8\u0010G\u001a\u00020!2\u0006\u0010H\u001a\u00020I2\u0006\u00107\u001a\u00020\u001b2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020\u00012\u0006\u0010O\u001a\u00020\u000fH\u0002J\u0010\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u00020(H\u0016J\b\u0010R\u001a\u000203H\u0016J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u00060\u001eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R0\u0010&\u001a\u001e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020!0'j\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020!`)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R!\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00010 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b-\u0010#R\u0014\u0010C\u001a\u00020DX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0014\u0010V\u001a\u00020W8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010Y\u00a8\u0006["}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "linker", "Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "klib", "Lorg/jetbrains/kotlin/library/IrLibrary;", "strategyResolver", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "libraryAbiVersion", "Lorg/jetbrains/kotlin/library/KotlinAbiVersion;", "containsErrorCode", "", "shouldSaveDeserializationState", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/library/IrLibrary;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/library/KotlinAbiVersion;ZZ)V", "getLinker", "()Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "getKlib", "()Lorg/jetbrains/kotlin/library/IrLibrary;", "getStrategyResolver", "()Lkotlin/jvm/functions/Function1;", "fileToDeserializerMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileDeserializer;", "moduleDeserializationState", "Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer$ModuleDeserializationState;", "fileDeserializationStates", "", "Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "getFileDeserializationStates", "()Ljava/util/List;", "setFileDeserializationStates", "(Ljava/util/List;)V", "moduleReversedFileIndex", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/collections/HashMap;", "getModuleReversedFileIndex", "()Ljava/util/HashMap;", "moduleDependencies", "getModuleDependencies", "moduleDependencies$delegate", "Lkotlin/Lazy;", "fileDeserializers", "", "init", "", "delegate", "referenceSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "file", "idSignature", "referencePropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "contains", "idSig", "tryDeserializeIrSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "symbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "deserializedSymbolNotFound", "", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getModuleFragment", "()Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "deserializeIrFile", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFileFromBytes;", "fileIndex", "", "moduleDeserializer", "allowErrorNodes", "addModuleReachableTopLevel", "topLevelDeclarationSignature", "deserializeReachableDeclarations", "signatureDeserializerForFile", "Lorg/jetbrains/kotlin/backend/common/serialization/IdSignatureDeserializer;", "fileName", "kind", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "getKind", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializerKind;", "ModuleDeserializationState", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nBasicIrModuleDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicIrModuleDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n827#2:239\n855#2,2:240\n1869#2,2:242\n774#2:245\n865#2,2:246\n1563#2:248\n1634#2,3:249\n1#3:244\n*S KotlinDebug\n*F\n+ 1 BasicIrModuleDeserializer.kt\norg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer\n*L\n51#1:239\n51#1:240,2\n128#1:242,2\n46#1:245\n46#1:246,2\n47#1:248\n47#1:249,3\n*E\n"})
public abstract class BasicIrModuleDeserializer
extends IrModuleDeserializer {
    @NotNull
    private final KotlinIrLinker linker;
    @NotNull
    private final IrLibrary klib;
    @NotNull
    private final Function1<String, DeserializationStrategy> strategyResolver;
    private final boolean containsErrorCode;
    private final boolean shouldSaveDeserializationState;
    @NotNull
    private final Map<org.jetbrains.kotlin.ir.declarations.IrFile, IrFileDeserializer> fileToDeserializerMap;
    @NotNull
    private final ModuleDeserializationState moduleDeserializationState;
    @NotNull
    private List<FileDeserializationState> fileDeserializationStates;
    @NotNull
    private final HashMap<IdSignature, FileDeserializationState> moduleReversedFileIndex;
    @NotNull
    private final Lazy moduleDependencies$delegate;
    @NotNull
    private final IrModuleFragment moduleFragment;

    public BasicIrModuleDeserializer(@NotNull KotlinIrLinker linker2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull IrLibrary klib, @NotNull Function1<? super String, ? extends DeserializationStrategy> strategyResolver, @NotNull KotlinAbiVersion libraryAbiVersion, boolean containsErrorCode, boolean shouldSaveDeserializationState) {
        Intrinsics.checkNotNullParameter((Object)linker2, (String)"linker");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        Intrinsics.checkNotNullParameter(strategyResolver, (String)"strategyResolver");
        Intrinsics.checkNotNullParameter((Object)libraryAbiVersion, (String)"libraryAbiVersion");
        super(moduleDescriptor, libraryAbiVersion);
        this.linker = linker2;
        this.klib = klib;
        this.strategyResolver = strategyResolver;
        this.containsErrorCode = containsErrorCode;
        this.shouldSaveDeserializationState = shouldSaveDeserializationState;
        this.fileToDeserializerMap = new LinkedHashMap();
        this.moduleDeserializationState = new ModuleDeserializationState();
        this.fileDeserializationStates = CollectionsKt.emptyList();
        this.moduleReversedFileIndex = new HashMap();
        this.moduleDependencies$delegate = LazyKt.lazy(() -> BasicIrModuleDeserializer.moduleDependencies_delegate$lambda$2(moduleDescriptor, this));
        this.moduleFragment = new IrModuleFragmentImpl(moduleDescriptor);
    }

    public /* synthetic */ BasicIrModuleDeserializer(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, IrLibrary irLibrary, Function1 function1, KotlinAbiVersion kotlinAbiVersion, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = true;
        }
        this(kotlinIrLinker, moduleDescriptor, irLibrary, (Function1<? super String, ? extends DeserializationStrategy>)function1, kotlinAbiVersion, bl, bl2);
    }

    @NotNull
    public final KotlinIrLinker getLinker() {
        return this.linker;
    }

    @Override
    @NotNull
    public IrLibrary getKlib() {
        return this.klib;
    }

    @Override
    @NotNull
    public Function1<String, DeserializationStrategy> getStrategyResolver() {
        return this.strategyResolver;
    }

    @NotNull
    protected final List<FileDeserializationState> getFileDeserializationStates() {
        if (!this.shouldSaveDeserializationState) {
            throw new IllegalStateException("File deserialization state are not cached inside the instance because `shouldSaveDeserializationState` was set as `false`".toString());
        }
        return this.fileDeserializationStates;
    }

    protected final void setFileDeserializationStates(@NotNull List<FileDeserializationState> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.fileDeserializationStates = list;
    }

    @NotNull
    protected final HashMap<IdSignature, FileDeserializationState> getModuleReversedFileIndex() {
        return this.moduleReversedFileIndex;
    }

    @NotNull
    public List<IrModuleDeserializer> getModuleDependencies() {
        Lazy lazy = this.moduleDependencies$delegate;
        return (List)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<IrFileDeserializer> fileDeserializers() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.fileToDeserializerMap.values();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrFileDeserializer it = (IrFileDeserializer)element$iv$iv;
            boolean bl = false;
            if (((DeserializationStrategy)((Object)this.getStrategyResolver().invoke((Object)it.getFile().getFileEntry().getName()))).getOnDemand()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void init(@NotNull IrModuleDeserializer delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        int fileCount = this.getKlib().fileCount();
        List fileDeserializationStates = new ArrayList();
        for (int i2 = 0; i2 < fileCount; ++i2) {
            CodedInputStream fileStream = BasicIrModuleDeserializerKt.getCodedInputStream(this.getKlib().file(i2));
            IrFile fileProto = IrFile.parseFrom(fileStream, ExtensionRegistryLite.newInstance());
            IrLibraryFileFromBytes fileReader = new IrLibraryFileFromBytes(new IrKlibBytesSource(this.getKlib(), i2));
            IrLibraryFile irLibraryFile = fileReader;
            IrModuleFragment irModuleFragment = this.getModuleFragment();
            Intrinsics.checkNotNull((Object)fileProto);
            org.jetbrains.kotlin.ir.declarations.IrFile file2 = IrFileDeserializerKt.createFile(irLibraryFile, irModuleFragment, fileProto);
            fileDeserializationStates.add(this.deserializeIrFile(fileProto, file2, fileReader, i2, delegate, this.containsErrorCode));
            if (((DeserializationStrategy)((Object)this.getStrategyResolver().invoke((Object)file2.getFileEntry().getName()))).getOnDemand()) continue;
            this.getModuleFragment().getFiles().add(file2);
        }
        if (this.shouldSaveDeserializationState) {
            this.fileDeserializationStates = fileDeserializationStates;
        }
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol referenceSimpleFunctionByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        Object object = this.fileToDeserializerMap.get(file2);
        if (object == null || (object = ((IrFileDeserializer)object).getSymbolDeserializer()) == null || (object = ((IrSymbolDeserializer)object).referenceSimpleFunctionByLocalSignature(idSignature)) == null) {
            throw new IllegalStateException(("No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName()).toString());
        }
        return object;
    }

    @Override
    @NotNull
    public IrPropertySymbol referencePropertyByLocalSignature(@NotNull org.jetbrains.kotlin.ir.declarations.IrFile file2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        Object object = this.fileToDeserializerMap.get(file2);
        if (object == null || (object = ((IrFileDeserializer)object).getSymbolDeserializer()) == null || (object = ((IrSymbolDeserializer)object).referencePropertyByLocalSignature(idSignature)) == null) {
            throw new IllegalStateException(("No deserializer for file " + file2 + " in module " + this.getModuleDescriptor().getName()).toString());
        }
        return object;
    }

    @Override
    public boolean contains(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        return ((Map)this.moduleReversedFileIndex).containsKey(idSig);
    }

    @Override
    @Nullable
    public IrSymbol tryDeserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
        IdSignature topLevelSignature = idSig.topLevelSignature();
        FileDeserializationState fileDeserializationState = this.moduleReversedFileIndex.get(topLevelSignature);
        if (fileDeserializationState == null) {
            return null;
        }
        FileDeserializationState fileLocalDeserializationState = fileDeserializationState;
        fileLocalDeserializationState.addIdSignature(topLevelSignature);
        this.moduleDeserializationState.enqueueFile(fileLocalDeserializationState);
        return fileLocalDeserializationState.getFileDeserializer().getSymbolDeserializer().deserializeIrSymbol(idSig, symbolKind);
    }

    @Override
    @NotNull
    public Void deserializedSymbolNotFound(@NotNull IdSignature idSig) {
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        throw new IllegalStateException(("No file for " + idSig.topLevelSignature() + " (@ " + idSig + ") in module " + this.getModuleDescriptor()).toString());
    }

    @Override
    @NotNull
    public IrModuleFragment getModuleFragment() {
        return this.moduleFragment;
    }

    private final FileDeserializationState deserializeIrFile(IrFile fileProto, org.jetbrains.kotlin.ir.declarations.IrFile file2, IrLibraryFileFromBytes fileReader, int fileIndex, IrModuleDeserializer moduleDeserializer, boolean allowErrorNodes) {
        DeserializationStrategy fileStrategy = (DeserializationStrategy)((Object)this.getStrategyResolver().invoke((Object)file2.getFileEntry().getName()));
        FileDeserializationState fileDeserializationState = new FileDeserializationState(this.linker, fileIndex, file2, fileReader, fileProto, new IrDeserializationSettings(allowErrorNodes, false, fileStrategy.getNeedBodies() ? IrDeserializationSettings.DeserializeFunctionBodies.ALL : (fileStrategy.getInlineBodies() ? IrDeserializationSettings.DeserializeFunctionBodies.ONLY_INLINE : IrDeserializationSettings.DeserializeFunctionBodies.NONE), false, 10, null), moduleDeserializer);
        this.fileToDeserializerMap.put(file2, fileDeserializationState.getFileDeserializer());
        Set<IdSignature> topLevelDeclarations2 = fileDeserializationState.getFileDeserializer().getReversedSignatureIndex().keySet();
        Iterable $this$forEach$iv = topLevelDeclarations2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdSignature it = (IdSignature)element$iv;
            boolean bl = false;
            this.moduleReversedFileIndex.putIfAbsent(it, fileDeserializationState);
        }
        if (fileStrategy.getTheWholeWorld()) {
            fileDeserializationState.enqueueAllDeclarations();
        }
        if (fileStrategy.getTheWholeWorld() || fileStrategy.getExplicitlyExported()) {
            this.moduleDeserializationState.enqueueFile(fileDeserializationState);
        }
        return fileDeserializationState;
    }

    @Override
    public void addModuleReachableTopLevel(@NotNull IdSignature topLevelDeclarationSignature) {
        Intrinsics.checkNotNullParameter((Object)topLevelDeclarationSignature, (String)"topLevelDeclarationSignature");
        this.moduleDeserializationState.addIdSignature(topLevelDeclarationSignature);
    }

    @Override
    public void deserializeReachableDeclarations() {
        this.moduleDeserializationState.deserializeReachableDeclarations();
    }

    @Override
    @NotNull
    public IdSignatureDeserializer signatureDeserializerForFile(@NotNull String fileName) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Iterable iterable = this.fileToDeserializerMap.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((org.jetbrains.kotlin.ir.declarations.IrFile)it.getKey()).getFileEntry().getName(), (Object)fileName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Map.Entry)v0) == null || (object = (IrFileDeserializer)object.getValue()) == null) {
            throw new IllegalStateException(("No file deserializer for " + fileName).toString());
        }
        Object fileDeserializer = object;
        return ((IrFileDeserializer)fileDeserializer).getSymbolDeserializer().getSignatureDeserializer();
    }

    @Override
    @NotNull
    public IrModuleDeserializerKind getKind() {
        return IrModuleDeserializerKind.DESERIALIZED;
    }

    /*
     * WARNING - void declaration
     */
    private static final List moduleDependencies_delegate$lambda$2(ModuleDescriptor $moduleDescriptor, BasicIrModuleDeserializer this$0) {
        void $this$mapTo$iv$iv;
        ModuleDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $moduleDescriptor.getAllDependencyModules();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ModuleDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)$moduleDescriptor))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModuleDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.linker.resolveModuleDeserializer(it, null));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer$ModuleDeserializationState;", "", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/BasicIrModuleDeserializer;)V", "filesWithPendingTopLevels", "", "Lorg/jetbrains/kotlin/backend/common/serialization/FileDeserializationState;", "enqueueFile", "", "fileDeserializationState", "addIdSignature", "topLevelDeclarationSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "deserializeReachableDeclarations", "toString", "", "ir.serialization.common"})
    private final class ModuleDeserializationState {
        @NotNull
        private final Set<FileDeserializationState> filesWithPendingTopLevels = new LinkedHashSet();

        public final void enqueueFile(@NotNull FileDeserializationState fileDeserializationState) {
            Intrinsics.checkNotNullParameter((Object)fileDeserializationState, (String)"fileDeserializationState");
            this.filesWithPendingTopLevels.add(fileDeserializationState);
            BasicIrModuleDeserializer.this.getLinker().getModulesWithReachableTopLevels().add(BasicIrModuleDeserializer.this);
        }

        public final void addIdSignature(@NotNull IdSignature topLevelDeclarationSignature) {
            Intrinsics.checkNotNullParameter((Object)topLevelDeclarationSignature, (String)"topLevelDeclarationSignature");
            FileDeserializationState fileDeserializationState = BasicIrModuleDeserializer.this.getModuleReversedFileIndex().get(topLevelDeclarationSignature);
            if (fileDeserializationState == null) {
                throw new IllegalStateException(("No IR file found for top-level declaration signature " + topLevelDeclarationSignature).toString());
            }
            FileDeserializationState fileLocalDeserializationState = fileDeserializationState;
            fileLocalDeserializationState.addIdSignature(topLevelDeclarationSignature);
            this.enqueueFile(fileLocalDeserializationState);
        }

        public final void deserializeReachableDeclarations() {
            while (!((Collection)this.filesWithPendingTopLevels).isEmpty()) {
                FileDeserializationState pendingFileDeserializationState = (FileDeserializationState)CollectionsKt.first((Iterable)this.filesWithPendingTopLevels);
                if (pendingFileDeserializationState.getFileDeserializer().deserializeFileImplicitDataIfFirstUse()) {
                    BasicIrModuleDeserializer.this.getLinker().getPartialLinkageSupport().enqueueFile(pendingFileDeserializationState.getFile());
                }
                pendingFileDeserializationState.deserializeAllFileReachableTopLevel();
                this.filesWithPendingTopLevels.remove(pendingFileDeserializationState);
            }
        }

        @NotNull
        public String toString() {
            return BasicIrModuleDeserializer.this.getKlib().toString();
        }
    }
}

