/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CompilerSystemProperties;
import org.jetbrains.kotlin.daemon.common.FileSystemUtilsKt;
import org.jetbrains.kotlin.daemon.common.OSKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000e\u001a\u00020\u00052\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0010\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "<init>", "()V", "userHomePath", "", "getUserHomePath", "()Ljava/lang/String;", "tempPath", "getTempPath", "logFilesPath", "getLogFilesPath", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "daemon-common"})
@SourceDebugExtension(value={"SMAP\nFileSystemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemUtils.kt\norg/jetbrains/kotlin/daemon/common/FileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n12883#2,3:87\n1#3:90\n1803#4,3:91\n*S KotlinDebug\n*F\n+ 1 FileSystemUtils.kt\norg/jetbrains/kotlin/daemon/common/FileSystem\n*L\n78#1:87,3\n80#1:91,3\n*E\n"})
public final class FileSystem {
    @NotNull
    public static final FileSystem INSTANCE = new FileSystem();

    private FileSystem() {
    }

    @NotNull
    public final String getUserHomePath() {
        return CompilerSystemProperties.USER_HOME.getSafeValue();
    }

    @NotNull
    public final String getTempPath() {
        return CompilerSystemProperties.TMP_DIR.getSafeValue();
    }

    @NotNull
    public final String getLogFilesPath() {
        return this.getTempPath();
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[OSKind.Companion.getCurrent().ordinal()]) {
            case 1: {
                string2 = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string2 = this.getUserHomePath() + "/Library/Application Support";
                break;
            }
            case 3: {
                string2 = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), this.getUserHomePath() + "/.local/share");
                break;
            }
            case 4: {
                string2 = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRuntimeStateFilesPath(String ... names) {
        String string2;
        File dir2;
        File file2;
        String p1;
        File p0;
        String element$iv;
        Object $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        boolean bl = ArraysKt.any((Object[])names);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        File base = new File(this.getRuntimeStateFilesBasePath());
        if (base.exists() && base.isDirectory()) {
            $this$fold$iv = names;
            boolean $i$f$fold = false;
            File accumulator$iv = base;
            int n = ((String[])$this$fold$iv).length;
            for (int j = 0; j < n; ++j) {
                String string4 = element$iv = $this$fold$iv[j];
                p0 = accumulator$iv;
                boolean bl2 = false;
                accumulator$iv = new File(p0, p1);
            }
            file2 = accumulator$iv;
        } else {
            void it;
            $this$fold$iv = ArraysKt.drop((Object[])names, (int)1);
            String accumulator$iv = (String)ArraysKt.first((Object[])names);
            String string5 = this.getUserHomePath();
            boolean bl3 = false;
            void var14_22 = StringsKt.startsWith$default((String)it, (String)".", (boolean)false, (int)2, null) ? it : '.' + (String)it;
            String string6 = string5;
            File initial$iv = new File(string6, (String)var14_22);
            boolean $i$f$fold = false;
            File accumulator$iv2 = initial$iv;
            Iterator iterator2 = $this$fold$iv.iterator();
            while (iterator2.hasNext()) {
                p1 = element$iv = iterator2.next();
                p0 = accumulator$iv2;
                boolean bl4 = false;
                accumulator$iv2 = new File(p0, p1);
            }
            file2 = dir2 = accumulator$iv2;
        }
        if (dir2.exists() && dir2.isDirectory() || dir2.mkdirs()) {
            String string7 = dir2.getAbsolutePath();
            string2 = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getAbsolutePath(...)");
        } else {
            string2 = this.getTempPath();
        }
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OSKind.values().length];
            try {
                nArray[OSKind.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSKind.OSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSKind.Unix.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSKind.Unknown.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

