/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\"\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J2\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0018\u0010\u0013\u001a\u00020\u0010*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getSubclassOptInApplicabilityAndMessage", "Lkotlin/Pair;", "", "", "firKlass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "representation", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "getRepresentation", "(Lorg/jetbrains/kotlin/descriptors/ClassKind;)Ljava/lang/String;", "checkOptInIsEnabled", "element", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkOptInArgumentIsMarker", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "source", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInAnnotationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,140:1\n43#2:141\n1878#3,3:142\n58#4:145\n61#4:146\n*S KotlinDebug\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n*L\n46#1:141\n69#1:142,3\n86#1:145\n89#1:146\n*E\n"})
public final class FirOptInAnnotationCallChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirOptInAnnotationCallChecker INSTANCE = new FirOptInAnnotationCallChecker();

    private FirOptInAnnotationCallChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirAnnotationCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block12: {
            boolean isSubclassOptIn;
            ClassId classId;
            block11: {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                ConeClassLikeLookupTag coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(FirTypeUtilsKt.getConeType(expression2.getAnnotationTypeRef()));
                if (coneClassLikeLookupTag == null) {
                    return;
                }
                ConeClassLikeLookupTag lookupTag = coneClassLikeLookupTag;
                classId = lookupTag.getClassId();
                boolean isRequiresOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID());
                boolean isOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID());
                isSubclassOptIn = Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID());
                if (!isRequiresOptIn && !isOptIn) break block11;
                this.checkOptInIsEnabled(expression2.getSource(), context, reporter);
                if (!isOptIn) break block12;
                Object $this$arguments$iv = expression2;
                boolean $i$f$getArguments222 = false;
                List<FirExpression> arguments = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getOPT_IN_WITHOUT_ARGUMENTS(), (DiagnosticContext)context, null, 8, null);
                } else {
                    FirExpression $i$f$getArguments222 = FirAnnotationUtilsKt.findArgumentByName$default(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
                    List list = $i$f$getArguments222 != null ? FirAnnotationHelpersKt.extractClassesFromArgument($i$f$getArguments222, context.getSession()) : null;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    $this$arguments$iv = ((Iterable)list).iterator();
                    int $i$f$getArguments222 = 0;
                    while ($this$arguments$iv.hasNext()) {
                        int index2 = $i$f$getArguments222++;
                        FirRegularClassSymbol classSymbol = (FirRegularClassSymbol)$this$arguments$iv.next();
                        KtSourceElement source = FirOptInUsageBaseChecker.INSTANCE.getSourceForIsMarkerDiagnostic(expression2, index2);
                        this.checkOptInArgumentIsMarker(classSymbol, classId, source, reporter, context);
                    }
                }
                break block12;
            }
            if (isSubclassOptIn) {
                FirClass declaration;
                Pair<Boolean, String> $this$arguments$iv = CollectionsKt.lastOrNull(context.getContainingDeclarations());
                FirClass firClass = declaration = $this$arguments$iv instanceof FirClass ? (FirClass)$this$arguments$iv : null;
                if (declaration != null) {
                    $this$arguments$iv = this.getSubclassOptInApplicabilityAndMessage(declaration);
                    boolean isSubclassOptInApplicable = (Boolean)$this$arguments$iv.component1();
                    String message = (String)$this$arguments$iv.component2();
                    if (!isSubclassOptInApplicable && message != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)message, (DiagnosticContext)context, null, 16, null);
                        return;
                    }
                }
                FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
                List list = firExpression != null ? FirAnnotationHelpersKt.extractClassesFromArgument(firExpression, context.getSession()) : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List classSymbols = list;
                Iterable $this$forEachIndexed$iv = classSymbols;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void classSymbol;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)item$iv;
                    int index3 = n;
                    boolean bl = false;
                    KtSourceElement source = FirOptInUsageBaseChecker.INSTANCE.getSourceForIsMarkerDiagnostic(expression2, index3);
                    INSTANCE.checkOptInArgumentIsMarker((FirRegularClassSymbol)classSymbol, classId, source, reporter, context);
                }
            }
        }
    }

    @NotNull
    public final Pair<Boolean, String> getSubclassOptInApplicabilityAndMessage(@NotNull FirClass firKlass) {
        Intrinsics.checkNotNullParameter((Object)firKlass, (String)"firKlass");
        ClassKind kind = firKlass.getClassKind();
        String classKindRepresentation = this.getRepresentation(kind);
        if (kind == ClassKind.ENUM_CLASS || kind == ClassKind.OBJECT || kind == ClassKind.ANNOTATION_CLASS) {
            return TuplesKt.to((Object)false, (Object)classKindRepresentation);
        }
        Modality modality = FirHelpersKt.modality(firKlass);
        if (modality == Modality.FINAL || modality == Modality.SEALED) {
            Boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = modality.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return TuplesKt.to((Object)bl, (Object)stringBuilder.append(string2).append(' ').append(classKindRepresentation).toString());
        }
        FirMemberDeclaration $this$isFun$iv = firKlass;
        boolean $i$f$isFun = false;
        if ($this$isFun$iv.getStatus().isFun()) {
            return TuplesKt.to((Object)false, (Object)"fun interface");
        }
        FirClassLikeDeclaration $this$isLocal$iv = firKlass;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            return TuplesKt.to((Object)false, (Object)("local " + classKindRepresentation));
        }
        return TuplesKt.to((Object)true, null);
    }

    private final String getRepresentation(ClassKind $this$representation) {
        String string2;
        if (WhenMappings.$EnumSwitchMapping$0[$this$representation.ordinal()] == 1) {
            string2 = "enum entry";
        } else {
            String string3 = $this$representation.getCodeRepresentation();
            string2 = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        return string2;
    }

    private final void checkOptInIsEnabled(KtSourceElement element, CheckerContext context, DiagnosticReporter reporter) {
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession());
        List<String> optInFqNames = languageVersionSettings.getFlag(AnalysisFlags.getOptIn());
        if (!languageVersionSettings.supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element, FirErrors.INSTANCE.getOPT_IN_IS_NOT_ENABLED(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkOptInArgumentIsMarker(FirRegularClassSymbol classSymbol, ClassId annotationClassId, KtSourceElement source, DiagnosticReporter reporter, CheckerContext context) {
        FirOptInUsageBaseChecker $this$checkOptInArgumentIsMarker_u24lambda_u241 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default($this$checkOptInArgumentIsMarker_u24lambda_u241, classSymbol, context.getSession(), null, 2, null) == null) {
            KtDiagnosticFactory1<ClassId> ktDiagnosticFactory1;
            ClassId classId = annotationClassId;
            if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getOPT_IN_ARGUMENT_IS_NOT_MARKER();
            } else if (Intrinsics.areEqual((Object)classId, (Object)OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getSUBCLASS_OPT_IN_ARGUMENT_IS_NOT_MARKER();
            } else {
                return;
            }
            KtDiagnosticFactory1<ClassId> diagnostic = ktDiagnosticFactory1;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (Object)classSymbol.getClassId(), (DiagnosticContext)context, null, 16, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

