/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirCacheCleaner;
import org.jetbrains.kotlin.analysis.api.platform.KaCachedService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLAnalysisSessionStatistics;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0002J\b\u0010 \u001a\u00020\u001dH\u0002J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0010\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000f0\u000f \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001a\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner;", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "analysisSessionStatistics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "getAnalysisSessionStatistics$annotations", "()V", "getAnalysisSessionStatistics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "analysisSessionStatistics$delegate", "Lkotlin/Lazy;", "analyzerCount", "", "analyzerDepth", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "cleanupLatch", "Ljava/util/concurrent/CountDownLatch;", "cleanupScheduleMs", "", "hasOngoingAnalysis", "", "getHasOngoingAnalysis", "()Z", "isAnalysisAllowed", "enterAnalysis", "", "exitAnalysis", "incAnalysisDepth", "decAnalysisDepth", "scheduleCleanup", "performCleanup", "Companion", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirCacheCleaner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirCacheCleaner.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,251:1\n1#2:252\n12#3,5:253\n12#3,5:258\n12#3,5:266\n29#4,3:263\n*S KotlinDebug\n*F\n+ 1 KaFirCacheCleaner.kt\norg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner\n*L\n173#1:253,5\n221#1:258,5\n243#1:266,5\n238#1:263,3\n*E\n"})
public final class KaFirStopWorldCacheCleaner
implements KaFirCacheCleaner {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy analysisSessionStatistics$delegate;
    private volatile int analyzerCount;
    private final ThreadLocal<Integer> analyzerDepth;
    @Nullable
    private volatile CountDownLatch cleanupLatch;
    private volatile long cleanupScheduleMs;
    @NotNull
    private static final Logger LOG;
    private static final long CACHE_CLEANER_LOCK_TIMEOUT_MS = 50L;

    public KaFirStopWorldCacheCleaner(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.analysisSessionStatistics$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaFirStopWorldCacheCleaner.analysisSessionStatistics_delegate$lambda$0(this));
        this.analyzerDepth = ThreadLocal.withInitial(KaFirStopWorldCacheCleaner::analyzerDepth$lambda$1);
    }

    private final LLAnalysisSessionStatistics getAnalysisSessionStatistics() {
        Lazy lazy = this.analysisSessionStatistics$delegate;
        return (LLAnalysisSessionStatistics)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getAnalysisSessionStatistics$annotations() {
    }

    private final boolean getHasOngoingAnalysis() {
        return ((Number)this.analyzerDepth.get()).intValue() > 0;
    }

    private final boolean isAnalysisAllowed() {
        return ApplicationManager.getApplication().isReadAccessAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterAnalysis() {
        if (this.getHasOngoingAnalysis()) {
            this.incAnalysisDepth();
            return;
        }
        CountDownLatch existingLatch = this.cleanupLatch;
        if (existingLatch != null) {
            while (!existingLatch.await(50L, TimeUnit.MILLISECONDS)) {
                ProgressManager.checkCanceled();
            }
        }
        if (!this.isAnalysisAllowed()) {
            this.incAnalysisDepth();
            return;
        }
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            boolean bl = false;
            ++this.analyzerCount;
            Unit unit = Unit.INSTANCE;
        }
        this.incAnalysisDepth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitAnalysis() {
        this.decAnalysisDepth();
        if (!this.isAnalysisAllowed() || this.getHasOngoingAnalysis()) {
            return;
        }
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            CountDownLatch existingLatch;
            boolean bl = false;
            --this.analyzerCount;
            if (!(this.analyzerCount >= 0)) {
                boolean $i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22 = false;
                String $i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22 = "Inconsistency in analyzer block counter";
                throw new IllegalArgumentException($i$a$-require-KaFirStopWorldCacheCleaner$exitAnalysis$1$22.toString());
            }
            if (this.cleanupLatch != null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("Analysis complete in " + Thread.currentThread() + ", " + this.analyzerCount + " left before the K2 cache cleanup", e$iv);
                }
            }
            if (this.analyzerCount == 0 && (existingLatch = this.cleanupLatch) != null) {
                this.performCleanup();
                existingLatch.countDown();
                this.cleanupLatch = null;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void incAnalysisDepth() {
        this.analyzerDepth.set(((Number)this.analyzerDepth.get()).intValue() + 1);
    }

    private final void decAnalysisDepth() {
        boolean bl;
        Integer oldValue = this.analyzerDepth.get();
        boolean bl2 = bl = oldValue > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Inconsistency in analysis depth counter";
            throw new AssertionError((Object)string2);
        }
        this.analyzerDepth.set(oldValue - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleCleanup() {
        KaFirStopWorldCacheCleaner kaFirStopWorldCacheCleaner = this;
        synchronized (kaFirStopWorldCacheCleaner) {
            boolean bl = false;
            CountDownLatch existingLatch = this.cleanupLatch;
            if (this.analyzerCount == 0) {
                this.cleanupScheduleMs = System.currentTimeMillis();
                this.performCleanup();
                if (existingLatch != null) {
                    existingLatch.countDown();
                    this.cleanupLatch = null;
                    LOG.error("K2 cache cleanup was expected to happen right after the last analysis block completion");
                }
            } else if (existingLatch == null) {
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl2 = false;
                    logger.debug("K2 cache cleanup scheduled from " + Thread.currentThread() + ", " + this.analyzerCount + " analyses left", e$iv);
                }
                this.cleanupScheduleMs = System.currentTimeMillis();
                this.cleanupLatch = new CountDownLatch(1);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void performCleanup() {
        try {
            LLAnalysisSessionStatistics lLAnalysisSessionStatistics = this.getAnalysisSessionStatistics();
            if (lLAnalysisSessionStatistics != null && (lLAnalysisSessionStatistics = lLAnalysisSessionStatistics.getLowMemoryCacheCleanupInvocationCounter()) != null) {
                lLAnalysisSessionStatistics.add(1L);
            }
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            LLFirSessionInvalidationService invalidationService = LLFirSessionInvalidationService.Companion.getInstance(this.project);
            invalidationService.invalidateAll(true);
            long cleanupMs = System.currentTimeMillis() - start$iv;
            long totalMs = System.currentTimeMillis() - this.cleanupScheduleMs;
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug("K2 cache cleanup complete from " + Thread.currentThread() + " in " + cleanupMs + " ms (" + totalMs + " ms after the request)", e$iv);
            }
        }
        catch (Throwable e) {
            PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded(e);
            LOG.error("Could not clean up K2 caches", e);
        }
    }

    private static final LLAnalysisSessionStatistics analysisSessionStatistics_delegate$lambda$0(KaFirStopWorldCacheCleaner this$0) {
        LLStatisticsService lLStatisticsService = LLStatisticsService.Companion.getInstance(this$0.project);
        return lLStatisticsService != null ? lLStatisticsService.getAnalysisSessions() : null;
    }

    private static final Integer analyzerDepth$lambda$1() {
        return 0;
    }

    static {
        Logger logger = Logger.getInstance(KaFirStopWorldCacheCleaner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirStopWorldCacheCleaner$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CACHE_CLEANER_LOCK_TIMEOUT_MS", "", "analysis-api-fir"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

