/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.web;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.phaser.PhaseEngine;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibSingleFileMetadataSerializer;
import org.jetbrains.kotlin.cli.common.PreSerializationLoweringKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.pipeline.PerformanceNotifications;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.web.AnalyzedFirOutput;
import org.jetbrains.kotlin.cli.pipeline.web.JsFir2IrPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.web.JsSerializedKlibPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.web.WebKlibSerializationPipelinePhaseKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LoggingContext;
import org.jetbrains.kotlin.config.phaser.PhaseConfig;
import org.jetbrains.kotlin.config.phaser.PhaserState;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.pipeline.Fir2IrActualizedResult;
import org.jetbrains.kotlin.fir.pipeline.Fir2KlibMetadataSerializer;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.JsPreSerializationLoweringContext;
import org.jetbrains.kotlin.ir.backend.js.JsPreSerializationLoweringPhasesProvider;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.inline.PreSerializationLoweringPhasesProvider;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.platform.wasm.WasmTarget;
import org.jetbrains.kotlin.progress.IncrementalNextRoundException;
import org.jetbrains.kotlin.wasm.config.WasmTargetKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J`\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/web/WebKlibSerializationPipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/web/JsFir2IrPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/web/JsSerializedKlibPipelineArtifact;", "<init>", "()V", "executePhase", "input", "processIncrementalCompilationRoundIfNeeded", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleStructure", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "firOutput", "Lorg/jetbrains/kotlin/cli/pipeline/web/AnalyzedFirOutput;", "fir2IrResult", "Lorg/jetbrains/kotlin/fir/pipeline/Fir2IrActualizedResult;", "serializeFirKlib", "firOutputs", "", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "fir2IrActualizedResult", "outputKlibPath", "", "nopack", "", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "diagnosticsReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "jsOutputName", "useWasmPlatform", "wasmTarget", "Lorg/jetbrains/kotlin/platform/wasm/WasmTarget;", "cli-js"})
public final class WebKlibSerializationPipelinePhase
extends PipelinePhase<JsFir2IrPipelineArtifact, JsSerializedKlibPipelineArtifact> {
    @NotNull
    public static final WebKlibSerializationPipelinePhase INSTANCE = new WebKlibSerializationPipelinePhase();

    private WebKlibSerializationPipelinePhase() {
        Object[] objectArray = new PerformanceNotifications.AbstractNotification[]{PerformanceNotifications.GenerationStarted.INSTANCE, PerformanceNotifications.IrGenerationStarted.INSTANCE};
        Set set = SetsKt.setOf((Object[])objectArray);
        objectArray = new PerformanceNotifications.AbstractNotification[]{PerformanceNotifications.GenerationFinished.INSTANCE, PerformanceNotifications.IrGenerationFinished.INSTANCE};
        super("JsKlibSerializationPipelinePhase", set, SetsKt.setOf((Object[])objectArray));
    }

    @Override
    @Nullable
    public JsSerializedKlibPipelineArtifact executePhase(@NotNull JsFir2IrPipelineArtifact input) {
        Fir2IrActualizedResult fir2IrActualizedResult;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Fir2IrActualizedResult fir2IrResult = input.component1();
        AnalyzedFirOutput firOutput = input.component2();
        CompilerConfiguration configuration2 = input.component3();
        BaseDiagnosticsCollector diagnosticCollector = input.component4();
        ModulesStructure moduleStructure = input.component5();
        this.processIncrementalCompilationRoundIfNeeded(configuration2, moduleStructure, firOutput, fir2IrResult);
        if (JSConfigurationKeysKt.getWasmCompilation(configuration2)) {
            fir2IrActualizedResult = fir2IrResult;
        } else {
            PhaseConfig phaseConfig = CommonConfigurationKeysKt.getPhaseConfig(configuration2);
            Intrinsics.checkNotNull((Object)phaseConfig);
            fir2IrActualizedResult = PreSerializationLoweringKt.runPreSerializationLoweringPhases(new PhaseEngine(phaseConfig, new PhaserState(null, 0, 0, null, 15, null), (LoggingContext)new JsPreSerializationLoweringContext(fir2IrResult.getIrBuiltIns(), configuration2)), fir2IrResult, (PreSerializationLoweringPhasesProvider)JsPreSerializationLoweringPhasesProvider.INSTANCE);
        }
        Fir2IrActualizedResult transformedResult = fir2IrActualizedResult;
        String outputKlibPath = WebKlibSerializationPipelinePhaseKt.computeOutputKlibPath(configuration2);
        this.serializeFirKlib(moduleStructure, firOutput.getOutput(), transformedResult, outputKlibPath, JSConfigurationKeysKt.getProduceKlibDir(configuration2), CommonConfigurationKeysKt.getMessageCollector(configuration2), diagnosticCollector, JSConfigurationKeysKt.getPerModuleOutputName(configuration2), JSConfigurationKeysKt.getWasmCompilation(configuration2), WasmTargetKt.getWasmTarget(configuration2));
        return new JsSerializedKlibPipelineArtifact(outputKlibPath, diagnosticCollector, configuration2);
    }

    private final void processIncrementalCompilationRoundIfNeeded(CompilerConfiguration configuration2, ModulesStructure moduleStructure, AnalyzedFirOutput firOutput, Fir2IrActualizedResult fir2IrResult) {
        if (!CommonConfigurationKeysKt.getIncrementalCompilation(configuration2)) {
            return;
        }
        boolean shouldGoToNextIcRound = KlibKt.shouldGoToNextIcRound((CompilerConfiguration)moduleStructure.getCompilerConfiguration(), () -> WebKlibSerializationPipelinePhase.processIncrementalCompilationRoundIfNeeded$lambda$0(moduleStructure, firOutput, fir2IrResult));
        if (shouldGoToNextIcRound) {
            throw new IncrementalNextRoundException();
        }
    }

    public final void serializeFirKlib(@NotNull ModulesStructure moduleStructure, @NotNull List<ModuleCompilerAnalyzedOutput> firOutputs, @NotNull Fir2IrActualizedResult fir2IrActualizedResult, @NotNull String outputKlibPath, boolean nopack, @NotNull MessageCollector messageCollector2, @NotNull BaseDiagnosticsCollector diagnosticsReporter, @Nullable String jsOutputName, boolean useWasmPlatform, @Nullable WasmTarget wasmTarget) {
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter(firOutputs, (String)"firOutputs");
        Intrinsics.checkNotNullParameter((Object)fir2IrActualizedResult, (String)"fir2IrActualizedResult");
        Intrinsics.checkNotNullParameter((Object)outputKlibPath, (String)"outputKlibPath");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)diagnosticsReporter, (String)"diagnosticsReporter");
        Fir2KlibMetadataSerializer fir2KlibMetadataSerializer = new Fir2KlibMetadataSerializer(moduleStructure.getCompilerConfiguration(), firOutputs, fir2IrActualizedResult, false, false);
        IncrementalDataProvider incrementalDataProvider = JSConfigurationKeysKt.getIncrementalDataProvider(moduleStructure.getCompilerConfiguration());
        List icData = incrementalDataProvider != null ? KlibKt.getSerializedData((IncrementalDataProvider)incrementalDataProvider, fir2KlibMetadataSerializer.getSourceFiles()) : null;
        String string2 = moduleStructure.getCompilerConfiguration().get(CommonConfigurationKeys.MODULE_NAME);
        Intrinsics.checkNotNull((Object)string2);
        CompilerConfiguration compilerConfiguration = moduleStructure.getCompilerConfiguration();
        DiagnosticReporter diagnosticReporter = diagnosticsReporter;
        KlibSingleFileMetadataSerializer klibSingleFileMetadataSerializer = fir2KlibMetadataSerializer;
        List list = moduleStructure.getAllDependencies();
        IrModuleFragment irModuleFragment = fir2IrActualizedResult.getIrModuleFragment();
        IrBuiltIns irBuiltIns = fir2IrActualizedResult.getIrBuiltIns();
        List list2 = icData;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        KlibKt.serializeModuleIntoKlib((String)string2, (CompilerConfiguration)compilerConfiguration, (DiagnosticReporter)diagnosticReporter, (KlibSingleFileMetadataSerializer)klibSingleFileMetadataSerializer, (String)outputKlibPath, (List)list, (IrModuleFragment)irModuleFragment, (IrBuiltIns)irBuiltIns, (List)list2, (boolean)nopack, (boolean)false, (messageCollector2.hasErrors() || diagnosticsReporter.getHasErrors() ? 1 : 0) != 0, (KotlinAbiVersion)KotlinAbiVersion.Companion.getCURRENT(), (String)jsOutputName, (BuiltInsPlatform)(useWasmPlatform ? BuiltInsPlatform.WASM : BuiltInsPlatform.JS), (WasmTarget)wasmTarget);
    }

    private static final KlibSingleFileMetadataSerializer processIncrementalCompilationRoundIfNeeded$lambda$0(ModulesStructure $moduleStructure, AnalyzedFirOutput $firOutput, Fir2IrActualizedResult $fir2IrResult) {
        return new Fir2KlibMetadataSerializer($moduleStructure.getCompilerConfiguration(), $firOutput.getOutput(), $fir2IrResult, false, false);
    }
}

