/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.overloads.ConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0002J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/overloads/ConeCallConflictResolver;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;)V", "chooseMaximallySpecificCandidates", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "candidates", "discriminateAbstracts", "", "filterOutEquivalentCalls", "", "areEquivalentTopLevelCallables", "first", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "firstCandidate", "second", "secondCandidate", "mappedArgumentsOrderRepresentation", "", "getMappedArgumentsOrderRepresentation", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;)[I", "java"})
@SourceDebugExtension(value={"SMAP\nConeEquivalentCallConflictResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,123:1\n1056#2:124\n1573#2:126\n1604#2,4:127\n34#3:125\n*S KotlinDebug\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n*L\n38#1:124\n113#1:126\n113#1:127,4\n54#1:125\n*E\n"})
public final class ConeEquivalentCallConflictResolver
extends ConeCallConflictResolver {
    @NotNull
    private final InferenceComponents inferenceComponents;

    public ConeEquivalentCallConflictResolver(@NotNull InferenceComponents inferenceComponents) {
        Intrinsics.checkNotNullParameter((Object)inferenceComponents, (String)"inferenceComponents");
        this.inferenceComponents = inferenceComponents;
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates) {
        Iterable $this$sortedBy$iv = candidates;
        boolean $i$f$sortedBy = false;
        List fromSourceFirst = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Candidate it = (Candidate)a;
                boolean bl = false;
                boolean bl2 = ((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source;
                it = (Candidate)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Boolean.valueOf(((FirDeclaration)it.getSymbol().getFir()).getModuleData().getSession().getKind() != FirSession.Kind.Source));
            }
        });
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : fromSourceFirst) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableDeclaration && ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)me).getSymbol()) == null) {
                Iterator resultIterator = result2.iterator();
                while (resultIterator.hasNext()) {
                    Candidate otherCandidate = (Candidate)resultIterator.next();
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableDeclaration) || ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)other).getSymbol()) != null || !this.areEquivalentTopLevelCallables((FirCallableDeclaration)me, myCandidate, (FirCallableDeclaration)other, otherCandidate)) continue;
                    FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)other;
                    boolean $i$f$isExpect = false;
                    if (!$this$isExpect$iv.getStatus().isExpect()) continue block0;
                    $this$isExpect$iv = (FirMemberDeclaration)me;
                    $i$f$isExpect = false;
                    if ($this$isExpect$iv.getStatus().isExpect()) continue block0;
                    resultIterator.remove();
                }
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableDeclaration first, Candidate firstCandidate, FirCallableDeclaration second, Candidate secondCandidate) {
        if (!Intrinsics.areEqual((Object)first.getSymbol().getCallableId(), (Object)second.getSymbol().getCallableId())) {
            return false;
        }
        if (Intrinsics.areEqual((Object)first.getModuleData(), (Object)second.getModuleData()) && first.getModuleData().getSession().getKind() == FirSession.Kind.Source) {
            return false;
        }
        if (first instanceof FirVariable != second instanceof FirVariable) {
            return false;
        }
        if (!Arrays.equals(this.getMappedArgumentsOrderRepresentation(firstCandidate), this.getMappedArgumentsOrderRepresentation(secondCandidate))) {
            return false;
        }
        FirStandardOverrideChecker overrideChecker = new FirStandardOverrideChecker(this.inferenceComponents.getSession());
        return first instanceof FirProperty && second instanceof FirProperty ? overrideChecker.isOverriddenProperty(first, (FirProperty)second, true) && overrideChecker.isOverriddenProperty(second, (FirProperty)first, true) : (first instanceof FirSimpleFunction && second instanceof FirSimpleFunction ? overrideChecker.isOverriddenFunction((FirSimpleFunction)first, (FirSimpleFunction)second, true) && overrideChecker.isOverriddenFunction((FirSimpleFunction)second, (FirSimpleFunction)first, true) : false);
    }

    /*
     * WARNING - void declaration
     */
    private final int[] getMappedArgumentsOrderRepresentation(Candidate $this$mappedArgumentsOrderRepresentation) {
        void $this$mapIndexedTo$iv$iv;
        Object obj = $this$mappedArgumentsOrderRepresentation.getSymbol().getFir();
        FirFunction firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction function2 = firFunction;
        Iterable $this$mapIndexed$iv = function2.getValueParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo22 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void it;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)((int)index2)));
        }
        Map parametersToIndices = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        if (!$this$mappedArgumentsOrderRepresentation.getArgumentMappingInitialized()) {
            return null;
        }
        LinkedHashMap<ConeResolutionAtom, FirValueParameter> mapping = $this$mappedArgumentsOrderRepresentation.getArgumentMapping();
        int n = 0;
        int n3 = mapping.size() + 1;
        int[] $i$f$mapIndexedTo22 = new int[n3];
        while (n < n3) {
            index$iv$iv = n++;
            $i$f$mapIndexedTo22[index$iv$iv] = function2.getValueParameters().size();
        }
        int[] result2 = $i$f$mapIndexedTo22;
        Iterator iterator2 = ((Iterable)mapping.values()).iterator();
        n3 = 0;
        while (iterator2.hasNext()) {
            int index3 = n3++;
            FirValueParameter parameter = (FirValueParameter)iterator2.next();
            Integer n4 = (Integer)parametersToIndices.get(parameter);
            if (n4 == null) {
                throw new IllegalStateException("Unmapped argument in arguments mapping".toString());
            }
            result2[index3 + 1] = n4;
        }
        return result2;
    }
}

