/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilder;
import org.jetbrains.kotlin.parsing.SemanticWhitespaceAwarePsiBuilderAdapter;

public class TruncatedSemanticWhitespaceAwarePsiBuilder
extends SemanticWhitespaceAwarePsiBuilderAdapter {
    private final int myEOFPosition;

    public TruncatedSemanticWhitespaceAwarePsiBuilder(SemanticWhitespaceAwarePsiBuilder builder2, int eofPosition) {
        super(builder2);
        this.myEOFPosition = eofPosition;
    }

    public boolean eof() {
        return super.eof() || this.isOffsetBeyondEof(this.getCurrentOffset());
    }

    public String getTokenText() {
        if (this.eof()) {
            return null;
        }
        return super.getTokenText();
    }

    public IElementType getTokenType() {
        if (this.eof()) {
            return null;
        }
        return super.getTokenType();
    }

    public IElementType lookAhead(int steps) {
        if (this.eof()) {
            return null;
        }
        int rawLookAheadSteps = this.rawLookAhead(steps);
        if (this.isOffsetBeyondEof(this.rawTokenTypeStart(rawLookAheadSteps))) {
            return null;
        }
        return super.rawLookup(rawLookAheadSteps);
    }

    private int rawLookAhead(int steps) {
        int cur = 0;
        while (steps > 0) {
            IElementType rawTokenType = this.rawLookup(++cur);
            while (rawTokenType != null && this.isWhitespaceOrComment(rawTokenType)) {
                rawTokenType = this.rawLookup(++cur);
            }
            --steps;
        }
        return cur;
    }

    private boolean isOffsetBeyondEof(int offsetFromCurrent) {
        return this.myEOFPosition >= 0 && offsetFromCurrent >= this.myEOFPosition;
    }
}

