/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleBuilder;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.CliCompilerUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.modules.Module;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0001H\u0000\u001a\u0019\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"configureModuleChunk", "Lorg/jetbrains/kotlin/cli/common/modules/ModuleChunk;", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "buildFile", "Ljava/io/File;", "targetDescription", "", "main", "", "args", "", "([Ljava/lang/String;)V", "cli"})
@SourceDebugExtension(value={"SMAP\nK2JVMCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2JVMCompiler.kt\norg/jetbrains/kotlin/cli/jvm/K2JVMCompilerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1#2:346\n1563#3:347\n1634#3,3:348\n*S KotlinDebug\n*F\n+ 1 K2JVMCompiler.kt\norg/jetbrains/kotlin/cli/jvm/K2JVMCompilerKt\n*L\n340#1:347\n340#1:348,3\n*E\n"})
public final class K2JVMCompilerKt {
    @NotNull
    public static final ModuleChunk configureModuleChunk(@NotNull CompilerConfiguration $this$configureModuleChunk, @NotNull K2JVMCompilerArguments arguments, @Nullable File buildFile) {
        ModuleChunk moduleChunk;
        File destination;
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$configureModuleChunk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        String string = arguments.getDestination();
        if (string != null) {
            String it = string;
            boolean bl = false;
            file = new File(it);
        } else {
            file = destination = null;
        }
        if (buildFile != null) {
            MessageCollector messageCollector2 = $this$configureModuleChunk.getNotNull(CommonConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)messageCollector2, (String)"getNotNull(...)");
            MessageCollector messageCollector3 = messageCollector2;
            if (destination != null) {
                K2JVMCompilerKt.configureModuleChunk$strongWarning(messageCollector3, "The '-d' option with a directory destination is ignored because '-Xbuild-file' is specified");
            }
            if (arguments.getJavaSourceRoots() != null) {
                K2JVMCompilerKt.configureModuleChunk$strongWarning(messageCollector3, "The '-Xjava-source-roots' option is ignored because '-Xbuild-file' is specified");
            }
            if (arguments.getJavaPackagePrefix() != null) {
                K2JVMCompilerKt.configureModuleChunk$strongWarning(messageCollector3, "The '-Xjava-package-prefix' option is ignored because '-Xbuild-file' is specified");
            }
            JvmArgumentsKt.configureContentRootsFromClassPath($this$configureModuleChunk, arguments);
            FilteringMessageCollector sanitizedCollector = new FilteringMessageCollector(messageCollector3, CompilerMessageSeverity.VERBOSE::contains);
            $this$configureModuleChunk.put(JVMConfigurationKeys.MODULE_XML_FILE, buildFile);
            ModuleChunk moduleChunk2 = CompileEnvironmentUtil.loadModuleChunk(buildFile, sanitizedCollector);
            Intrinsics.checkNotNull((Object)moduleChunk2);
            moduleChunk = moduleChunk2;
        } else {
            Object object;
            String string2;
            if (destination != null) {
                String string3 = destination.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                if (StringsKt.endsWith$default((String)string3, (String)".jar", (boolean)false, (int)2, null)) {
                    $this$configureModuleChunk.put(JVMConfigurationKeys.OUTPUT_JAR, destination);
                } else {
                    $this$configureModuleChunk.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, destination);
                }
            }
            if ((string2 = $this$configureModuleChunk.get(CommonConfigurationKeys.MODULE_NAME)) == null) {
                string2 = "main";
            }
            if ((object = destination) == null || (object = ((File)object).getPath()) == null) {
                object = ".";
            }
            ModuleBuilder module2 = new ModuleBuilder(string2, (String)object, "java-production");
            CliCompilerUtilsKt.configureFromArgs(module2, arguments);
            moduleChunk = new ModuleChunk(CollectionsKt.listOf((Object)module2));
        }
        return moduleChunk;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String targetDescription(@NotNull ModuleChunk $this$targetDescription) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$targetDescription, (String)"<this>");
        List<Module> list = $this$targetDescription.getModules();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getModules(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void input;
            Module module2 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(input.getModuleName() + '-' + input.getModuleType());
        }
        List names = (List)destination$iv$iv;
        boolean bl = false;
        String string = (String)CollectionsKt.singleOrNull((List)names);
        if (string == null) {
            string = CollectionsKt.joinToString$default((Iterable)names, null, null, null, (int)0, null, null, (int)63, null);
        }
        return string;
    }

    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        K2JVMCompiler.Companion.main(args);
    }

    private static final void configureModuleChunk$strongWarning(MessageCollector messageCollector2, String message2) {
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, message2, null, 4, null);
    }
}

