/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallableReferenceCompatibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CallableReferenceCompatibilityChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LanguageFeature typeInferenceForCallableReferencesFeature = LanguageFeature.TypeInferenceOnGenericsForCallableReferences;
        if (context2.getLanguageVersionSettings().supportsFeature(typeInferenceForCallableReferencesFeature)) {
            return;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedArgument = iterator2.next().getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                ResolvedCall<? extends CallableDescriptor> callableReferenceResolvedCall;
                KtCallableReferenceExpression argumentExpression;
                KtExpression ktExpression = argument.getArgumentExpression();
                if ((ktExpression instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)ktExpression : null) == null) continue;
                argumentExpression = argumentExpression;
                KtElement ktElement = argumentExpression.getCallableReference();
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null) continue;
                Call call = callableReferenceResolvedCall.getCall();
                Intrinsics.checkNotNullExpressionValue((Object)call, (String)"getCall(...)");
                if (!CallUtilKt.isCallableReference(call)) continue;
                List<TypeParameterDescriptor> list = callableReferenceResolvedCall.getCandidateDescriptor().getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
                if (!(!((Collection)list).isEmpty())) continue;
                context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)argumentExpression, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)typeInferenceForCallableReferencesFeature), (Object)context2.getLanguageVersionSettings())));
            }
        }
    }
}

