/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015*\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015*\u00020\u0013H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "extractTypeParamName", "Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "extractTypeParamNames", "", "ref", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "originalBounds", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "unwrapBound", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirCyclicTypeBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCyclicTypeBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1179#2,2:83\n1253#2,2:85\n1360#2:87\n1446#2,5:88\n1256#2:93\n1855#2,2:94\n766#2:96\n857#2,2:97\n1855#2:99\n766#2:100\n857#2,2:101\n1603#2,9:103\n1855#2:112\n1856#2:114\n1612#2:115\n1855#2,2:116\n1856#2:118\n1360#2:119\n1446#2,5:120\n1603#2,9:125\n1855#2:134\n1856#2:136\n1612#2:137\n1855#2,2:138\n748#2,10:140\n1#3:113\n1#3:135\n*S KotlinDebug\n*F\n+ 1 FirCyclicTypeBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCyclicTypeBoundsChecker\n*L\n26#1:83,2\n26#1:85,2\n27#1:87\n27#1:88,5\n26#1:93\n46#1:94,2\n50#1:96\n50#1:97,2\n51#1:99\n54#1:100\n54#1:101,2\n55#1:103,9\n55#1:112\n55#1:114\n55#1:115\n59#1:116,2\n51#1:118\n66#1:119\n66#1:120,5\n77#1:125,9\n77#1:134\n77#1:136\n77#1:137\n37#1:138,2\n42#1:140,10\n55#1:113\n77#1:135\n*E\n"})
public final class FirCyclicTypeBoundsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirCyclicTypeBoundsChecker INSTANCE = new FirCyclicTypeBoundsChecker();

    private FirCyclicTypeBoundsChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        FirTypeRef it;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        if (declaration instanceof FirConstructor || declaration instanceof FirTypeAlias) {
            return;
        }
        Set processed = new LinkedHashSet();
        Set cycles = new LinkedHashSet();
        Iterable $this$associate$iv = ((FirMemberDeclaration)declaration).getTypeParameters();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Map map = destination$iv$iv;
            FirTypeParameterRef param = (FirTypeParameterRef)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = param.getSymbol().getResolvedBounds();
            Name name2 = param.getSymbol().getName();
            boolean $i$f$flatMap = false;
            void var21_37 = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
                it = (FirResolvedTypeRef)element$iv$iv2;
                boolean bl2 = false;
                Iterable list$iv$iv = INSTANCE.extractTypeParamNames(it);
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            param = TuplesKt.to((Object)name2, (Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
            map.put(param.getFirst(), param.getSecond());
        }
        Map graph = destination$iv$iv;
        Function1 graphFunc2 = (Function1)new Function1<Name, Set<? extends Name>>((Map<Name, ? extends Set<Name>>)graph){
            final /* synthetic */ Map<Name, Set<Name>> $graph;
            {
                this.$graph = $graph;
                super(1);
            }

            @NotNull
            public final Set<Name> invoke(@NotNull Name name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                return this.$graph.getOrDefault(name2, SetsKt.emptySet());
            }
        };
        List path2 = new ArrayList();
        Iterable $this$forEach$iv = ((FirMemberDeclaration)declaration).getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef param = (FirTypeParameterRef)element$iv;
            boolean bl = false;
            FirCyclicTypeBoundsChecker.check$findCycles(processed, path2, (Function1<? super Name, ? extends Set<Name>>)graphFunc2, cycles, param.getSymbol().getName());
        }
        if (!((Collection)cycles).isEmpty()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$forEach$iv = ((FirMemberDeclaration)declaration).getTypeParameters();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeParameterRef it2 = (FirTypeParameterRef)element$iv$iv;
                boolean bl3 = false;
                if (!cycles.contains(it2.getSymbol().getName())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list2;
                FirTypeParameterRef param = (FirTypeParameterRef)element$iv;
                boolean bl = false;
                if (declaration instanceof FirRegularClass) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    void $this$filterTo$iv$iv2;
                    Iterable $this$filter$iv2 = INSTANCE.originalBounds(param.getSymbol());
                    boolean $i$f$filter2 = false;
                    Iterable bl3 = $this$filter$iv2;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        FirTypeRef it3 = (FirTypeRef)element$iv$iv;
                        boolean bl4 = false;
                        if (!CollectionsKt.contains((Iterable)cycles, (Object)INSTANCE.extractTypeParamName(FirTypeUtilsKt.getConeType(it3)))) continue;
                        destination$iv$iv4.add(element$iv$iv);
                    }
                    $this$filter$iv2 = (List)destination$iv$iv4;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
                    destination$iv$iv4 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        KtSourceElement it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl5 = false;
                        it = (FirTypeRef)element$iv$iv;
                        boolean bl6 = false;
                        if (it.getSource() == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv4.add(it$iv$iv);
                    }
                    list2 = (List)destination$iv$iv4;
                } else {
                    list2 = CollectionsKt.listOf((Object)param.getSource());
                }
                List targets = list2;
                Iterable $this$forEach$iv2 = targets;
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    KtSourceElement it4 = (KtSourceElement)element$iv2;
                    boolean bl8 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)it4, FirErrors.INSTANCE.getCYCLIC_GENERIC_UPPER_BOUND(), (DiagnosticContext)context, null, 8, null);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeRef> originalBounds(FirTypeParameterSymbol $this$originalBounds) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$originalBounds.getResolvedBounds();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.unwrapBound(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<FirTypeRef> unwrapBound(FirTypeRef $this$unwrapBound) {
        List list2;
        if ($this$unwrapBound instanceof FirErrorTypeRef && ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic() instanceof ConeCyclicTypeBound) {
            ConeDiagnostic coneDiagnostic = ((FirErrorTypeRef)$this$unwrapBound).getDiagnostic();
            Intrinsics.checkNotNull((Object)coneDiagnostic, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.resolve.diagnostics.ConeCyclicTypeBound");
            list2 = ((ConeCyclicTypeBound)coneDiagnostic).getBounds();
        } else {
            list2 = CollectionsKt.listOf((Object)$this$unwrapBound);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Name> extractTypeParamNames(FirTypeRef ref) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.unwrapBound(ref);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Name it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.extractTypeParamName(FirTypeUtilsKt.getConeType(it)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final Name extractTypeParamName(ConeKotlinType type2) {
        ConeSimpleKotlinType coneSimpleKotlinType = ConeTypesKt.unwrapDefinitelyNotNull(ConeTypeUtilsKt.lowerBoundIfFlexible(type2));
        Object object = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
        return object != null && (object = ((ConeTypeParameterType)object).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object).getName() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final void check$findCycles(Set<Name> processed, List<Name> path2, Function1<? super Name, ? extends Set<Name>> graphFunc2, Set<Name> cycles, Name node) {
        if (processed.add(node)) {
            path2.add(node);
            Iterable $this$forEach$iv = (Iterable)graphFunc2.invoke((Object)node);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Name nextNode = (Name)element$iv;
                boolean bl = false;
                FirCyclicTypeBoundsChecker.check$findCycles(processed, path2, graphFunc2, cycles, nextNode);
            }
            path2.remove(path2.size() - 1);
        } else {
            void $this$dropWhile$iv;
            Iterable $this$forEach$iv = path2;
            Set<Name> set = cycles;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                Name it = (Name)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)node)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            set.addAll(list$iv);
        }
    }
}

