/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirDeprecatedTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "typeAliasSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDeprecatedTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeprecatedTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirDeprecatedTypeChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,51:1\n24#2,4:52\n*S KotlinDebug\n*F\n+ 1 FirDeprecatedTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirDeprecatedTypeChecker\n*L\n25#1:52,4\n*E\n"})
public final class FirDeprecatedTypeChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirDeprecatedTypeChecker INSTANCE = new FirDeprecatedTypeChecker();

    private FirDeprecatedTypeChecker() {
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        KtSourceElement ktSourceElement = typeRef.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (source.getKind() instanceof KtFakeSourceElementKind) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = typeRef;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType resolved = coneClassLikeType;
        this.checkType(resolved, null, source, context, reporter2);
    }

    private final void checkType(ConeClassLikeType type2, FirTypeAliasSymbol typeAliasSymbol, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(type2.getLookupTag(), context.getSession());
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        FirDeprecationChecker.reportApiStatusIfNeeded$checkers$default(FirDeprecationChecker.INSTANCE, source, symbol2, context, reporter2, typeAliasSymbol, null, 32, null);
        if (symbol2 instanceof FirTypeAliasSymbol) {
            FirTypeAlias typeAlias = (FirTypeAlias)((FirTypeAliasSymbol)symbol2).getFir();
            FirLazyDeclarationResolverKt.lazyResolveToPhase(typeAlias, FirResolvePhase.TYPES);
            ConeTypeUtilsKt.forEachType(FirTypeUtilsKt.getConeType(typeAlias.getExpandedTypeRef()), (Function1<? super ConeKotlinType, Unit>)((Function1)new Function1<ConeKotlinType, Unit>(symbol2, source, context, reporter2){
                final /* synthetic */ FirClassLikeSymbol<?> $symbol;
                final /* synthetic */ KtSourceElement $source;
                final /* synthetic */ CheckerContext $context;
                final /* synthetic */ DiagnosticReporter $reporter;
                {
                    this.$symbol = $symbol;
                    this.$source = $source;
                    this.$context = $context;
                    this.$reporter = $reporter;
                    super(1);
                }

                public final void invoke(@NotNull ConeKotlinType it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it instanceof ConeClassLikeType) {
                        FirDeprecatedTypeChecker.access$checkType(FirDeprecatedTypeChecker.INSTANCE, (ConeClassLikeType)it, (FirTypeAliasSymbol)this.$symbol, this.$source, this.$context, this.$reporter);
                    }
                }
            }));
        }
    }

    public static final /* synthetic */ void access$checkType(FirDeprecatedTypeChecker $this, ConeClassLikeType type2, FirTypeAliasSymbol typeAliasSymbol, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter2) {
        $this.checkType(type2, typeAliasSymbol, source, context, reporter2);
    }
}

