/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsAbstractNativeIndexerChecker;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNativeSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsAbstractNativeIndexerChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.js"})
public final class FirJsNativeSetterChecker
extends FirJsAbstractNativeIndexerChecker {
    @NotNull
    public static final FirJsNativeSetterChecker INSTANCE = new FirJsNativeSetterChecker();

    private FirJsNativeSetterChecker() {
        super(JsStandardClassIds.Annotations.JsNativeSetter, "setter", 2);
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (!this.hasRequiredAnnotation(declaration, context)) {
            return;
        }
        super.check(declaration, context, reporter2);
        ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef());
        if (ConeBuiltinTypeUtilsKt.isUnit(returnType2)) {
            return;
        }
        if (declaration.getValueParameters().size() < 2) {
            return;
        }
        ConeKotlinType secondParameterType = FirTypeUtilsKt.getConeType(declaration.getValueParameters().get(1).getReturnTypeRef());
        if (TypeUtilsKt.isSubtypeOf$default(secondParameterType, returnType2, context.getSession(), false, 4, null)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNATIVE_SETTER_WRONG_RETURN_TYPE(), (DiagnosticContext)context, null, 8, null);
    }
}

