/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.MouseSupport;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.jline.utils.Log;

public abstract class AbstractTerminal
implements Terminal {
    protected final String name;
    protected final String type;
    protected final Map<Terminal.Signal, Terminal.SignalHandler> handlers = new HashMap<Terminal.Signal, Terminal.SignalHandler>();
    protected final Set<InfoCmp.Capability> bools = new HashSet<InfoCmp.Capability>();
    protected final Map<InfoCmp.Capability, Integer> ints = new HashMap<InfoCmp.Capability, Integer>();
    protected final Map<InfoCmp.Capability, String> strings = new HashMap<InfoCmp.Capability, String>();
    private MouseEvent lastMouseEvent = new MouseEvent(MouseEvent.Type.Moved, MouseEvent.Button.NoButton, EnumSet.noneOf(MouseEvent.Modifier.class), 0, 0);

    public AbstractTerminal(String name2, String type2) throws IOException {
        this(name2, type2, Terminal.SignalHandler.SIG_DFL);
    }

    public AbstractTerminal(String name2, String type2, Terminal.SignalHandler signalHandler) throws IOException {
        this.name = name2;
        this.type = type2;
        for (Terminal.Signal signal : Terminal.Signal.values()) {
            this.handlers.put(signal, signalHandler);
        }
    }

    @Override
    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler handler2) {
        Objects.requireNonNull(signal);
        Objects.requireNonNull(handler2);
        return this.handlers.put(signal, handler2);
    }

    @Override
    public void raise(Terminal.Signal signal) {
        Objects.requireNonNull(signal);
        Terminal.SignalHandler handler2 = this.handlers.get((Object)signal);
        if (handler2 != Terminal.SignalHandler.SIG_DFL && handler2 != Terminal.SignalHandler.SIG_IGN) {
            handler2.handle(signal);
        }
    }

    protected void echoSignal(Terminal.Signal signal) {
        int vcc;
        Attributes.ControlChar cc = null;
        switch (signal) {
            case INT: {
                cc = Attributes.ControlChar.VINTR;
                break;
            }
            case QUIT: {
                cc = Attributes.ControlChar.VQUIT;
                break;
            }
            case TSTP: {
                cc = Attributes.ControlChar.VSUSP;
            }
        }
        if (cc != null && (vcc = this.getAttributes().getControlChar(cc)) > 0 && vcc < 32) {
            this.writer().write(new char[]{'^', (char)(vcc + 64)}, 0, 2);
        }
    }

    @Override
    public Attributes enterRawMode() {
        Attributes prvAttr = this.getAttributes();
        Attributes newAttr = new Attributes(prvAttr);
        newAttr.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        newAttr.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        newAttr.setControlChar(Attributes.ControlChar.VMIN, 1);
        newAttr.setControlChar(Attributes.ControlChar.VTIME, 0);
        this.setAttributes(newAttr);
        return prvAttr;
    }

    @Override
    public boolean echo() {
        return this.getAttributes().getLocalFlag(Attributes.LocalFlag.ECHO);
    }

    @Override
    public boolean echo(boolean echo) {
        Attributes attr = this.getAttributes();
        boolean prev = attr.getLocalFlag(Attributes.LocalFlag.ECHO);
        if (prev != echo) {
            attr.setLocalFlag(Attributes.LocalFlag.ECHO, echo);
            this.setAttributes(attr);
        }
        return prev;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getKind() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public boolean puts(InfoCmp.Capability capability, Object ... params) {
        String str = this.getStringCapability(capability);
        if (str == null) {
            return false;
        }
        try {
            Curses.tputs(this.writer(), str, params);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return true;
    }

    @Override
    public boolean getBooleanCapability(InfoCmp.Capability capability) {
        return this.bools.contains((Object)capability);
    }

    @Override
    public Integer getNumericCapability(InfoCmp.Capability capability) {
        return this.ints.get((Object)capability);
    }

    @Override
    public String getStringCapability(InfoCmp.Capability capability) {
        return this.strings.get((Object)capability);
    }

    protected void parseInfoCmp() {
        String capabilities = null;
        if (this.type != null) {
            try {
                capabilities = InfoCmp.getInfoCmp(this.type);
            }
            catch (Exception e) {
                Log.warn("Unable to retrieve infocmp for type " + this.type, e);
            }
        }
        if (capabilities == null) {
            capabilities = InfoCmp.getLoadedInfoCmp("ansi");
        }
        InfoCmp.parseInfoCmp(capabilities, this.bools, this.ints, this.strings);
    }

    @Override
    public Cursor getCursorPosition(IntConsumer discarded) {
        return null;
    }

    @Override
    public boolean hasMouseSupport() {
        return MouseSupport.hasMouseSupport(this);
    }

    @Override
    public boolean trackMouse(Terminal.MouseTracking tracking) {
        return MouseSupport.trackMouse(this, tracking);
    }

    @Override
    public MouseEvent readMouseEvent() {
        this.lastMouseEvent = MouseSupport.readMouse(this, this.lastMouseEvent);
        return this.lastMouseEvent;
    }

    @Override
    public MouseEvent readMouseEvent(IntSupplier reader) {
        this.lastMouseEvent = MouseSupport.readMouse(reader, this.lastMouseEvent);
        return this.lastMouseEvent;
    }
}

