/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.components;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtSymbolInfoProvider;
import org.jetbrains.kotlin.analysis.api.descriptors.KtFe10AnalysisSession;
import org.jetbrains.kotlin.analysis.api.descriptors.components.KtFe10SymbolInfoProvider;
import org.jetbrains.kotlin.analysis.api.descriptors.components.base.Fe10KtAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.base.Kt1DescUtilsKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassOrObjectSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertyAccessorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertyGetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtVariableLikeSymbol;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.SimpleDeprecationInfo;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J2\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013H\u0002J\u0018\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10SymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSymbolInfoProvider;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/components/base/Fe10KtAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/descriptors/KtFe10AnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getAccessorDeprecation", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "property", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtPropertySymbol;", "accessor", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtPropertyAccessorSymbol;", "accessorDescriptorProvider", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "getAnnotationApplicableTargets", "", "Lorg/jetbrains/kotlin/descriptors/annotations/KotlinTarget;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassOrObjectSymbol;", "getDeprecation", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "annotationUseSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getGetterDeprecation", "getJavaGetterName", "Lorg/jetbrains/kotlin/name/Name;", "getJavaSetterName", "getSetterDeprecation", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nKtFe10SymbolInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFe10SymbolInfoProvider.kt\norg/jetbrains/kotlin/analysis/api/descriptors/components/KtFe10SymbolInfoProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class KtFe10SymbolInfoProvider
extends KtSymbolInfoProvider
implements Fe10KtAnalysisSessionComponent {
    @NotNull
    private final KtFe10AnalysisSession analysisSession;

    public KtFe10SymbolInfoProvider(@NotNull KtFe10AnalysisSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        this.analysisSession = analysisSession;
    }

    @Override
    @NotNull
    public KtFe10AnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.getAnalysisSession().getToken();
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        DeclarationDescriptor declarationDescriptor = Kt1DescUtilsKt.getSymbolDescriptor(symbol2);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        ForceResolveUtil.forceResolveAllContents(descriptor2);
        return this.getDeprecation(descriptor2);
    }

    @Override
    @Nullable
    public DeprecationInfo getDeprecation(@NotNull KtSymbol symbol2, @Nullable AnnotationUseSiteTarget annotationUseSiteTarget) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        AnnotationUseSiteTarget annotationUseSiteTarget2 = annotationUseSiteTarget;
        switch (annotationUseSiteTarget2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[annotationUseSiteTarget2.ordinal()]) {
            case 1: {
                if (!(symbol2 instanceof KtPropertySymbol)) break;
                KtPropertyGetterSymbol ktPropertyGetterSymbol = ((KtPropertySymbol)symbol2).getGetter();
                return this.getDeprecation(ktPropertyGetterSymbol != null ? (KtSymbol)ktPropertyGetterSymbol : symbol2);
            }
            case 2: {
                if (!(symbol2 instanceof KtPropertySymbol)) break;
                KtPropertySetterSymbol ktPropertySetterSymbol = ((KtPropertySymbol)symbol2).getSetter();
                return this.getDeprecation(ktPropertySetterSymbol != null ? (KtSymbol)ktPropertySetterSymbol : symbol2);
            }
            case 3: {
                if (!(symbol2 instanceof KtPropertySymbol)) break;
                KtCallableSymbol ktCallableSymbol = ((KtPropertySymbol)symbol2).getSetter();
                return this.getDeprecation(ktCallableSymbol != null && (ktCallableSymbol = ktCallableSymbol.getParameter()) != null ? (KtVariableLikeSymbol)ktCallableSymbol : (KtVariableLikeSymbol)symbol2);
            }
        }
        return this.getDeprecation(symbol2);
    }

    private final DeprecationInfo getDeprecation(DeclarationDescriptor descriptor2) {
        FieldDescriptor fieldDescriptor;
        if (descriptor2 instanceof PropertyDescriptor && (fieldDescriptor = ((PropertyDescriptor)descriptor2).getBackingField()) != null && fieldDescriptor.getAnnotations().hasAnnotation(DeprecationResolver.Companion.getJAVA_DEPRECATED())) {
            return new SimpleDeprecationInfo(DeprecationLevelValue.WARNING, false, null);
        }
        return (DeprecationInfo)CollectionsKt.firstOrNull(this.getAnalysisContext().getDeprecationResolver().getDeprecations(descriptor2));
    }

    private final DeprecationInfo getAccessorDeprecation(KtPropertySymbol property, KtPropertyAccessorSymbol accessor, Function1<? super PropertyDescriptor, ? extends PropertyAccessorDescriptor> accessorDescriptorProvider) {
        DescriptorBasedDeprecationInfo deprecation;
        PropertyAccessorDescriptor accessorDescriptor;
        DeclarationDescriptor declarationDescriptor = Kt1DescUtilsKt.getSymbolDescriptor(property);
        PropertyDescriptor propertyDescriptor = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
        if (propertyDescriptor == null) {
            return null;
        }
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        ForceResolveUtil.forceResolveAllContents(propertyDescriptor2);
        if (accessor != null) {
            declarationDescriptor = Kt1DescUtilsKt.getSymbolDescriptor(accessor);
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = declarationDescriptor instanceof PropertyAccessorDescriptor ? (PropertyAccessorDescriptor)declarationDescriptor : null;
            if (accessorDescriptor != null) {
                ForceResolveUtil.forceResolveAllContents(accessorDescriptor.getCorrespondingProperty());
                deprecation = (DescriptorBasedDeprecationInfo)CollectionsKt.firstOrNull(this.getAnalysisContext().getDeprecationResolver().getDeprecations(accessorDescriptor));
                if (deprecation != null) {
                    return deprecation;
                }
            }
        }
        if ((accessorDescriptor = (PropertyAccessorDescriptor)accessorDescriptorProvider.invoke((Object)propertyDescriptor2)) != null && (deprecation = (DescriptorBasedDeprecationInfo)CollectionsKt.firstOrNull(this.getAnalysisContext().getDeprecationResolver().getDeprecations(accessorDescriptor))) != null) {
            return deprecation;
        }
        return this.getDeprecation(propertyDescriptor2);
    }

    @Override
    @Nullable
    public DeprecationInfo getGetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.getAccessorDeprecation(symbol2, symbol2.getGetter(), (Function1<? super PropertyDescriptor, ? extends PropertyAccessorDescriptor>)((Function1)getGetterDeprecation.1.INSTANCE));
    }

    @Override
    @Nullable
    public DeprecationInfo getSetterDeprecation(@NotNull KtPropertySymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.getAccessorDeprecation(symbol2, symbol2.getSetter(), (Function1<? super PropertyDescriptor, ? extends PropertyAccessorDescriptor>)((Function1)getSetterDeprecation.1.INSTANCE));
    }

    @Override
    @NotNull
    public Name getJavaGetterName(@NotNull KtPropertySymbol symbol2) {
        PropertyDescriptor descriptor2;
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        DeclarationDescriptor declarationDescriptor = Kt1DescUtilsKt.getSymbolDescriptor(symbol2);
        PropertyDescriptor propertyDescriptor = descriptor2 = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
        if (descriptor2 instanceof SyntheticJavaPropertyDescriptor) {
            Name name2 = ((SyntheticJavaPropertyDescriptor)descriptor2).getGetMethod().getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            return name2;
        }
        if (descriptor2 != null) {
            if (JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2)) {
                Name name3 = descriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getName(...)");
                return name3;
            }
            PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
            if (propertyGetterDescriptor == null) {
                return SpecialNames.NO_NAME_PROVIDED;
            }
            PropertyGetterDescriptor getter2 = propertyGetterDescriptor;
            String string2 = DescriptorUtils.getJvmName(getter2);
            if (string2 == null) {
                String string3 = descriptor2.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                string2 = JvmAbi.getterName(string3);
            }
            Name name4 = Name.identifier(string2);
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            return name4;
        }
        PsiElement psiElement = symbol2.getPsi();
        Object object = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (object == null || (object = ((KtTypeParameterListOwnerStub)object).getName()) == null) {
            return SpecialNames.NO_NAME_PROVIDED;
        }
        Object ktPropertyName = object;
        Name name5 = Name.identifier(JvmAbi.getterName((String)ktPropertyName));
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        return name5;
    }

    @Override
    @Nullable
    public Name getJavaSetterName(@NotNull KtPropertySymbol symbol2) {
        Object object;
        block10: {
            block9: {
                KtProperty ktProperty;
                PropertyDescriptor descriptor2;
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                DeclarationDescriptor declarationDescriptor = Kt1DescUtilsKt.getSymbolDescriptor(symbol2);
                PropertyDescriptor propertyDescriptor = descriptor2 = declarationDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)declarationDescriptor : null;
                if (descriptor2 instanceof SyntheticJavaPropertyDescriptor) {
                    FunctionDescriptor functionDescriptor = ((SyntheticJavaPropertyDescriptor)descriptor2).getSetMethod();
                    return functionDescriptor != null ? functionDescriptor.getName() : null;
                }
                if (descriptor2 != null) {
                    if (!descriptor2.isVar()) {
                        return null;
                    }
                    if (JvmAnnotationUtilKt.hasJvmFieldAnnotation(descriptor2)) {
                        return descriptor2.getName();
                    }
                    PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
                    if (propertySetterDescriptor == null) {
                        return SpecialNames.NO_NAME_PROVIDED;
                    }
                    PropertySetterDescriptor setter2 = propertySetterDescriptor;
                    String string2 = DescriptorUtils.getJvmName(setter2);
                    if (string2 == null) {
                        String string3 = descriptor2.getName().asString();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
                        string2 = JvmAbi.setterName(string3);
                    }
                    return Name.identifier(string2);
                }
                PsiElement psiElement = symbol2.getPsi();
                object = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
                if (object == null) break block9;
                KtProperty it = ktProperty = object;
                boolean bl = false;
                object = it.isVar() ? ktProperty : null;
                if (object != null && (object = ((KtTypeParameterListOwnerStub)object).getName()) != null) break block10;
            }
            return SpecialNames.NO_NAME_PROVIDED;
        }
        Object ktPropertyName = object;
        return Name.identifier(JvmAbi.setterName((String)ktPropertyName));
    }

    @Override
    @Nullable
    public Set<KotlinTarget> getAnnotationApplicableTargets(@NotNull KtClassOrObjectSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        DeclarationDescriptor declarationDescriptor = Kt1DescUtilsKt.getSymbolDescriptor(symbol2);
        ClassDescriptor classDescriptor2 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        if (descriptor2.getKind() != ClassKind.ANNOTATION_CLASS) {
            return null;
        }
        return AnnotationChecker.Companion.applicableTargetSet(descriptor2);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotationUseSiteTarget.values().length];
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_GETTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.PROPERTY_SETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AnnotationUseSiteTarget.SETTER_PARAMETER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

