/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import com.intellij.mock.MockProject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.project.structure.KtSourceModule;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilderDsl;
import org.jetbrains.kotlin.analysis.project.structure.impl.KtModuleUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.impl.KtSourceModuleImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.platform.TargetPlatform;

@KtModuleBuilderDsl
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013J\u0014\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder;", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtModuleBuilder;", "kotlinCoreProjectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "sourceRoots", "", "Ljava/nio/file/Path;", "addSourceRoot", "", "path", "addSourceRoots", "paths", "", "build", "Lorg/jetbrains/kotlin/analysis/project/structure/KtSourceModule;", "collectVirtualFilesByRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "analysis-api-standalone"})
@SourceDebugExtension(value={"SMAP\nKtSourceModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtSourceModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1601#2,9:87\n1853#2:96\n1854#2:98\n1610#2:99\n1#3:97\n*S KotlinDebug\n*F\n+ 1 KtSourceModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder\n*L\n47#1:87,9\n47#1:96\n47#1:98\n47#1:99\n47#1:97\n*E\n"})
public final class KtSourceModuleBuilder
extends KtModuleBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    public String moduleName;
    @NotNull
    private LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final List<Path> sourceRoots;

    public KtSourceModuleBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinCoreProjectEnvironment), (String)"kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
        this.languageVersionSettings = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST, null, null, 12, null);
        this.sourceRoots = new ArrayList();
    }

    @NotNull
    public final String getModuleName() {
        String string2 = this.moduleName;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"moduleName");
        return null;
    }

    public final void setModuleName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.moduleName = string2;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings2) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"<set-?>");
        this.languageVersionSettings = languageVersionSettings2;
    }

    public final void addSourceRoot(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.sourceRoots.add(path);
    }

    public final void addSourceRoots(@NotNull Collection<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        this.sourceRoots.addAll(paths);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtSourceModule build() {
        void $this$mapNotNullTo$iv$iv;
        List<VirtualFile> virtualFiles = this.collectVirtualFilesByRoots();
        PsiManager psiManager2 = PsiManager.getInstance((Project)((Project)this.kotlinCoreProjectEnvironment.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)psiManager2, (String)"getInstance(...)");
        PsiManager psiManager3 = psiManager2;
        Iterable $this$mapNotNull$iv = virtualFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (psiManager3.findFile(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)((Project)this.kotlinCoreProjectEnvironment.getProject()), (Collection)virtualFiles);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        GlobalSearchScope contentScope = globalSearchScope;
        List<KtModule> list2 = this.getDirectRegularDependencies();
        List<KtModule> list3 = this.getDirectDependsOnDependencies();
        List<KtModule> list4 = this.getDirectFriendDependencies();
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
        return new KtSourceModuleImpl(list2, list3, list4, contentScope, targetPlatform, (Project)mockProject, this.getModuleName(), this.languageVersionSettings, psiFiles);
    }

    private final List<VirtualFile> collectVirtualFilesByRoots() {
        List list2;
        CoreLocalFileSystem coreLocalFileSystem = this.kotlinCoreProjectEnvironment.getEnvironment().getLocalFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)coreLocalFileSystem, (String)"getLocalFileSystem(...)");
        CoreLocalFileSystem localFileSystem = coreLocalFileSystem;
        List $this$collectVirtualFilesByRoots_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Path root : this.sourceRoots) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            List files2 = Files.isDirectory(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? KtModuleUtilsKt.collectSourceFilePaths(root) : (KtModuleUtilsKt.hasSuitableExtensionToAnalyse(root) ? CollectionsKt.listOf((Object)root) : CollectionsKt.emptyList());
            for (Path file2 : files2) {
                VirtualFile virtualFile2;
                if (localFileSystem.findFileByIoFile(file2.toFile()) == null) continue;
                Intrinsics.checkNotNull((Object)virtualFile2);
                VirtualFile virtualFile3 = virtualFile2;
                $this$collectVirtualFilesByRoots_u24lambda_u241.add(virtualFile3);
            }
        }
        return CollectionsKt.build((List)list2);
    }
}

