/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmRecordChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmRecordChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,111:1\n22#2,4:112\n54#3:116\n38#3:117\n17#3,2:118\n60#3:120\n68#3:122\n37#4:121\n1853#5,2:123\n1853#5:125\n1854#5:127\n39#6:126\n*S KotlinDebug\n*F\n+ 1 FirJvmRecordChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmRecordChecker\n*L\n34#1:112,4\n53#1:116\n58#1:117\n63#1:118,2\n68#1:120\n73#1:122\n68#1:121\n83#1:123,2\n90#1:125\n90#1:127\n98#1:126\n*E\n"})
public final class FirJvmRecordChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirJvmRecordChecker INSTANCE = new FirJvmRecordChecker();

    private FirJvmRecordChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        block19: {
            Modality modality$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            FirTypeRef firTypeRef = (FirTypeRef)CollectionsKt.firstOrNull(declaration.getSuperTypeRefs());
            if (firTypeRef != null) {
                FirTypeRef typeRef = firTypeRef;
                boolean bl = false;
                if (typeRef.getSource() != null) {
                    FirTypeRef $this$coneTypeSafe$iv = typeRef;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
                    if (Intrinsics.areEqual((Object)(coneClassLikeType != null ? FirHelpersKt.fullyExpandedClassId(coneClassLikeType, context2.getSession()) : null), (Object)JvmStandardClassIds.Java.INSTANCE.getRecord())) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)typeRef.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JAVA_LANG_RECORD_SUPERTYPE(), (DiagnosticContext)context2, null, 8, null);
                        return;
                    }
                }
            }
            if ((object = FirAnnotationUtilsKt.getAnnotationByClassId(declaration, JvmStandardClassIds.JVM_RECORD_ANNOTATION_CLASS_ID, context2.getSession())) == null || (object = ((FirAnnotation)object).getSource()) == null) {
                return;
            }
            Object annotationSource = object;
            LanguageVersionSettings languageVersionSettings2 = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
            if (!languageVersionSettings2.supportsFeature(LanguageFeature.JvmRecordSupport)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)((Object)LanguageFeature.JvmRecordSupport), (Object)languageVersionSettings2), (DiagnosticContext)context2, null, 16, null);
                return;
            }
            FirClassLikeDeclaration $this$isLocal$iv = declaration;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getLOCAL_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isInner$iv = declaration;
            boolean $i$f$isInner = false;
            if ($this$isInner$iv.getStatus().isInner()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getINNER_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirMemberDeclaration $this$isFinal$iv = declaration;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            if (!(modality == null ? true : (modality$iv = modality) == Modality.FINAL)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getNON_FINAL_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirClass $this$isEnumClass$iv = declaration;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getENUM_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            FirRegularClass $this$isData$iv = declaration;
            boolean $i$f$isData = false;
            if (!$this$isData$iv.getStatus().isData()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getNON_DATA_CLASS_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            Object object2 = DeclarationUtilsKt.primaryConstructorIfAny(declaration, context2.getSession());
            if (object2 != null && (object2 = ((FirFunctionSymbol)object2).getValueParameterSymbols()) != null) {
                Object params = object2;
                boolean bl2 = false;
                if (params.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)annotationSource, FirJvmErrors.INSTANCE.getJVM_RECORD_WITHOUT_PRIMARY_CONSTRUCTOR_PARAMETERS(), (DiagnosticContext)context2, null, 8, null);
                    return;
                }
                Iterable $this$forEach$iv = CollectionsKt.dropLast((List)params, (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameterSymbol param = (FirValueParameterSymbol)element$iv;
                    boolean bl3 = false;
                    if (!param.isVararg()) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)param.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_LAST_VARARG_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            Iterable $this$forEach$iv = declaration.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration decl = (FirDeclaration)element$iv;
                boolean bl4 = false;
                if (decl instanceof FirProperty) {
                    KtSourceElement ktSourceElement = decl.getSource();
                    boolean fromConstructor = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
                    if (((FirProperty)decl).isVar() && fromConstructor) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)decl.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_NOT_VAL_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                        continue;
                    }
                    if (fromConstructor || !DeclarationAttributesKt.getHasBackingField((FirProperty)decl) && ((FirProperty)decl).getDelegateFieldSymbol() == null) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)decl.getSource(), FirJvmErrors.INSTANCE.getFIELD_IN_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
                    continue;
                }
                if (!(decl instanceof FirField)) continue;
                FirDeclaration $this$isSynthetic$iv = decl;
                boolean $i$f$isSynthetic = false;
                if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)decl.getSource(), FirJvmErrors.INSTANCE.getDELEGATION_BY_IN_JVM_RECORD(), (DiagnosticContext)context2, null, 8, null);
            }
            FirTypeRef firTypeRef2 = (FirTypeRef)CollectionsKt.firstOrNull(declaration.getSuperTypeRefs());
            if (firTypeRef2 == null) break block19;
            FirTypeRef typeRef = firTypeRef2;
            boolean bl5 = false;
            KtSourceElement ktSourceElement = typeRef.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtRealSourceElementKind.INSTANCE)) {
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(typeRef, context2.getSession());
                if ((firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.CLASS) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirJvmErrors.INSTANCE.getJVM_RECORD_EXTENDS_CLASS(), (Object)FirTypeUtilsKt.getConeType(typeRef), (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }
}

