/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.utils.FirWebCommonHelpersKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"isTypeSupportedInJsInterop", "", "unexpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInFunctionReturnPosition", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.wasm"})
public final class FirWasmJsInteropTypesCheckerKt {
    private static final boolean isTypeSupportedInJsInterop(ConeKotlinType unexpandedType, boolean isInFunctionReturnPosition, FirSession session2) {
        FirRegularClassSymbol regularClassSymbol;
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType(unexpandedType, session2);
        if (ConeBuiltinTypeUtilsKt.isUnit(type2) || ConeBuiltinTypeUtilsKt.isNothing(type2)) {
            return isInFunctionReturnPosition;
        }
        ConeKotlinType nonNullable = TypeUtilsKt.withNullability$default(type2, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(session2), null, false, 12, null);
        if (ConeBuiltinTypeUtilsKt.isPrimitive(nonNullable) || ConeBuiltinTypeUtilsKt.isUnsignedType(nonNullable) || ConeBuiltinTypeUtilsKt.isString(nonNullable)) {
            return true;
        }
        if (nonNullable instanceof ConeTypeParameterType) {
            return true;
        }
        FirRegularClassSymbol firRegularClassSymbol = regularClassSymbol = TypeUtilsKt.toRegularClassSymbol(nonNullable, session2);
        boolean bl = firRegularClassSymbol != null ? FirWebCommonHelpersKt.isEffectivelyExternal(firRegularClassSymbol, session2) : false;
        if (bl) {
            return true;
        }
        if (FunctionalTypeUtilsKt.isBasicFunctionType(type2, session2)) {
            Object[] arguments2 = type2.getTypeArguments();
            int n = ArraysKt.getLastIndex((Object[])arguments2);
            for (int i2 = 0; i2 < n; ++i2) {
                ConeKotlinType argType;
                if (ConeTypeProjectionKt.getType((ConeTypeProjection)arguments2[i2]) == null) {
                    return false;
                }
                if (FirWasmJsInteropTypesCheckerKt.isTypeSupportedInJsInterop(argType, false, session2)) continue;
                return false;
            }
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType((ConeTypeProjection)ArraysKt.last((Object[])arguments2));
            if (coneKotlinType == null) {
                return false;
            }
            ConeKotlinType returnType2 = coneKotlinType;
            return FirWasmJsInteropTypesCheckerKt.isTypeSupportedInJsInterop(returnType2, true, session2);
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isTypeSupportedInJsInterop(ConeKotlinType unexpandedType, boolean isInFunctionReturnPosition, FirSession session2) {
        return FirWasmJsInteropTypesCheckerKt.isTypeSupportedInJsInterop(unexpandedType, isInFunctionReturnPosition, session2);
    }
}

