/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.KotlinMetadataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.MetadataUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDataFinder;", "finder", "Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "(Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;)V", "getFinder", "()Lorg/jetbrains/kotlin/serialization/deserialization/KotlinMetadataFinder;", "findClassData", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "deserialization.common"})
@SourceDebugExtension(value={"SMAP\nMetadataUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetadataUtil.kt\norg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n288#2,2:46\n*S KotlinDebug\n*F\n+ 1 MetadataUtil.kt\norg/jetbrains/kotlin/serialization/deserialization/MetadataClassDataFinder\n*L\n21#1:46,2\n*E\n"})
public final class MetadataClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinMetadataFinder finder;

    public MetadataClassDataFinder(@NotNull KotlinMetadataFinder finder) {
        Intrinsics.checkNotNullParameter((Object)finder, (String)"finder");
        this.finder = finder;
    }

    @NotNull
    public final KotlinMetadataFinder getFinder() {
        return this.finder;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        ClassData classData;
        Object v2;
        BuiltInsBinaryVersion version2;
        NameResolverImpl nameResolver2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            ClassId topLevelClassId2 = (ClassId)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)((Function1)findClassData.topLevelClassId.1.INSTANCE)));
            InputStream inputStream = this.finder.findMetadata(topLevelClassId2);
            if (inputStream == null) {
                return null;
            }
            InputStream stream = inputStream;
            Triple<ProtoBuf.PackageFragment, NameResolverImpl, BuiltInsBinaryVersion> triple = MetadataUtilKt.readProto(stream);
            ProtoBuf.PackageFragment message2 = (ProtoBuf.PackageFragment)triple.component1();
            nameResolver2 = (NameResolverImpl)triple.component2();
            version2 = (BuiltInsBinaryVersion)triple.component3();
            List<ProtoBuf.Class> list2 = message2.getClass_List();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getClass_List(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ProtoBuf.Class classProto2 = (ProtoBuf.Class)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)NameResolverUtilKt.getClassId(nameResolver2, classProto2.getFqName()), (Object)classId)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        ProtoBuf.Class clazz = v2;
        if (clazz != null) {
            ProtoBuf.Class classProto3 = clazz;
            boolean bl = false;
            NameResolver nameResolver3 = nameResolver2;
            BinaryVersion binaryVersion = version2;
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            classData = new ClassData(nameResolver3, classProto3, binaryVersion, sourceElement);
        } else {
            classData = null;
        }
        return classData;
    }
}

